/*
 * Decompiled with CFR 0.152.
 */
package misc.grid.gradients;

import java.util.Arrays;
import javax.vecmath.Vector3f;
import misc.grid.RegularGrid3i;
import misc.grid.gradients.AbstractGradientCache;
import misc.grid.gradients.GradientFunction;

final class FixedSizeCache
extends AbstractGradientCache {
    static final int capacity = 2000;
    private final FixedGradientHashMap _gradient_cache = new FixedGradientHashMap(2000);
    private final Vector3f vec1 = new Vector3f();

    FixedSizeCache(RegularGrid3i volume, GradientFunction gradient_function) {
        super(volume, gradient_function);
    }

    private int get_index(int vc_index) {
        int buffer_index = this._gradient_cache.get_index(vc_index);
        if (buffer_index < 0) {
            this._gradient_function.gradient_at(vc_index, this.vec1);
            buffer_index = this._gradient_cache.insert(vc_index, this.vec1);
        }
        return buffer_index;
    }

    @Override
    public void gradient_at(int index, Vector3f gradient) {
        int pos = 3 * this.get_index(index);
        gradient.x = this._gradient_cache._gradient_buffer[pos];
        gradient.y = this._gradient_cache._gradient_buffer[pos + 1];
        gradient.z = this._gradient_cache._gradient_buffer[pos + 2];
    }

    private static final class FixedGradientHashMap {
        private final int[] _hashmap;
        private final int[] _index_buffer;
        final float[] _gradient_buffer;
        private int _next;

        public FixedGradientHashMap(int capacity) {
            int hashmapsize = (capacity * 2 - 1) * 2 - 1;
            this._hashmap = new int[hashmapsize];
            this._index_buffer = new int[capacity];
            this._gradient_buffer = new float[3 * capacity];
            Arrays.fill(this._hashmap, -1);
            Arrays.fill(this._index_buffer, -1);
            this._next = 0;
        }

        public int insert(int index, Vector3f gradient) {
            int h = this.hash(index);
            if (this._index_buffer[this._next] >= 0) {
                this._hashmap[this.hash((int)this._index_buffer[this._next])] = -1;
            }
            this._hashmap[h] = this._next;
            this._index_buffer[this._next] = index;
            this._gradient_buffer[this._next * 3] = gradient.x;
            this._gradient_buffer[this._next * 3 + 1] = gradient.y;
            this._gradient_buffer[this._next * 3 + 2] = gradient.z;
            int result = this._next++;
            this._next %= this._index_buffer.length;
            return result;
        }

        public int get_index(int vc_index) {
            int pos = this._hashmap[this.hash(vc_index)];
            return pos < 0 || this._index_buffer[pos] != vc_index ? -1 : pos;
        }

        public int hash(int index) {
            return index % this._hashmap.length;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append(Arrays.toString(this._hashmap));
            buff.append("\nnext: " + this._next);
            int i = 0;
            while (i < this._index_buffer.length) {
                Vector3f v = new Vector3f(this._gradient_buffer[3 * i], this._gradient_buffer[3 * i + 1], this._gradient_buffer[3 * i + 2]);
                buff.append("\n" + this._index_buffer[i] + "\t(" + this.hash(this._index_buffer[i]) + ")\t -> " + v);
                ++i;
            }
            return buff.toString();
        }
    }
}

