/*
 * Decompiled with CFR 0.152.
 */
package misc.grid.gradients;

import misc.grid.RegularGrid3i;
import misc.grid.gradients.FixedSizeCache;
import misc.grid.gradients.GradientFunction;
import misc.grid.gradients.Precalculator;

public enum GradientCachingMethod {
    ON_THE_FLY{

        @Override
        ThreadLocal<GradientFunction> get_cached_implementation(RegularGrid3i volume, GradientFunction gradient_function) {
            return GradientCachingMethod.create_same_instance_thread_local(gradient_function);
        }
    }
    ,
    PRE_CALC{

        @Override
        ThreadLocal<GradientFunction> get_cached_implementation(RegularGrid3i volume, GradientFunction gradient_function) {
            return GradientCachingMethod.create_same_instance_thread_local(new Precalculator(volume, gradient_function));
        }
    }
    ,
    HASH{

        @Override
        ThreadLocal<GradientFunction> get_cached_implementation(RegularGrid3i volume, GradientFunction gradient_function) {
            return GradientCachingMethod.create_new_instance_thread_local(volume, gradient_function);
        }
    };


    private GradientCachingMethod() {
    }

    abstract ThreadLocal<GradientFunction> get_cached_implementation(RegularGrid3i var1, GradientFunction var2);

    private static ThreadLocal<GradientFunction> create_new_instance_thread_local(final RegularGrid3i volume, final GradientFunction gradient_function) {
        return new ThreadLocal<GradientFunction>(){

            @Override
            protected GradientFunction initialValue() {
                return new FixedSizeCache(volume, gradient_function);
            }
        };
    }

    private static ThreadLocal<GradientFunction> create_same_instance_thread_local(final GradientFunction gradient_function) {
        return new ThreadLocal<GradientFunction>(){

            @Override
            protected GradientFunction initialValue() {
                return gradient_function;
            }
        };
    }

    /* synthetic */ GradientCachingMethod(String string, int n, GradientCachingMethod gradientCachingMethod) {
        this();
    }
}

