/*
 * Decompiled with CFR 0.152.
 */
package misc.grid.gradients;

import javax.vecmath.Vector3f;
import misc.grid.MutableRegularGrid3i;
import misc.grid.PaddedRegularGrid3i;
import misc.grid.VoxelCube;
import misc.grid.gradients.GradientCachingMethod;
import misc.grid.gradients.GradientFunction;
import misc.grid.gradients.GradientFunctionFactory;
import misc.grid.gradients.GradientFunctionType;
import org.junit.Assert;

public abstract class GradientFunctionAbstractTest {
    protected final GradientFunction _gradient_function;
    protected final MutableRegularGrid3i _volume;
    private final float _test_accuracy;
    private final Vector3f _result_vector = new Vector3f();

    public GradientFunctionAbstractTest(int cube_dimensions, float test_accuracy, GradientFunctionType type) {
        this._test_accuracy = test_accuracy;
        this._volume = new VoxelCube(cube_dimensions, cube_dimensions, cube_dimensions, 1);
        PaddedRegularGrid3i padded_volume = new PaddedRegularGrid3i(this._volume, type.get_filter_radius());
        this._gradient_function = GradientFunctionFactory.create_gradient_function(padded_volume, type, GradientCachingMethod.ON_THE_FLY);
    }

    protected void assert_result_values(double x, double y, double z) {
        Assert.assertEquals((double)x, (double)this._result_vector.x, (double)this._test_accuracy);
        Assert.assertEquals((double)y, (double)this._result_vector.y, (double)this._test_accuracy);
        Assert.assertEquals((double)z, (double)this._result_vector.z, (double)this._test_accuracy);
    }

    protected void gradient_at(int x, int y, int z) {
        this._gradient_function.gradient_at(x, y, z, this._result_vector);
    }
}

