/*
 * Decompiled with CFR 0.152.
 */
package misc.grid.gradients;

import java.util.HashMap;
import java.util.Map;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.Segment;
import main.tools.ToolSegGen;
import misc.grid.BitCube;
import misc.grid.RegularGrid3i;
import misc.grid.gradients.GradientCachingMethod;
import misc.grid.gradients.GradientFunction;
import misc.grid.gradients.GradientFunctionType;
import misc.messages.YObservable;
import misc.messages.YObserver;

public final class GradientFunctionFactory
implements YObserver {
    private static GradientFunctionFactory _instance = new GradientFunctionFactory();
    private GradientCacheRepository _repository = new GradientCacheRepository();
    private GradientCachingMethod _gradient_caching_method;
    private GradientFunctionType _gradient_function_type;

    private GradientFunctionFactory() {
        MasterControl.get_is().addObserver(this, "GradientFunctionFactory()");
    }

    public static synchronized GradientFunction get_gradient_function(RegularGrid3i volume, GradientFunctionType type, GradientCachingMethod caching_method) {
        return _instance.get_gf(volume, type, caching_method);
    }

    private GradientFunction get_gf(RegularGrid3i volume, GradientFunctionType type, GradientCachingMethod caching_method) {
        if (this.function_type_or_caching_method_changed(type, caching_method)) {
            this.update_function_type_and_caching_method(type, caching_method);
            this._repository.clear_all_volume_caches();
            return this.create_and_store_gradient_function(volume);
        }
        if (this._repository.contains_data_for_volume(volume)) {
            return this._repository.get_data_for_volume(volume);
        }
        return this.create_and_store_gradient_function(volume);
    }

    private boolean function_type_or_caching_method_changed(GradientFunctionType function_type, GradientCachingMethod caching_method) {
        boolean gradient_functions_equal = this._gradient_function_type == function_type;
        boolean caching_methods_equal = this._gradient_caching_method == caching_method;
        return !gradient_functions_equal || !caching_methods_equal;
    }

    private void update_function_type_and_caching_method(GradientFunctionType type, GradientCachingMethod caching_method) {
        this._gradient_caching_method = caching_method;
        this._gradient_function_type = type;
    }

    private GradientFunction create_and_store_gradient_function(RegularGrid3i volume) {
        ThreadLocal<GradientFunction> gf = GradientFunctionFactory.create_thread_local_gradient_function(volume, this._gradient_function_type, this._gradient_caching_method);
        this._repository.set_data_for_volume(volume, gf);
        return gf.get();
    }

    public static GradientFunction create_gradient_function(RegularGrid3i volume, GradientFunctionType type, GradientCachingMethod caching_method) {
        return GradientFunctionFactory.create_thread_local_gradient_function(volume, type, caching_method).get();
    }

    private static ThreadLocal<GradientFunction> create_thread_local_gradient_function(RegularGrid3i volume, GradientFunctionType type, GradientCachingMethod caching_method) {
        GradientFunction gf = type.get_gradient_function_implementation(volume);
        ThreadLocal<GradientFunction> cached_gf = caching_method.get_cached_implementation(volume, gf);
        return cached_gf;
    }

    @Override
    public void update(YObservable sender, Message message) {
        if (message._type == ImageStack.M_CLEAR || message._type == ImageStack.M_LOADING_START) {
            this._repository.clear();
            RegularGrid3i global_volume = MasterControl.get_is().get_voxel_cube();
            this._repository.add_volume(global_volume);
        } else if (message._type == ImageStack.M_NEW_SEGMENT) {
            Segment segment = (Segment)message._obj;
            if (segment.get_name() != ToolSegGen.TMP_SEG_NAME) {
                segment.addObserver(this, "GradientFunctionFactory::update");
                BitCube volume = segment.get_bc();
                this._repository.add_volume(volume);
            }
        } else if (message._type == ImageStack.M_DEL_SEGMENT) {
            Segment segment = (Segment)message._obj;
            BitCube volume = segment.get_bc();
            this._repository.clear_cache_for_volume(volume);
        } else if (sender instanceof Segment && this.segment_changed(message)) {
            BitCube segment_volume = ((Segment)sender).get_bc();
            this._repository.clear_cache_for_volume(segment_volume);
        }
    }

    private boolean segment_changed(Message message) {
        return message._type == Segment.M_SEG_CHANGED || message._type == Segment.M_SEG_SIZE_CHANGED;
    }

    private class GradientCacheRepository {
        private Map<RegularGrid3i, ThreadLocal<GradientFunction>> _gradient_caches = new HashMap<RegularGrid3i, ThreadLocal<GradientFunction>>();

        private GradientCacheRepository() {
        }

        public void clear() {
            this._gradient_caches.clear();
        }

        public void add_volume(RegularGrid3i volume) {
            this.clear_cache_for_volume(volume);
        }

        public void clear_cache_for_volume(RegularGrid3i volume) {
            this._gradient_caches.put(volume, null);
        }

        public void clear_all_volume_caches() {
            for (RegularGrid3i volume : this._gradient_caches.keySet()) {
                this.clear_cache_for_volume(volume);
            }
        }

        public GradientFunction get_data_for_volume(RegularGrid3i volume) {
            return this._gradient_caches.get(volume).get();
        }

        public void set_data_for_volume(RegularGrid3i volume, ThreadLocal<GradientFunction> data) {
            this._gradient_caches.put(volume, data);
        }

        public boolean contains_data_for_volume(RegularGrid3i volume) {
            return this._gradient_caches.get(volume) != null;
        }
    }
}

