/*
 * Decompiled with CFR 0.152.
 */
package misc.grid.gradients;

import misc.grid.RegularGrid3i;
import misc.grid.VoxelCube;
import misc.grid.gradients.CentralDifferenceFunction;
import misc.grid.gradients.GradientFunction;
import misc.grid.gradients.RegressionGradients;

public enum GradientFunctionType {
    CENTRAL_DIFFERENCES{

        @Override
        GradientFunction get_gradient_function_implementation(RegularGrid3i volume) {
            return new CentralDifferenceFunction(volume);
        }
    }
    ,
    NEUMANN_4D_LINEAR_REGRESSION{

        @Override
        GradientFunction get_gradient_function_implementation(RegularGrid3i volume) {
            return new RegressionGradients(volume);
        }
    };


    private GradientFunctionType() {
    }

    abstract GradientFunction get_gradient_function_implementation(RegularGrid3i var1);

    public int get_filter_radius() {
        GradientFunction gf = this.get_gradient_function_implementation(new VoxelCube(0, 0, 0, 0));
        return gf.get_filter_radius();
    }

    /* synthetic */ GradientFunctionType(String string, int n, GradientFunctionType gradientFunctionType) {
        this();
    }
}

