/*
 * Decompiled with CFR 0.152.
 */
package misc.grid.gradients;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.vecmath.Vector3f;
import misc.grid.RegularGrid3i;
import misc.grid.gradients.AbstractGradientCache;
import misc.grid.gradients.GradientFunction;

final class Precalculator
extends AbstractGradientCache {
    private final int _dim_x;
    private final int _dim_y;
    private final int _dim_z;
    private final int _voxel_number;
    private final GradientFunction _gradient_function;
    private final float[] _gradient_data;

    Precalculator(RegularGrid3i volume, GradientFunction gradient_function) {
        super(volume, gradient_function);
        this._dim_x = volume.get_dim_x();
        this._dim_y = volume.get_dim_y();
        this._dim_z = volume.get_dim_z();
        this._voxel_number = volume.get_number_of_voxels();
        this._gradient_function = gradient_function;
        this._gradient_data = new float[3 * this._voxel_number];
        this.calculate_gradients();
    }

    private void calculate_gradients() {
        int thread_count = Runtime.getRuntime().availableProcessors();
        ExecutorService service = Executors.newFixedThreadPool(thread_count);
        int i = 0;
        while (i < this._dim_z) {
            service.execute(new SliceTask(i));
            ++i;
        }
        service.shutdown();
        try {
            service.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void gradient_at(int index, Vector3f gradient_return) {
        int index_of_x_component = index * 3;
        gradient_return.x = this._gradient_data[index_of_x_component];
        gradient_return.y = this._gradient_data[index_of_x_component + 1];
        gradient_return.z = this._gradient_data[index_of_x_component + 2];
    }

    private class SliceTask
    implements Runnable {
        private final int _slice_number;
        private final Vector3f _thread_temp_vector = new Vector3f();

        public SliceTask(int slice_number) {
            this._slice_number = slice_number;
        }

        @Override
        public void run() {
            this.calculate_slice(this._slice_number);
        }

        private void calculate_slice(int z) {
            int y = 1;
            while (y < Precalculator.this._dim_y - 1) {
                int x = 1;
                while (x < Precalculator.this._dim_x - 1) {
                    int index = Precalculator.this._volume.coordinates_to_index(x, y, z);
                    Precalculator.this._gradient_function.gradient_at(index, this._thread_temp_vector);
                    ((Precalculator)Precalculator.this)._gradient_data[index *= 3] = this._thread_temp_vector.x;
                    ((Precalculator)Precalculator.this)._gradient_data[index + 1] = this._thread_temp_vector.y;
                    ((Precalculator)Precalculator.this)._gradient_data[index + 2] = this._thread_temp_vector.z;
                    ++x;
                }
                ++y;
            }
        }
    }
}

