/*
 * Decompiled with CFR 0.152.
 */
package misc.grid.gradients;

import javax.vecmath.Vector3f;
import misc.grid.RegularGrid3i;
import misc.grid.gradients.AbstractGradientFunctionImpl;

final class RegressionGradients
extends AbstractGradientFunctionImpl {
    private final int[] index_offset = new int[27];
    private final float _total_x_normalization = _x_normalization * this._normalization;
    private final float _total_y_normalization = _y_normalization * this._normalization;
    private final float _total_z_normalization = _z_normalization * this._normalization;
    private static final float[] xk;
    private static final float[] yk;
    private static final float[] zk;
    private static final float[] weight_function;
    private static float _x_normalization;
    private static float _y_normalization;
    private static float _z_normalization;

    static {
        int k;
        xk = new float[27];
        yk = new float[27];
        zk = new float[27];
        weight_function = new float[27];
        _x_normalization = 0.0f;
        _y_normalization = 0.0f;
        _z_normalization = 0.0f;
        int z = 0;
        while (z < 3) {
            int y = 0;
            while (y < 3) {
                int x = 0;
                while (x < 3) {
                    k = x + 3 * y + 9 * z;
                    RegressionGradients.xk[k] = x - 1;
                    RegressionGradients.yk[k] = y - 1;
                    RegressionGradients.zk[k] = z - 1;
                    RegressionGradients.weight_function[k] = (float)Math.sqrt((x - 1) * (x - 1) + (y - 1) * (y - 1) + (z - 1) * (z - 1));
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        float x_normalization = 0.0f;
        float y_normalization = 0.0f;
        float z_normalization = 0.0f;
        k = 0;
        while (k < 27) {
            x_normalization += weight_function[k] * xk[k] * xk[k];
            y_normalization += weight_function[k] * yk[k] * yk[k];
            z_normalization += weight_function[k] * zk[k] * zk[k];
            ++k;
        }
        _x_normalization = 1.0f / x_normalization;
        _y_normalization = 1.0f / y_normalization;
        _z_normalization = 1.0f / z_normalization;
    }

    RegressionGradients(RegularGrid3i volume) {
        super(volume);
        this.calculate_index_offsets();
    }

    private void calculate_index_offsets() {
        int z = 0;
        while (z < 3) {
            int y = 0;
            while (y < 3) {
                int x = 0;
                while (x < 3) {
                    int k = x + 3 * y + 9 * z;
                    this.index_offset[k] = x - 1 + this._offset_for_y_plus_1 * (y - 1) + this._offset_for_z_plus_1 * (z - 1);
                    ++x;
                }
                ++y;
            }
            ++z;
        }
    }

    @Override
    public int get_filter_radius() {
        return 2;
    }

    @Override
    public void gradient_at(int index, Vector3f gradient_return) {
        gradient_return.set(0.0f, 0.0f, 0.0f);
        int k = 0;
        while (k < 27) {
            float f = weight_function[k] * (float)this._volume.get(index + this.index_offset[k]);
            gradient_return.x += f * xk[k];
            gradient_return.y += f * yk[k];
            gradient_return.z += f * zk[k];
            ++k;
        }
        gradient_return.x *= this._total_x_normalization;
        gradient_return.y *= this._total_y_normalization;
        gradient_return.z *= this._total_z_normalization;
    }
}

