/*
 * Decompiled with CFR 0.152.
 */
package misc.helper;

import java.io.File;
import java.io.FilenameFilter;
import junit.framework.Assert;
import misc.helper.FileHelper;
import org.junit.Test;

public class FileHelperTest {
    @Test
    public void testGetExtensionFilter() {
        FilenameFilter filename_filter = FileHelper.get_extension_filter(".asdf");
        Assert.assertTrue((boolean)filename_filter.accept(null, "Test.asdf"));
        Assert.assertFalse((boolean)filename_filter.accept(null, "Test.asd"));
        Assert.assertFalse((boolean)filename_filter.accept(null, "Testasdf"));
        Assert.assertFalse((boolean)filename_filter.accept(null, ""));
    }

    @Test
    public void testFileNameWithoutExtension() {
        String file_name1 = "file1";
        File test_file1 = new File(String.valueOf(file_name1) + ".test");
        String result_name1 = FileHelper.file_name_without_extension(test_file1);
        Assert.assertEquals((String)file_name1, (String)result_name1);
        String file_name2 = "file2";
        File test_file2 = new File(String.valueOf(file_name2) + ".asdf");
        String result_name2 = FileHelper.file_name_without_extension(test_file2);
        Assert.assertEquals((String)file_name2, (String)result_name2);
        String file_name3 = "file3";
        File test_file3 = new File(String.valueOf(file_name3) + ".txt");
        String result_name3 = FileHelper.file_name_without_extension(test_file3);
        Assert.assertEquals((String)file_name3, (String)result_name3);
    }
}

