/*
 * Decompiled with CFR 0.152.
 */
package misc.helper;

import misc.helper.Helper;
import org.junit.Assert;
import org.junit.Test;

public class HelperTest {
    private float e = 0.0f;

    @Test
    public void testLastIndexOf() {
        int result = Helper.last_index_of("aaa", "a");
        Assert.assertEquals((long)2L, (long)result);
        int result2 = Helper.last_index_of("bbbb", "b");
        Assert.assertEquals((long)3L, (long)result2);
        int result3 = Helper.last_index_of("", "a");
        Assert.assertEquals((long)-1L, (long)result3);
        int result4 = Helper.last_index_of("bbb", "a");
        Assert.assertEquals((long)-1L, (long)result4);
        int result5 = Helper.last_index_of("2957235760", "7");
        Assert.assertEquals((long)7L, (long)result5);
    }

    @Test
    public void testClamp() {
        Assert.assertEquals((double)0.0, (double)Helper.clamp(0.0f, -2.0f, 2.0f), (double)this.e);
        Assert.assertEquals((double)1.0, (double)Helper.clamp(0.0f, 1.0f, 2.0f), (double)this.e);
        Assert.assertEquals((double)2.0, (double)Helper.clamp(3.0f, 1.0f, 2.0f), (double)this.e);
    }

    @Test
    public void testRoundFloatUp() {
        this.performFloatRoundingTest(11, 10.6f);
        this.performFloatRoundingTest(1, 0.5f);
        this.performFloatRoundingTest(-11, -10.6f);
        this.performFloatRoundingTest(-1, -0.5f);
        this.performFloatRoundingTest(0, -0.2f);
    }

    private void performFloatRoundingTest(int expected, float f) {
        int result = Helper.round(f);
        Assert.assertEquals((long)expected, (long)result);
    }

    @Test
    public void testRoundFloatDown() {
        this.performFloatRoundingTest(10, 10.49999f);
        this.performFloatRoundingTest(1, 1.0f);
    }

    @Test
    public void testRoundDoubleUp() {
        this.performDoubleRoundingTest(11, 10.6);
        this.performDoubleRoundingTest(1, 0.5);
    }

    private void performDoubleRoundingTest(int expected, double d) {
        long result = Helper.round(d);
        Assert.assertEquals((long)expected, (long)result);
    }

    @Test
    public void testRoundDoubleDown() {
        this.performDoubleRoundingTest(10, 10.4999999);
        this.performDoubleRoundingTest(1, 1.0);
    }
}

