/*
 * Decompiled with CFR 0.152.
 */
package misc.helper;

public class Interpolation {
    private Interpolation() {
    }

    public static double linear(double x, double x0, double x1, double f0, double f1) {
        return f0 + (f1 - f0) * (x - x0) / (x1 - x0);
    }

    public static float linear(float x, float x0, float x1, float f0, float f1) {
        return f0 + (f1 - f0) * (x - x0) / (x1 - x0);
    }

    public static int linear_int(int x, int x0, int x1, int f0, int f1) {
        return f0 + Math.round((float)((f1 - f0) * (x - x0)) / (float)(x1 - x0));
    }

    public static float trilinear(float px, float py, float pz, float x000, float x100, float x010, float x110, float x001, float x101, float x011, float x111) {
        float mpx = 1.0f - px;
        float i1 = x000 * mpx + x100 * px;
        float i2 = x010 * mpx + x110 * px;
        float j1 = x001 * mpx + x101 * px;
        float j2 = x011 * mpx + x111 * px;
        float mpy = 1.0f - py;
        float w1 = i1 * mpy + i2 * py;
        float w2 = j1 * mpy + j2 * py;
        return w1 * (1.0f - pz) + w2 * pz;
    }
}

