/*
 * Decompiled with CFR 0.152.
 */
package misc.helper;

import misc.helper.Interpolation;
import org.junit.Assert;
import org.junit.Test;

public class InterpolationTest {
    private static float epsilon = 1.0E-5f;

    @Test
    public void linear() {
        double x0 = 0.0;
        double x1 = 2.0;
        double x = 1.0;
        double f0 = 4.0;
        double f1 = 6.0;
        double result = 5.0;
        Assert.assertEquals((String)"linear interpolation", (double)5.0, (double)Interpolation.linear(1.0, 0.0, 2.0, 4.0, 6.0), (double)epsilon);
    }

    @Test
    public void linear_int() {
        boolean x0 = false;
        int x1 = 2;
        boolean x = true;
        int f0 = 4;
        int f1 = 6;
        int result = 5;
        Assert.assertEquals((String)"linear interpolation (int)", (long)5L, (long)Interpolation.linear_int(1, 0, 2, 4, 6));
        Assert.assertEquals((String)"linear interpolation (int)", (long)0L, (long)Interpolation.linear_int(1, 0, 100, 0, 1));
        Assert.assertEquals((String)"linear interpolation (int)", (long)5L, (long)Interpolation.linear_int(5, 0, 255, 0, 255));
    }

    @Test
    public void tri_test() {
        Assert.assertEquals((double)3.3f, (double)Interpolation.trilinear(1.0f, 0.0f, 0.0f, 0.0f, 3.3f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), (double)epsilon);
        Assert.assertEquals((double)3.3f, (double)Interpolation.trilinear(0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 3.3f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), (double)epsilon);
        Assert.assertEquals((double)3.3f, (double)Interpolation.trilinear(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 3.3f, 0.0f, 0.0f, 0.0f), (double)epsilon);
        Assert.assertEquals((double)0.27f, (double)Interpolation.trilinear(0.1f, 0.2f, 0.3f, 0.1f, 0.2f, 0.3f, 0.4f, 0.5f, 0.6f, 0.7f, 0.8f), (double)epsilon);
    }
}

