/*
 * Decompiled with CFR 0.152.
 */
package misc.helper;

import java.text.DecimalFormat;
import javax.vecmath.Vector3d;
import main.ImageStack;
import main.MasterControl;
import main.Segment;
import misc.grid.BitCube;

public class MeasuringTools {
    public static double get_voxel_volume() {
        double result;
        ImageStack is = MasterControl.get_is();
        if (is.is_regular()) {
            result = is.get_x_spacing() * is.get_y_spacing() * is.get_z_spacing();
        } else {
            Vector3d a = new Vector3d(is.get_iop0());
            Vector3d b = new Vector3d(is.get_iop1());
            Vector3d c = new Vector3d(is.get_iop2());
            a.scale(is.get_x_spacing());
            b.scale(is.get_y_spacing());
            c.scale(is.get_z_spacing());
            Vector3d tmp = new Vector3d();
            tmp.cross(a, b);
            result = Math.abs(tmp.dot(c));
        }
        return result;
    }

    public static double calc_seg_volume(Segment seg) {
        double voxel_volume = MeasuringTools.get_voxel_volume();
        BitCube bc = seg.get_bc();
        return (double)bc.count_voxels() * voxel_volume;
    }

    public static String get_volume_string(double volume_in_mm3) {
        DecimalFormat format = new DecimalFormat("#####.###");
        String volume_str = volume_in_mm3 == 0.0 ? String.valueOf(format.format(volume_in_mm3)) + " mm\u00b3" : (volume_in_mm3 < 10.0 ? String.valueOf(format.format(volume_in_mm3 * 1000.0)) + " \u03bcm\u00b3" : (volume_in_mm3 > 10000.0 ? String.valueOf(format.format(volume_in_mm3 / 1000.0)) + " cm\u00b3" : String.valueOf(format.format(volume_in_mm3)) + " mm\u00b3"));
        return volume_str;
    }

    public static String get_length_string(double length_in_mm) {
        DecimalFormat format = new DecimalFormat("#####.#####");
        String length_str = length_in_mm == 0.0 ? String.valueOf(format.format(length_in_mm)) + " mm" : (length_in_mm < 10.0 ? String.valueOf(format.format(length_in_mm * 1000.0)) + " \u03bcm" : (length_in_mm > 10000.0 ? String.valueOf(format.format(length_in_mm / 1000.0)) + " cm" : String.valueOf(format.format(length_in_mm)) + " mm"));
        return length_str;
    }
}

