/*
 * Decompiled with CFR 0.152.
 */
package misc.helper;

import main.ImageStack;
import main.MasterControl;
import main.Message;
import misc.grid.MutableRegularGrid3i;
import misc.grid.RegularGrid3i;
import misc.grid.VoxelCube;
import threads.VCOperationThread;

public class VolumeOperations {
    public static final int MIRROR_X = 0;
    public static final int MIRROR_Y = 1;
    public static final int MIRROR_Z = 2;

    public static void mirror(final int mode) {
        VCOperationThread t = new VCOperationThread(null, true){

            @Override
            public void my_run() {
                ImageStack is = MasterControl.get_is();
                MutableRegularGrid3i vc = (MutableRegularGrid3i)is.get_voxel_cube();
                this.set_label("mirroring voxel data");
                int dim_x = is.get_dim_x();
                int dim_y = is.get_dim_y();
                int dim_z = is.get_dim_z();
                if (mode == 0) {
                    int half_x = dim_x % 2 == 0 ? dim_x / 2 - 1 : dim_x / 2;
                    this.init_progress_measure("mirroring ...", 0, dim_z, 0);
                    int z = 0;
                    while (z < dim_z) {
                        int y = 0;
                        while (y < dim_y) {
                            int x = 0;
                            while (x <= half_x) {
                                int tmp = vc.get(x, y, z);
                                vc.set(x, y, z, vc.get(dim_x - x - 1, y, z));
                                vc.set(dim_x - x - 1, y, z, tmp);
                                ++x;
                            }
                            ++y;
                        }
                        is.send_message(new Message(ImageStack.M_FILTER3D_STEP, null));
                        this.set_progress_val(z);
                        ++z;
                    }
                } else if (mode == 1) {
                    int half_y = dim_y % 2 == 0 ? dim_y / 2 - 1 : dim_y / 2;
                    this.init_progress_measure("mirroring ...", 0, dim_x, 0);
                    int x = 0;
                    while (x < dim_x) {
                        int z = 0;
                        while (z < dim_z) {
                            int y = 0;
                            while (y <= half_y) {
                                int tmp = vc.get(x, y, z);
                                vc.set(x, y, z, vc.get(x, dim_y - y - 1, z));
                                vc.set(x, dim_y - y - 1, z, tmp);
                                ++y;
                            }
                            ++z;
                        }
                        is.send_message(new Message(ImageStack.M_FILTER3D_STEP, null));
                        this.set_progress_val(x);
                        ++x;
                    }
                } else {
                    int half_z = dim_z % 2 == 0 ? dim_z / 2 - 1 : dim_z / 2;
                    this.init_progress_measure("mirroring ...", 0, dim_x, 0);
                    int x = 0;
                    while (x < dim_x) {
                        int y = 0;
                        while (y < dim_y) {
                            int z = 0;
                            while (z <= half_z) {
                                int tmp = vc.get(x, y, z);
                                vc.set(x, y, z, vc.get(x, y, dim_z - z - 1));
                                vc.set(x, y, dim_z - z - 1, tmp);
                                ++z;
                            }
                            ++y;
                        }
                        is.send_message(new Message(ImageStack.M_FILTER3D_STEP, null));
                        this.set_progress_val(x);
                        ++x;
                    }
                }
            }
        };
        t.start();
    }

    public static void compute_gaussian3D(final int n, final double sigma) {
        VCOperationThread t = new VCOperationThread(null, true){

            @Override
            public void my_run() {
                int k;
                ImageStack is = MasterControl.get_is();
                MutableRegularGrid3i vc = (MutableRegularGrid3i)is.get_voxel_cube();
                this.set_label("gauss3d ...");
                double[][][] gauss = new double[n][n][n];
                int mid = (n - 1) / 2;
                int i = 0;
                while (i < n) {
                    int j = 0;
                    while (j < n) {
                        int k2 = 0;
                        while (k2 < n) {
                            double tmp = (double)(-((i - mid) * (i - mid) + (j - mid) * (j - mid) + (k2 - mid) * (k2 - mid))) / (4.0 * sigma);
                            gauss[i][j][k2] = 1.0 / Math.sqrt(sigma) * tmp;
                            ++k2;
                        }
                        ++j;
                    }
                    ++i;
                }
                double sum = 0.0;
                int i2 = 0;
                while (i2 < n) {
                    int j = 0;
                    while (j < n) {
                        k = 0;
                        while (k < n) {
                            sum += gauss[i2][j][k];
                            ++k;
                        }
                        ++j;
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < n) {
                    int j = 0;
                    while (j < n) {
                        k = 0;
                        while (k < n) {
                            gauss[i2][j][k] = gauss[i2][j][k] / sum;
                            ++k;
                        }
                        ++j;
                    }
                    ++i2;
                }
                int dim_x = vc.get_dim_x();
                int dim_y = vc.get_dim_y();
                int dim_z = vc.get_dim_z();
                VoxelCube vc_old = new VoxelCube(vc);
                int n12 = (n - 1) / 2;
                this.init_progress_measure("gauss ...", n12, dim_z - n12, n12);
                int z = n12;
                while (z < dim_z - n12) {
                    int y = n12;
                    while (y < dim_y - n12) {
                        int x = n12;
                        while (x < dim_x - n12) {
                            double new_value = 0.0;
                            int gz = 0;
                            while (gz < n) {
                                int gy = 0;
                                while (gy < n) {
                                    int gx = 0;
                                    while (gx < n) {
                                        new_value += gauss[gx][gy][gz] * (double)vc_old.get(x - mid + gx, y - mid + gy, z - mid + gz);
                                        ++gx;
                                    }
                                    ++gy;
                                }
                                ++gz;
                            }
                            vc.set(x, y, z, (int)Math.round(new_value));
                            ++x;
                        }
                        ++y;
                    }
                    this.set_progress_val(z);
                    is.send_message(new Message(ImageStack.M_FILTER3D_STEP, null));
                    ++z;
                }
            }
        };
        t.start();
    }

    private static void calculate_nld_change(RegularGrid3i vc, MutableRegularGrid3i dvdt, double dt, double es, double eds, double ced, int wx, int wy, int wz, double dx, double dy, double dz) {
        int z = 0;
        while (z < wz) {
            int zp = z < wz - 1 ? z + 1 : z - 1;
            int zm = z > 0 ? z - 1 : z + 1;
            int y = 0;
            while (y < wy) {
                int yp = y < wy - 1 ? y + 1 : y - 1;
                int ym = y > 0 ? y - 1 : y + 1;
                int x = 0;
                while (x < wx) {
                    double txy;
                    double txz;
                    double tyz;
                    double txx;
                    double tyy;
                    double tzz;
                    int xp = x < wx - 1 ? x + 1 : x - 1;
                    int xm = x > 0 ? x - 1 : x + 1;
                    double v000 = vc.get(x, y, z);
                    double vp00 = vc.get(xp, y, z);
                    double vm00 = vc.get(xm, y, z);
                    double v0p0 = vc.get(x, yp, z);
                    double v0m0 = vc.get(x, ym, z);
                    double v00p = vc.get(x, y, zp);
                    double v00m = vc.get(x, y, zm);
                    double g000_x = (vp00 - vm00) / (2.0 * dx);
                    double g000_y = (v0p0 - v0m0) / (2.0 * dy);
                    double g000_z = (v00p - v00m) / (2.0 * dz);
                    double cx = g000_x;
                    double cy = g000_y;
                    double cz = g000_z;
                    double cxq = cx * cx;
                    double cyq = cy * cy;
                    double czq = cz * cz;
                    double gradq = cxq + cyq + czq;
                    double diff = eds / (1.0 + gradq * es) + (1.0 - eds);
                    if (gradq <= 1.0E-40) {
                        tyy = tzz = diff * 0.5;
                        txx = tzz;
                        tyz = 0.0;
                        txz = 0.0;
                        txy = 0.0;
                    } else {
                        double igq = 1.0 / gradq;
                        double inorm = Math.sqrt(igq);
                        txx = 1.0 - (cx *= inorm) * cx * (1.0 - ced);
                        txy = 0.0 - cx * (cy *= inorm) * (1.0 - ced);
                        txz = 0.0 - cx * (cz *= inorm) * (1.0 - ced);
                        tyy = 1.0 - cy * cy * (1.0 - ced);
                        tyz = 0.0 - cy * cz * (1.0 - ced);
                        tzz = 1.0 - cz * cz * (1.0 - ced);
                        txx *= diff;
                        txy *= diff;
                        txz *= diff;
                        tyy *= diff;
                        tyz *= diff;
                        tzz *= diff;
                    }
                    double vpp0 = vc.get(xm, yp, z);
                    double vmp0 = vc.get(xm, yp, z);
                    double vpm0 = vc.get(xm, ym, z);
                    double vmm0 = vc.get(xm, ym, z);
                    double v0pp = vc.get(x, yp, zp);
                    double v0mp = vc.get(x, ym, zp);
                    double v0pm = vc.get(x, yp, zm);
                    double v0mm = vc.get(x, ym, zm);
                    double vp0p = vc.get(xp, y, zp);
                    double vp0m = vc.get(xp, y, zm);
                    double vm0p = vc.get(xm, y, zp);
                    double vm0m = vc.get(xm, y, zm);
                    double gp00_x = (vp00 - v000) / dx;
                    double gp00_y = (vpp0 + v0p0 - vpm0 - v0m0) / (4.0 * dy);
                    double gp00_z = (vp0p + v00p - vp0m - v00m) / (4.0 * dz);
                    double gm00_x = (vm00 - v000) / -dx;
                    double gm00_y = (vmp0 + v0p0 - vmm0 - v0m0) / (4.0 * dy);
                    double gm00_z = (vm0p + v00p - vm0m - v00m) / (4.0 * dz);
                    double g0p0_y = (v0p0 - v000) / dy;
                    double g0p0_z = (v0pp + v00p - v0pm - v00m) / (4.0 * dz);
                    double g0p0_x = (vpp0 + vp00 - vmp0 - vm00) / (4.0 * dx);
                    double g0m0_y = (v0m0 - v000) / -dy;
                    double g0m0_z = (v0mp + v00p - v0mm - v00m) / (4.0 * dz);
                    double g0m0_x = (vpm0 + vp00 - vmm0 - vm00) / (4.0 * dx);
                    double g00p_z = (v00p - v000) / dz;
                    double g00p_x = (vp0p + vp00 - vm0p - vm00) / (4.0 * dx);
                    double g00p_y = (v0pp + v0p0 - v0mp - v0m0) / (4.0 * dy);
                    double g00m_z = (v00m - v000) / -dz;
                    double g00m_x = (vp0m + vp00 - vm0m - vm00) / (4.0 * dx);
                    double g00m_y = (v0pm + v0p0 - v0mm - v0m0) / (4.0 * dy);
                    double tgp00_x = txx * gp00_x + txy * gp00_y + txz * gp00_z;
                    double tgm00_x = txx * gm00_x + txy * gm00_y + txz * gm00_z;
                    double tg0p0_y = txy * g0p0_x + tyy * g0p0_y + tyz * g0p0_z;
                    double tg0m0_y = txy * g0m0_x + tyy * g0m0_y + tyz * g0m0_z;
                    double tg00p_z = txz * g00p_x + tyz * g00p_y + tzz * g00p_z;
                    double tg00m_z = txz * g00m_x + tyz * g00m_y + tzz * g00m_z;
                    double diverg = (tgp00_x - tgm00_x) / dx + (tg0p0_y - tg0m0_y) / dy + (tg00p_z - tg00m_z) / dz;
                    double change = diverg * dt;
                    dvdt.set(x, y, z, (int)change);
                    ++x;
                }
                ++y;
            }
            ++z;
        }
    }

    public static void compute_nonlinear_diffusion(final int n, final double dt, final double es, final double eds, final double ced) {
        VCOperationThread t = new VCOperationThread(null, true){

            @Override
            public void my_run() {
                ImageStack is = MasterControl.get_is();
                MutableRegularGrid3i vc = (MutableRegularGrid3i)is.get_voxel_cube();
                double mins = is.get_min_spacing();
                double d_x = is.get_x_spacing() / mins;
                double d_y = is.get_y_spacing() / mins;
                double d_z = is.get_z_spacing() / mins;
                this.init_progress_measure("anisotropic diffusion ...", 0, 2 * n - 1, 0);
                int dim_x = vc.get_dim_x();
                int dim_y = vc.get_dim_y();
                int dim_z = vc.get_dim_z();
                int max_voxel_value = is.get_voxel_value_range();
                VoxelCube dvdt = new VoxelCube(vc);
                int i = 0;
                while (i < n) {
                    VolumeOperations.calculate_nld_change(vc, dvdt, dt, es, eds, ced, dim_x, dim_y, dim_z, d_x, d_y, d_z);
                    this.set_progress_val(2 * i);
                    int z = 0;
                    while (z < dim_z) {
                        int y = 0;
                        while (y < dim_y) {
                            int x = 0;
                            while (x < dim_x) {
                                int new_value = vc.get(x, y, z) + dvdt.get(x, y, z);
                                if (new_value < 0) {
                                    new_value = 0;
                                } else if (new_value >= max_voxel_value) {
                                    new_value = max_voxel_value - 1;
                                }
                                vc.set(x, y, z, new_value);
                                ++x;
                            }
                            ++y;
                        }
                        ++z;
                    }
                    this.set_progress_val(2 * i + 1);
                    is.send_message(new Message(ImageStack.M_FILTER3D_STEP, null));
                    ++i;
                }
            }
        };
        t.start();
    }

    public static void compute_clown() {
        VCOperationThread t = new VCOperationThread(null, true){

            @Override
            public void my_run() {
                ImageStack is = MasterControl.get_is();
                MutableRegularGrid3i vc = (MutableRegularGrid3i)is.get_voxel_cube();
                int dim_x = vc.get_dim_x();
                int dim_y = vc.get_dim_y();
                int dim_z = vc.get_dim_z();
                double sc_x = 0.8 / (double)dim_x;
                double sc_y = 0.8 / (double)dim_y;
                double sc_z = 0.8 / (double)dim_z;
                this.init_progress_measure("clown ...", 0, dim_z - 1, 0);
                double value_scale = 0.5 * (double)(is.get_voxel_value_range() - 1);
                int z = 0;
                while (z < dim_z) {
                    double fz = (double)z * sc_z - 0.4;
                    int y = 0;
                    while (y < dim_y) {
                        double fy = (double)y * sc_y - 0.4;
                        int x = 0;
                        while (x < dim_x) {
                            double fx;
                            double dx = fx = (double)x * sc_x - 0.4;
                            double dy = fy;
                            double dz = fz + 0.2;
                            double r1 = Math.sqrt(dx * dx + dy * dy + dz * dz);
                            dx = fx;
                            dy = fy;
                            dz = fz - 0.2;
                            double r2 = Math.sqrt(dx * dx + dy * dy + dz * dz);
                            dx = fx;
                            dy = fy + 0.2;
                            dz = fz;
                            double r3 = Math.sqrt(dx * dx + dy * dy + dz * dz);
                            double new_value = Math.cos(r1 * 20.0) + Math.cos(r2 * 30.0) + Math.cos(r3 * 40.0) - 1.0;
                            if (new_value > 2.0) {
                                new_value = 2.0;
                            } else if (new_value < 0.0) {
                                new_value = 0.0;
                            }
                            vc.set(x, y, z, (int)Math.round(new_value * value_scale));
                            ++x;
                        }
                        ++y;
                    }
                    is.send_message(new Message(ImageStack.M_FILTER3D_STEP, null));
                    this.set_progress_val(z);
                    ++z;
                }
            }
        };
        t.start();
    }
}

