/*
 * Decompiled with CFR 0.152.
 */
package misc.linkedsurface;

import java.util.ArrayList;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import misc.GeometryTools;
import misc.linkedsurface.LinkedTriaSurface;

public class LTSStripeSearch {
    private final ArrayList<LinkedTriaSurface.LinkedVert>[] _vert_stripes;
    private final ArrayList<LinkedTriaSurface.LinkedTria>[] _tria_stripes;
    private final ArrayList<LinkedTriaSurface.LinkedEdge>[] _edge_stripes;
    private final LinkedTriaSurface _lts;
    private final Point3d _bb_min;
    private final Point3d _bb_max;
    private double _bb_dim;
    private int _mode;
    private static final int MODE_X = 0;
    private static final int MODE_Y = 1;
    private static final int MODE_Z = 2;
    private final int _stripe_num;
    private static double SOMETHING_SMALL = 1.0E-6;

    public LTSStripeSearch(LinkedTriaSurface lts) {
        this._stripe_num = 20;
        this._vert_stripes = new ArrayList[this._stripe_num];
        this._tria_stripes = new ArrayList[this._stripe_num];
        this._edge_stripes = new ArrayList[this._stripe_num];
        this._bb_min = new Point3d();
        this._bb_max = new Point3d();
        this._lts = lts;
        this.update_search_index();
    }

    public LTSStripeSearch(LinkedTriaSurface lts, int stripe_num) {
        this._stripe_num = stripe_num;
        this._vert_stripes = new ArrayList[this._stripe_num];
        this._tria_stripes = new ArrayList[this._stripe_num];
        this._edge_stripes = new ArrayList[this._stripe_num];
        this._bb_min = new Point3d();
        this._bb_max = new Point3d();
        this._lts = lts;
        this.update_search_index();
    }

    private int get_block_index(Point3d p) {
        int index = this._mode == 0 ? (int)((double)this._stripe_num * (p.x - this._bb_min.x) / this._bb_dim - SOMETHING_SMALL) : (this._mode == 1 ? (int)((double)this._stripe_num * (p.y - this._bb_min.y) / this._bb_dim - SOMETHING_SMALL) : (int)((double)this._stripe_num * (p.z - this._bb_min.z) / this._bb_dim - SOMETHING_SMALL));
        return index;
    }

    public void update_search_index() {
        int indexb;
        int indexa;
        int i = 0;
        while (i < this._vert_stripes.length) {
            this._vert_stripes[i] = new ArrayList();
            ++i;
        }
        i = 0;
        while (i < this._tria_stripes.length) {
            this._tria_stripes[i] = new ArrayList();
            ++i;
        }
        i = 0;
        while (i < this._edge_stripes.length) {
            this._edge_stripes[i] = new ArrayList();
            ++i;
        }
        this._lts.calc_bb(this._bb_min, this._bb_max);
        double dim_x = this._bb_max.x - this._bb_min.x;
        double dim_y = this._bb_max.y - this._bb_min.y;
        double dim_z = this._bb_max.z - this._bb_min.z;
        this._bb_dim = Math.max(Math.max(dim_x, dim_y), dim_z);
        this._mode = this._bb_dim == dim_x ? 0 : (this._bb_dim == dim_y ? 1 : 2);
        for (LinkedTriaSurface.LinkedVert lv : this._lts._vlist) {
            int index = this.get_block_index(lv._p);
            this._vert_stripes[index].add(lv);
        }
        for (LinkedTriaSurface.LinkedTria lt : this._lts._flist) {
            indexa = this.get_block_index(lt._a._p);
            indexb = this.get_block_index(lt._b._p);
            int indexc = this.get_block_index(lt._c._p);
            int min_index = Math.min(Math.min(indexa, indexb), indexc);
            int max_index = Math.max(Math.max(indexa, indexb), indexc);
            int i2 = min_index;
            while (i2 <= max_index) {
                this._tria_stripes[i2].add(lt);
                ++i2;
            }
        }
        for (LinkedTriaSurface.LinkedEdge le : this._lts._elist) {
            indexa = this.get_block_index(le._a._p);
            indexb = this.get_block_index(le._b._p);
            int min_index = Math.min(indexa, indexb);
            int max_index = Math.max(indexa, indexb);
            int i3 = min_index;
            while (i3 <= max_index) {
                this._edge_stripes[i3].add(le);
                ++i3;
            }
        }
    }

    public LinkedTriaSurface.LinkedVert find_closest_vert(Point3d p) {
        LinkedTriaSurface.LinkedVert result = null;
        int index = this.get_block_index(p);
        index = index <= 0 ? 0 : index;
        int min_index = index = index >= this._stripe_num - 1 ? this._stripe_num - 1 : index;
        int max_index = index;
        while (this._vert_stripes[min_index].size() == 0 && min_index > 0) {
            --min_index;
        }
        while (this._vert_stripes[max_index].size() == 0 && max_index < this._stripe_num - 1) {
            ++max_index;
        }
        if (min_index > 0) {
            --min_index;
        }
        if (max_index < this._stripe_num - 1) {
            ++max_index;
        }
        double min_dist_sqr = Double.MAX_VALUE;
        int i = min_index;
        while (i <= max_index) {
            int j = 0;
            while (j < this._vert_stripes[i].size()) {
                Vector3d v = new Vector3d((Tuple3d)p);
                LinkedTriaSurface.LinkedVert lv = this._vert_stripes[i].get(j);
                v.sub((Tuple3d)lv._p);
                double dist_sqr = v.lengthSquared();
                if (dist_sqr < min_dist_sqr) {
                    result = lv;
                    min_dist_sqr = dist_sqr;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public LinkedTriaSurface.LinkedTria find_closest_tria(Point3d p) {
        LinkedTriaSurface.LinkedTria result = null;
        int index = this.get_block_index(p);
        int min_index = index <= 0 ? 0 : index - 1;
        int max_index = index >= this._stripe_num - 1 ? this._stripe_num - 1 : index + 1;
        double min_dist_sqr = Double.MAX_VALUE;
        int i = min_index;
        while (i <= max_index) {
            int j = 0;
            while (j < this._tria_stripes[i].size()) {
                LinkedTriaSurface.LinkedTria lt = this._tria_stripes[i].get(j);
                double dist_sqr = GeometryTools.calc_tria_point_dist_square(lt._a._p, lt._b._p, lt._c._p, p);
                if (dist_sqr < min_dist_sqr) {
                    result = lt;
                    min_dist_sqr = dist_sqr;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public LinkedTriaSurface.LinkedEdge find_closest_edge(Point3d p) {
        LinkedTriaSurface.LinkedEdge result = null;
        int index = this.get_block_index(p);
        int min_index = index == 0 ? 0 : index - 1;
        int max_index = index == this._stripe_num - 1 ? this._stripe_num - 1 : index + 1;
        double min_dist_sqr = Double.MAX_VALUE;
        int i = min_index;
        while (i <= max_index) {
            int j = 0;
            while (j < this._edge_stripes[i].size()) {
                LinkedTriaSurface.LinkedEdge le = this._edge_stripes[i].get(j);
                double dist_sqr = GeometryTools.calc_edge_point_dist_square(le._a._p, le._b._p, p);
                if (dist_sqr < min_dist_sqr) {
                    result = le;
                    min_dist_sqr = dist_sqr;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }
}

