/*
 * Decompiled with CFR 0.152.
 */
package misc.linkedsurface;

import misc.linkedsurface.LTSInfo;
import misc.linkedsurface.LinkedTriaSurface;

public class LTSValidator {
    public static LTSInfo validate(LinkedTriaSurface lts) {
        LTSInfo lts_info = new LTSInfo(lts);
        double shortest_edge_length = Double.MAX_VALUE;
        double longest_edge_length = Double.MIN_NORMAL;
        for (LinkedTriaSurface.LinkedEdge edge : lts._elist) {
            if (edge._fp.size() < 2) {
                lts_info._ltwo_edges.add(edge);
            } else if (edge._fp.size() > 2) {
                lts_info._gtwo_edges.add(edge);
            }
            double length_squared = edge.length_squared();
            if (length_squared < shortest_edge_length) {
                lts_info._shortest_edge = edge;
                shortest_edge_length = length_squared;
            }
            if (length_squared > longest_edge_length) {
                lts_info._longest_edge = edge;
                longest_edge_length = length_squared;
            }
            lts_info._medium_edge_length += Math.sqrt(length_squared);
        }
        lts_info._medium_edge_length /= (double)lts._elist.size();
        for (LinkedTriaSurface.LinkedTria tria : lts._flist) {
            if (tria._a != tria._b && tria._a != tria._c && tria._b != tria._c) continue;
            lts_info._bad_triangles.add(tria);
        }
        return lts_info;
    }

    private LTSValidator() {
    }
}

