/*
 * Decompiled with CFR 0.152.
 */
package misc.linkedsurface;

import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.util.Iterator;
import java.util.LinkedList;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import misc.linkedsurface.IndexData;
import misc.linkedsurface.LTSInfo;
import misc.linkedsurface.LinkedTriaSurface;

public class LTSValidatorCanvas
extends Canvas3D {
    private static Color3f DEFAULT_TRIA_COLOR = new Color3f(0.8f, 0.8f, 0.8f);
    private static Color3f BAD_TRIA_COLOR = new Color3f(1.0f, 0.4f, 0.6f);
    private PolygonAttributes _trias_poly_att;
    private Appearance _trias_ap;
    private Transform3D _tf_scale;
    private Transform3D _tf_scale2;
    private TransformGroup _tg_scale;
    private TransformGroup _tg_scale2;
    private Shape3D _shp_trias;
    private Shape3D _shp_ltwo_edges;
    private Shape3D _shp_gtwo_edges;
    private Shape3D _shp_bad_tria_vertices;
    private IndexedGeometryArray _ita_trias;
    private PointArray _pa_bad_tria_vertices;
    private Color3f[] _tria_colors;

    public Appearance create_line_ap(int width, Color3f col) {
        Appearance ap = new Appearance();
        LineAttributes line_att = new LineAttributes();
        line_att.setLineWidth((float)width);
        ap.setLineAttributes(line_att);
        ColoringAttributes col_att = new ColoringAttributes();
        col_att.setColor(col);
        ap.setColoringAttributes(col_att);
        return ap;
    }

    public Appearance create_point_ap(Color3f col) {
        Appearance ap = new Appearance();
        PointAttributes point_att = new PointAttributes();
        point_att.setPointSize(10.0f);
        ap.setPointAttributes(point_att);
        ColoringAttributes col_att = new ColoringAttributes();
        col_att.setColor(col);
        ap.setColoringAttributes(col_att);
        return ap;
    }

    private void create_scene() {
        SimpleUniverse su = new SimpleUniverse((Canvas3D)this);
        su.getViewingPlatform().setNominalViewingTransform();
        BranchGroup obj_root = new BranchGroup();
        BoundingSphere _bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);
        OrbitBehavior ob = new OrbitBehavior((Canvas3D)this, 48);
        ob.setSchedulingBounds((Bounds)_bounds);
        su.getViewingPlatform().setViewPlatformBehavior((ViewPlatformBehavior)ob);
        this._tf_scale = new Transform3D();
        this._tg_scale = new TransformGroup(this._tf_scale);
        this._tg_scale.setCapability(18);
        this._tf_scale2 = new Transform3D();
        this._tg_scale2 = new TransformGroup(this._tf_scale2);
        this._tg_scale2.setCapability(18);
        this._trias_ap = new Appearance();
        ColoringAttributes col_att = new ColoringAttributes();
        col_att.setShadeModel(3);
        this._trias_ap.setColoringAttributes(col_att);
        Material mat = new Material();
        mat.setAmbientColor(new Color3f(0.2f, 0.2f, 0.2f));
        mat.setDiffuseColor(new Color3f(0.7f, 0.7f, 0.7f));
        mat.setSpecularColor(new Color3f(0.7f, 0.7f, 0.7f));
        this._trias_ap.setMaterial(mat);
        this._trias_poly_att = new PolygonAttributes();
        this._trias_poly_att.setCapability(3);
        this._trias_poly_att.setPolygonMode(2);
        this._trias_poly_att.setCullFace(0);
        this._trias_ap.setPolygonAttributes(this._trias_poly_att);
        this._shp_trias = new Shape3D(null, this._trias_ap);
        this._shp_trias.setCapability(13);
        this._shp_ltwo_edges = new Shape3D(null, this.create_line_ap(2, new Color3f(0.4f, 0.4f, 1.0f)));
        this._shp_ltwo_edges.setCapability(13);
        this._shp_gtwo_edges = new Shape3D(null, this.create_line_ap(2, new Color3f(1.0f, 0.4f, 0.4f)));
        this._shp_gtwo_edges.setCapability(13);
        this._shp_bad_tria_vertices = new Shape3D(null, this.create_point_ap(new Color3f(1.0f, 0.1f, 0.1f)));
        this._shp_bad_tria_vertices.setCapability(13);
        DirectionalLight light0 = new DirectionalLight(new Color3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 0.0f, -1.0f));
        light0.setInfluencingBounds((Bounds)_bounds);
        DirectionalLight light1 = new DirectionalLight(new Color3f(1.0f, 1.0f, 1.0f), new Vector3f(-0.5f, -0.2f, 1.0f));
        light1.setInfluencingBounds((Bounds)_bounds);
        AmbientLight light2 = new AmbientLight(new Color3f(0.5f, 0.5f, 0.5f));
        light2.setInfluencingBounds((Bounds)_bounds);
        this._tg_scale.addChild((Node)this._shp_trias);
        this._tg_scale2.addChild((Node)this._shp_ltwo_edges);
        this._tg_scale2.addChild((Node)this._shp_gtwo_edges);
        this._tg_scale2.addChild((Node)this._shp_bad_tria_vertices);
        obj_root.addChild((Node)light0);
        obj_root.addChild((Node)light1);
        obj_root.addChild((Node)light2);
        obj_root.addChild((Node)this._tg_scale);
        obj_root.addChild((Node)this._tg_scale2);
        su.addBranchGraph(obj_root);
    }

    public LTSValidatorCanvas() {
        super(SimpleUniverse.getPreferredConfiguration());
        this.create_scene();
    }

    public void set_model(LinkedTriaSurface model, LTSInfo lts_info) {
        int idx;
        Iterator pi;
        LinkedList<LinkedTriaSurface.LinkedVert> vert_list = model._vlist;
        LinkedList<LinkedTriaSurface.LinkedTria> tria_list = model._flist;
        LinkedList<LinkedTriaSurface.LinkedEdge> edge_list = model._elist;
        int vert_idx = 0;
        Vector3d bb_min = new Vector3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        Vector3d bb_max = new Vector3d(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        Point3d[] verts = new Point3d[vert_list.size()];
        for (LinkedTriaSurface.LinkedVert lv : vert_list) {
            Point3d p = lv._p;
            if (bb_min.x > p.x) {
                bb_min.x = p.x;
            }
            if (bb_min.y > p.y) {
                bb_min.y = p.y;
            }
            if (bb_min.z > p.z) {
                bb_min.z = p.z;
            }
            if (bb_max.x < p.x) {
                bb_max.x = p.x;
            }
            if (bb_max.y < p.y) {
                bb_max.y = p.y;
            }
            if (bb_max.z < p.z) {
                bb_max.z = p.z;
            }
            IndexData idx2 = new IndexData(vert_idx);
            lv.set_user_data(IndexData._DATA_ID, idx2);
            verts[vert_idx] = p;
            ++vert_idx;
        }
        int tria_idx = 0;
        int[] trias = new int[tria_list.size() * 3];
        this._tria_colors = new Color3f[trias.length];
        for (LinkedTriaSurface.LinkedTria lt : tria_list) {
            IndexData idx3 = new IndexData(tria_idx);
            lt.set_user_data(IndexData._DATA_ID, idx3);
            int a = ((IndexData)lt._a.get_user_data((int)IndexData._DATA_ID))._i;
            int b = ((IndexData)lt._b.get_user_data((int)IndexData._DATA_ID))._i;
            int c = ((IndexData)lt._c.get_user_data((int)IndexData._DATA_ID))._i;
            trias[tria_idx + 0] = a;
            trias[tria_idx + 1] = b;
            trias[tria_idx + 2] = c;
            if (lts_info._bad_triangles.contains(lt)) {
                this._tria_colors[tria_idx + 0] = BAD_TRIA_COLOR;
                this._tria_colors[tria_idx + 1] = BAD_TRIA_COLOR;
                this._tria_colors[tria_idx + 2] = BAD_TRIA_COLOR;
            } else {
                this._tria_colors[tria_idx + 0] = DEFAULT_TRIA_COLOR;
                this._tria_colors[tria_idx + 1] = DEFAULT_TRIA_COLOR;
                this._tria_colors[tria_idx + 2] = DEFAULT_TRIA_COLOR;
            }
            tria_idx += 3;
        }
        int[] color_indices = new int[trias.length];
        int i = 0;
        while (i < color_indices.length) {
            color_indices[i] = i;
            ++i;
        }
        GeometryInfo gi = new GeometryInfo(1);
        gi.setCoordinates(verts);
        gi.setCoordinateIndices(trias);
        gi.setColors(this._tria_colors);
        gi.setColorIndices(color_indices);
        NormalGenerator ng = new NormalGenerator();
        ng.setCreaseAngle(1.0471975511965976);
        ng.generateNormals(gi);
        this._ita_trias = gi.getIndexedGeometryArray();
        this._ita_trias.setCapability(3);
        this._shp_trias.setGeometry((Geometry)this._ita_trias);
        if (lts_info._bad_triangles.size() > 0) {
            this._pa_bad_tria_vertices = new PointArray(lts_info._bad_triangles.size() * 3, 1);
            Iterator lti = lts_info._bad_triangles.iterator();
            int bad_tria_counter = 0;
            while (lti.hasNext()) {
                LinkedTriaSurface.LinkedTria lt = (LinkedTriaSurface.LinkedTria)lti.next();
                this._pa_bad_tria_vertices.setCoordinate(bad_tria_counter++, new Point3d(lt._a._p));
                this._pa_bad_tria_vertices.setCoordinate(bad_tria_counter++, new Point3d(lt._b._p));
                this._pa_bad_tria_vertices.setCoordinate(bad_tria_counter++, new Point3d(lt._c._p));
            }
            this._shp_bad_tria_vertices.setGeometry((Geometry)this._pa_bad_tria_vertices);
        }
        LinkedList<Point3d> ltwo = new LinkedList<Point3d>();
        LinkedList<Point3d> gtwo = new LinkedList<Point3d>();
        for (LinkedTriaSurface.LinkedEdge edge : edge_list) {
            if (edge._fp.size() < 2) {
                ltwo.add(edge._a._p);
                ltwo.add(edge._b._p);
                continue;
            }
            if (edge._fp.size() <= 2) continue;
            gtwo.add(edge._a._p);
            gtwo.add(edge._b._p);
        }
        if (ltwo.size() > 0) {
            LineArray la_ltwo = new LineArray(ltwo.size(), 1);
            pi = ltwo.iterator();
            idx = 0;
            while (pi.hasNext()) {
                la_ltwo.setCoordinate(idx++, (Point3d)pi.next());
                la_ltwo.setCoordinate(idx++, (Point3d)pi.next());
            }
            this._shp_ltwo_edges.setGeometry((Geometry)la_ltwo);
        } else {
            this._shp_ltwo_edges.setGeometry(null);
        }
        if (gtwo.size() > 0) {
            LineArray la_gtwo = new LineArray(gtwo.size(), 1);
            pi = gtwo.iterator();
            idx = 0;
            while (pi.hasNext()) {
                la_gtwo.setCoordinate(idx++, (Point3d)pi.next());
                la_gtwo.setCoordinate(idx++, (Point3d)pi.next());
            }
            this._shp_gtwo_edges.setGeometry((Geometry)la_gtwo);
        } else {
            this._shp_gtwo_edges.setGeometry(null);
        }
        double dx = bb_max.x - bb_min.x;
        double dy = bb_max.y - bb_min.y;
        double dz = bb_max.z - bb_min.z;
        double s1 = 1.0 / Math.max(dx, Math.max(dy, dz));
        double[] mat_scale = new double[]{s1, 0.0, 0.0, 0.0, 0.0, s1, 0.0, 0.0, 0.0, 0.0, s1, 0.0, 0.0, 0.0, 0.0, 1.0};
        Transform3D t1 = new Transform3D(mat_scale);
        t1.setTranslation(new Vector3d(-s1 * (bb_min.x + dx / 2.0), -s1 * (bb_min.y + dy / 2.0), -s1 * (bb_min.z + dz / 2.0)));
        this._tg_scale.setTransform(t1);
        double s2 = 1.005 / Math.max(dx, Math.max(dy, dz));
        double[] mat_scale2 = new double[]{s2, 0.0, 0.0, 0.0, 0.0, s2, 0.0, 0.0, 0.0, 0.0, s2, 0.0, 0.0, 0.0, 0.0, 1.0};
        Transform3D t2 = new Transform3D(mat_scale2);
        t2.setTranslation(new Vector3d(-s2 * (bb_min.x + dx / 2.0), -s2 * (bb_min.y + dy / 2.0), -s2 * (bb_min.z + dz / 2.0)));
        this._tg_scale2.setTransform(t2);
    }

    public void show_wireframe(boolean wire) {
        if (wire) {
            this._trias_poly_att.setPolygonMode(1);
        } else {
            this._trias_poly_att.setPolygonMode(2);
        }
    }
}

