/*
 * Decompiled with CFR 0.152.
 */
package misc.linkedsurface;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import misc.linkedsurface.UserData;

public class LinkedTriaSurface {
    public LinkedList<LinkedVert> _vlist = new LinkedList();
    public LinkedList<LinkedEdge> _elist = new LinkedList();
    public LinkedList<LinkedTria> _flist = new LinkedList();
    protected final Hashtable<Point3d, LinkedVert> _vertex_hash = new Hashtable();
    private int[] _used_ids = new int[3];

    public LinkedTriaSurface() {
        int i = 0;
        while (i < 3) {
            this._used_ids[i] = 0;
            ++i;
        }
    }

    public LinkedVert add_vert(Point3d p) {
        LinkedVert lv;
        if (this._vertex_hash.containsKey(p)) {
            lv = this._vertex_hash.get(p);
        } else {
            Point3d new_point = new Point3d(p);
            lv = new LinkedVert(new_point);
            this._vlist.add(lv);
            this._vertex_hash.put(new_point, lv);
        }
        return lv;
    }

    public LinkedEdge add_edge(LinkedVert a, LinkedVert b) {
        LinkedEdge re = this.find_edge(a, b);
        if (re == null) {
            re = new LinkedEdge(a, b);
            this._elist.add(re);
        }
        return re;
    }

    public LinkedTria add_face(LinkedVert a, LinkedVert b, LinkedVert c) {
        LinkedTria lface = null;
        for (LinkedTria tria : a._fp) {
            if (!tria.equals(a, b, c)) continue;
            lface = tria;
            break;
        }
        if (lface == null) {
            lface = new LinkedTria(a, b, c);
            this._flist.add(lface);
        }
        return lface;
    }

    public void del_vert(LinkedVert vert) {
        if (vert._ep.size() == 0 && vert._fp.size() == 0) {
            this._vlist.remove(vert);
            this._vertex_hash.remove(vert._p);
        }
    }

    public void del_edge(LinkedEdge edge) {
        if (edge._fp.size() == 0) {
            edge._a._ep.remove(edge);
            edge._b._ep.remove(edge);
            this._elist.remove(edge);
            if (edge._a._ep.size() == 0) {
                this.del_vert(edge._a);
            }
            if (edge._b._ep.size() == 0) {
                this.del_vert(edge._b);
            }
        }
    }

    public void del_face(LinkedTria face) {
        face._ab._fp.remove(face);
        face._ab._a._fp.remove(face);
        face._ab._b._fp.remove(face);
        face._bc._fp.remove(face);
        face._bc._a._fp.remove(face);
        face._bc._b._fp.remove(face);
        face._ca._fp.remove(face);
        face._ca._a._fp.remove(face);
        face._ca._b._fp.remove(face);
        face._a._fp.remove(face);
        face._b._fp.remove(face);
        face._c._fp.remove(face);
        this._flist.remove(face);
        this.del_edge(face._ab);
        this.del_edge(face._bc);
        this.del_edge(face._ca);
        this.del_vert(face._a);
        this.del_vert(face._b);
        this.del_vert(face._c);
    }

    public void orientate() {
    }

    public LinkedEdge find_edge(LinkedVert lva, LinkedVert lvb) {
        for (LinkedEdge le : lva._ep) {
            if (!le.equals(lva, lvb)) continue;
            return le;
        }
        return null;
    }

    public int calculate_epc() {
        return this._vlist.size() - this._elist.size() + this._flist.size();
    }

    public boolean is_closed() {
        for (LinkedEdge le : this._elist) {
            if (le._fp.size() == 2) continue;
            return false;
        }
        return true;
    }

    public void calc_bb(Point3d bb_min, Point3d bb_max) {
        if (this._vlist.size() == 0) {
            return;
        }
        Iterator lvi = this._vlist.iterator();
        bb_min.set((Tuple3d)this._vlist.getFirst()._p);
        bb_max.set((Tuple3d)this._vlist.getFirst()._p);
        while (lvi.hasNext()) {
            Point3d p = ((LinkedVert)lvi.next())._p;
            if (bb_min.x > p.x) {
                bb_min.x = p.x;
            }
            if (bb_min.y > p.y) {
                bb_min.y = p.y;
            }
            if (bb_min.z > p.z) {
                bb_min.z = p.z;
            }
            if (bb_max.x < p.x) {
                bb_max.x = p.x;
            }
            if (bb_max.y < p.y) {
                bb_max.y = p.y;
            }
            if (!(bb_max.z < p.z)) continue;
            bb_max.z = p.z;
        }
    }

    public final class LinkedEdge
    extends UserDataContainer {
        public LinkedVert _a;
        public LinkedVert _b;
        public LinkedList<LinkedTria> _fp;

        public LinkedEdge(LinkedVert lva, LinkedVert lvb) {
            this._fp = new LinkedList();
            this._a = lva;
            this._b = lvb;
            lva._ep.add(this);
            lvb._ep.add(this);
        }

        public boolean equals(LinkedVert lva, LinkedVert lvb) {
            return this._a == lva && this._b == lvb || this._a == lvb && this._b == lva;
        }

        public boolean compare_orientation(LinkedTria lface) {
            boolean result = false;
            if (lface._a == this._a) {
                if (lface._b == this._b) {
                    result = true;
                }
            } else if (lface._b == this._a) {
                if (lface._c == this._b) {
                    result = true;
                }
            } else if (lface._c == this._a && lface._a == this._b) {
                result = true;
            }
            return result;
        }

        public double length() {
            Vector3d e = new Vector3d((Tuple3d)this._a._p);
            e.negate();
            e.add((Tuple3d)this._b._p);
            return e.length();
        }

        public double length_squared() {
            Vector3d e = new Vector3d((Tuple3d)this._a._p);
            e.negate();
            e.add((Tuple3d)this._b._p);
            return e.lengthSquared();
        }
    }

    public final class LinkedTria
    extends UserDataContainer {
        public LinkedVert _a;
        public LinkedVert _b;
        public LinkedVert _c;
        public LinkedEdge _ab;
        public LinkedEdge _bc;
        public LinkedEdge _ca;

        public LinkedTria(LinkedVert a, LinkedVert b, LinkedVert c) {
            this._a = a;
            this._b = b;
            this._c = c;
            this._a._fp.add(this);
            this._b._fp.add(this);
            this._c._fp.add(this);
            this._ab = LinkedTriaSurface.this.add_edge(a, b);
            this._bc = LinkedTriaSurface.this.add_edge(b, c);
            this._ca = LinkedTriaSurface.this.add_edge(c, a);
            this._ab._fp.add(this);
            this._bc._fp.add(this);
            this._ca._fp.add(this);
        }

        public boolean equals(LinkedVert a, LinkedVert b, LinkedVert c) {
            return a == this._a && b == this._b && c == this._c || a == this._a && b == this._c && c == this._b || a == this._b && b == this._a && c == this._c || a == this._b && b == this._c && c == this._a || a == this._c && b == this._a && c == this._b || a == this._c && b == this._b && c == this._a;
        }

        public LinkedTria get_adjacent_face(LinkedEdge edge) {
            for (LinkedTria next_face : edge._fp) {
                if (this == next_face) continue;
                return next_face;
            }
            return null;
        }

        public boolean is_neighbour_of(LinkedTria face) {
            return this.get_adjacent_face(this._ab) == face || this.get_adjacent_face(this._bc) == face || this.get_adjacent_face(this._ca) == face;
        }

        public double calc_area() {
            Vector3d ab = new Vector3d((Tuple3d)this._b._p);
            Vector3d ac = new Vector3d((Tuple3d)this._c._p);
            ab.sub((Tuple3d)this._a._p);
            ac.sub((Tuple3d)this._a._p);
            Vector3d cross_product = new Vector3d();
            cross_product.cross(ab, ac);
            return cross_product.length() / 2.0;
        }

        public Vector3d calc_normal() {
            Vector3d b_minus_a = new Vector3d((Tuple3d)this._b._p);
            b_minus_a.sub((Tuple3d)this._a._p);
            Vector3d c_minus_a = new Vector3d((Tuple3d)this._c._p);
            c_minus_a.sub((Tuple3d)this._a._p);
            Vector3d normal = new Vector3d();
            normal.cross(b_minus_a, c_minus_a);
            normal.normalize();
            return normal;
        }
    }

    public final class LinkedVert
    extends UserDataContainer {
        public Point3d _p;
        public LinkedList<LinkedTria> _fp;
        public LinkedList<LinkedEdge> _ep;

        public LinkedVert(Point3d p) {
            this._fp = new LinkedList();
            this._ep = new LinkedList();
            this._p = p;
        }

        public LinkedList<LinkedVert> get_neighbours() {
            LinkedList<LinkedVert> neighbours = new LinkedList<LinkedVert>();
            for (LinkedEdge le : this._ep) {
                if (le._a == this) {
                    neighbours.add(le._b);
                    continue;
                }
                neighbours.add(le._a);
            }
            return neighbours;
        }

        public void set_point(Point3d p) {
            LinkedTriaSurface.this._vertex_hash.remove(this._p);
            this._p = p;
            LinkedTriaSurface.this._vertex_hash.put(this._p, this);
        }

        public void add(Tuple3d t) {
            LinkedTriaSurface.this._vertex_hash.remove(this._p);
            this._p.add(t);
            LinkedTriaSurface.this._vertex_hash.put(this._p, this);
        }

        public void sub(Tuple3d t) {
            LinkedTriaSurface.this._vertex_hash.remove(this._p);
            this._p.sub(t);
            LinkedTriaSurface.this._vertex_hash.put(this._p, this);
        }

        public void scale(double sx, double sy, double sz) {
            LinkedTriaSurface.this._vertex_hash.remove(this._p);
            this._p.x *= sx;
            this._p.y *= sy;
            this._p.z *= sz;
            LinkedTriaSurface.this._vertex_hash.put(this._p, this);
        }

        public void transform(Matrix4d m) {
            LinkedTriaSurface.this._vertex_hash.remove(this._p);
            m.transform(this._p);
            LinkedTriaSurface.this._vertex_hash.put(this._p, this);
        }
    }

    private class UserDataContainer {
        protected UserData[] _user_data_vec = null;
        protected int _length = 0;

        private UserDataContainer() {
        }

        public UserData get_user_data(int id) {
            return this._user_data_vec == null || this._length <= id ? null : this._user_data_vec[id];
        }

        public void set_user_data(int id, UserData data) {
            if (this._user_data_vec == null) {
                this._user_data_vec = new UserData[id + 1];
                this._length = id + 1;
            }
            if (this._user_data_vec.length <= id) {
                UserData[] new_data = new UserData[id + 1];
                System.arraycopy(this._user_data_vec, 0, new_data, 0, this._length);
                this._user_data_vec = new_data;
                this._length = id + 1;
            }
            this._user_data_vec[id] = data;
        }

        protected void free_data(int id) {
            this._user_data_vec[id] = null;
        }
    }
}

