/*
 * Decompiled with CFR 0.152.
 */
package misc.messages;

import java.io.PrintStream;
import javax.swing.SwingUtilities;
import main.Message;
import misc.messages.WaitItem;
import misc.messages.YObservable;
import misc.messages.YObserver;
import misc.messages.YObserverWantsAWTThread;

public class MessageManager {
    static Runnable worker = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            1 var1_1 = this;
            synchronized (var1_1) {
                workerScheduled = false;
            }
            while (true) {
                MsgInfo i;
                MsgInfo msgInfo = queue;
                synchronized (msgInfo) {
                    i = MessageManager.queue.queueNext;
                    if (i == queue) {
                        break;
                    }
                    i.dequeue();
                }
                i.waitFor(true);
            }
        }
    };
    static boolean workerScheduled;
    static final MsgInfo queue;
    static final ThreadLocal<MsgInfo> stack;

    static {
        queue = new MsgInfo();
        stack = new ThreadLocal();
    }

    public static WaitItem schedule(YObservable sender, Message message, YObserver recipient, Object recComment, Object msgComment) {
        return MessageManager.schedule(new MsgInfo(sender, message, recipient, recComment, msgComment, stack.get()));
    }

    public static void processInSwing(YObservable sender, Message message, YObserver recipient, Object recComment, Object msgComment) {
        if (SwingUtilities.isEventDispatchThread()) {
            MessageManager.deliver(sender, message, recipient, recComment, msgComment);
        } else {
            MessageManager.schedule(new MsgInfo(sender, message, recipient, recComment, msgComment, stack.get())).waitFor(false);
        }
    }

    public static void deliver(YObservable sender, Message message, YObserver recipient, Object recComment, Object msgComment) {
        if (recipient instanceof YObserverWantsAWTThread && !SwingUtilities.isEventDispatchThread()) {
            MessageManager.processInSwing(sender, message, recipient, recComment, msgComment);
        } else {
            new MsgInfo(sender, message, recipient, recComment, msgComment, stack.get()).simplyDeliver();
        }
    }

    public static void printStackTrace(PrintStream to) {
        MsgInfo top = stack.get();
        if (top == null) {
            System.err.println("no message stack available.");
        } else {
            top.printStackTrace(to);
        }
    }

    public static void printStackTrace() {
        MessageManager.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static WaitItem schedule(MsgInfo msgInfo) {
        MsgInfo msgInfo2 = queue;
        synchronized (msgInfo2) {
            msgInfo.enqueue();
        }
        MessageManager.scheduleWorker();
        return msgInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scheduleWorker() {
        Runnable runnable = worker;
        synchronized (runnable) {
            if (!workerScheduled) {
                workerScheduled = true;
                SwingUtilities.invokeLater(worker);
            }
        }
    }

    static class MsgInfo
    implements WaitItem {
        volatile int status = 0;
        Object recComment;
        Object msgComment;
        YObservable sender;
        Message message;
        YObserver recipient;
        MsgInfo stackPrev;
        MsgInfo queueNext;
        MsgInfo queuePrev;

        public MsgInfo(YObservable sender2, Message message2, YObserver recipient2, Object recComment2, Object msgComment2, MsgInfo next2) {
            this.sender = sender2;
            this.message = message2;
            this.recipient = recipient2;
            this.recComment = recComment2;
            this.stackPrev = next2;
            this.msgComment = msgComment2;
            this.queuePrev = null;
            this.queueNext = null;
        }

        MsgInfo() {
            this.queueNext = this.queuePrev = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void waitFor(boolean urge) {
            boolean needEnqueue;
            MsgInfo msgInfo = queue;
            synchronized (msgInfo) {
                needEnqueue = !urge && this.status == 0 && !this.isEnqueued();
            }
            if (needEnqueue) {
                msgInfo = queue;
                synchronized (msgInfo) {
                    this.enqueue();
                }
                MessageManager.scheduleWorker();
            }
            if (this.recipient instanceof YObserverWantsAWTThread && urge && !SwingUtilities.isEventDispatchThread()) {
                urge = false;
                System.err.println("Warning: Urgent delivery of message conflicts with EDT-wish of recipient!");
            }
            msgInfo = this;
            synchronized (msgInfo) {
                while (true) {
                    if ((urge || this.status != 0) && this.status != 1) {
                        if (this.status != 2) break;
                        return;
                    }
                    MsgInfo msgInfo2 = queue;
                    synchronized (msgInfo2) {
                        if (!this.isEnqueued()) {
                            this.enqueue();
                        }
                    }
                    try {
                        msgInfo2 = this;
                        synchronized (msgInfo2) {
                            this.wait();
                        }
                        assert (this.status == 2);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
                this.status = 1;
            }
            assert (urge);
            MsgInfo backup = stack.get();
            try {
                try {
                    stack.set(this);
                    this.recipient.update(this.sender, this.message);
                }
                catch (RuntimeException t) {
                    throw t;
                }
                catch (Error e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                stack.set(backup);
                MsgInfo msgInfo3 = this;
                synchronized (msgInfo3) {
                    this.status = 2;
                    this.notifyAll();
                }
                msgInfo3 = queue;
                synchronized (msgInfo3) {
                    if (!this.isEnqueued()) throw throwable;
                    this.dequeue();
                    throw throwable;
                }
            }
            stack.set(backup);
            MsgInfo msgInfo4 = this;
            synchronized (msgInfo4) {
                this.status = 2;
                this.notifyAll();
            }
            msgInfo4 = queue;
            synchronized (msgInfo4) {
                if (!this.isEnqueued()) return;
                this.dequeue();
                return;
            }
        }

        void simplyDeliver() {
            MsgInfo backup = stack.get();
            try {
                try {
                    stack.set(this);
                    this.status = 1;
                    this.recipient.update(this.sender, this.message);
                }
                catch (RuntimeException t) {
                    t.printStackTrace();
                    stack.set(backup);
                    this.status = 2;
                }
                catch (Error e) {
                    e.printStackTrace();
                    stack.set(backup);
                    this.status = 2;
                }
            }
            finally {
                stack.set(backup);
                this.status = 2;
            }
        }

        boolean isEnqueued() {
            assert (Thread.holdsLock(queue));
            return this.queueNext != null;
        }

        boolean isQueueHead() {
            return this == queue;
        }

        public void dequeue() {
            assert (Thread.holdsLock(queue));
            if (!this.isEnqueued()) {
                return;
            }
            this.queueNext.queuePrev = this.queuePrev;
            this.queuePrev.queueNext = this.queueNext;
            this.queuePrev = null;
            this.queueNext = null;
        }

        public void enqueue() {
            assert (Thread.holdsLock(queue));
            if (this.isEnqueued()) {
                return;
            }
            this.queueNext = queue;
            this.queuePrev = MessageManager.queue.queuePrev;
            this.queueNext.queuePrev = this.queuePrev.queueNext = this;
        }

        public void printStackTrace(PrintStream to) {
            to.println("  From: " + this.sender);
            to.println("  To: " + this.recipient);
            to.println("  Connection comment: " + this.recComment);
            to.println("  Message comment: " + this.msgComment);
            to.println("  Message: " + this.message);
            if (this.stackPrev != null) {
                to.println("Caused by: ");
                this.stackPrev.printStackTrace(to);
            }
        }
    }
}

