/*
 * Decompiled with CFR 0.152.
 */
package misc.messages;

import java.util.ArrayList;
import java.util.Iterator;
import main.Message;
import misc.messages.MessageManager;
import misc.messages.WaitItem;
import misc.messages.YObserver;

public class YObservable {
    public static final Object ANY_COMMENT = new Object();
    private final ArrayList<Entry> observers = new ArrayList();
    private boolean changed;

    @Deprecated
    public void addObserver(YObserver o) {
        this.addObserver(o, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addObserver(YObserver o, Object comment) {
        ArrayList<Entry> arrayList = this.observers;
        synchronized (arrayList) {
            Entry e;
            Iterator<Entry> iterator = this.observers.iterator();
            do {
                if (!iterator.hasNext()) {
                    Entry ne = new Entry(o, comment);
                    this.observers.add(ne);
                    return true;
                }
                e = iterator.next();
            } while (!e.obs.equals(o));
            System.err.println("Warning: Observer is added a second time! ");
            System.err.println("  Observer: " + o);
            System.err.println("  Comment:  " + comment);
            if (e.comments.contains(comment)) {
                return false;
            }
            e.comments.add(comment);
            return true;
        }
    }

    public void deleteObserver(YObserver o) {
        this.deleteObserver(o, ANY_COMMENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteObserver(YObserver o, Object comment) {
        ArrayList<Entry> arrayList = this.observers;
        synchronized (arrayList) {
            Entry e;
            Iterator<Entry> i = this.observers.iterator();
            do {
                if (!i.hasNext()) {
                    return false;
                }
                e = i.next();
            } while (!e.obs.equals(o));
            boolean found = e.comments.remove(comment);
            if (comment != ANY_COMMENT) {
                if (!e.comments.isEmpty()) return found;
            }
            i.remove();
            return true;
        }
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    public void notifyObservers(Message arg) {
        this.notifyObservers(arg, false);
    }

    public WaitItem notifyObserversAsync() {
        return this.notifyObserversAsync(null);
    }

    public WaitItem notifyObserversAsync(Message arg) {
        return this.notifyObservers(arg, true);
    }

    public WaitItem notifyObservers(Message arg, boolean async) {
        return this.notifyObservers(arg, "no comment", async);
    }

    public WaitItem notifyObservers(Message arg, String comment, boolean async) {
        if (async) {
            return this.notifyObserversAsync(arg, comment);
        }
        this.notifyObservers(arg, comment);
        return WaitItem.DONT_WAIT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(Message arg, String comment) {
        Entry[] calls;
        ArrayList<Entry> arrayList = this.observers;
        synchronized (arrayList) {
            if (!this.changed) {
                return;
            }
            this.changed = false;
            calls = this.observers.toArray(new Entry[this.observers.size()]);
        }
        Entry[] entryArray = calls;
        int n = calls.length;
        int n2 = 0;
        while (n2 < n) {
            Entry e = entryArray[n2];
            MessageManager.deliver(this, arg, e.obs, e.getComment(), comment);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WaitItem notifyObserversAsync(Message arg, String comment) {
        if (!this.changed) {
            return WaitItem.DONT_WAIT;
        }
        ArrayList<WaitItem> wait = new ArrayList<WaitItem>(this.observers.size());
        ArrayList<Entry> arrayList = this.observers;
        synchronized (arrayList) {
            this.changed = false;
            for (Entry e : this.observers) {
                WaitItem w = MessageManager.schedule(this, arg, e.obs, e.getComment(), comment);
                wait.add(w);
            }
        }
        return new WaitItem.MultiWait(wait);
    }

    protected void setChanged() {
        this.changed = true;
    }

    protected void clearChanged() {
        this.changed = false;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public int countObservers() {
        return this.observers.size();
    }

    private static class Entry {
        YObserver obs;
        ArrayList<Object> comments = new ArrayList(1);

        Entry(YObserver obs_, Object c) {
            this.obs = obs_;
            this.comments.add(c);
        }

        public Object getComment() {
            return this.comments.size() == 1 ? this.comments.get(0) : this.comments;
        }
    }
}

