/*
 * Decompiled with CFR 0.152.
 */
package misc.stl;

import java.io.IOException;
import java.io.InputStream;

public class LittleEndianConverter {
    public static void main(String[] args) {
        LittleEndianConverter.test();
    }

    public static int convertToBigEndian(byte[] srcBuffer, short[] destBuffer, int srcLength, int destOffset, int destLength) {
        return LittleEndianConverter.convertToBigEndian(srcBuffer, destBuffer, srcLength, destOffset, destLength, (short)255);
    }

    public static int convertToBigEndian(byte[] srcBuffer, short[] destBuffer, int srcLength, int destOffset, int destLength, short mask) {
        int length = Math.min(destLength * 2, srcLength / 2 * 2);
        int i = 0;
        while (i < length) {
            int tmp = (srcBuffer[i] & 0xFF | srcBuffer[i + 1] << 8) & mask;
            destBuffer[i / 2 + destOffset] = (short)tmp;
            i += 2;
        }
        return length;
    }

    public static int convertToBigEndian(byte[] srcBuffer, int[] destBuffer, int srcLength, int destOffset, int destLength) {
        return LittleEndianConverter.convertToBigEndian(srcBuffer, destBuffer, srcLength, destOffset, destLength, -1);
    }

    public static int convertToBigEndian(byte[] srcBuffer, int[] destBuffer, int srcLength, int destOffset, int destLength, int mask) {
        int length = Math.min(destLength * 4, srcLength / 4 * 4);
        int i = 0;
        while (i < length) {
            destBuffer[i / 4 + destOffset] = (srcBuffer[i] & 0xFF | srcBuffer[i + 1] << 8 & 0xFF00 | srcBuffer[i + 2] << 16 & 0xFF0000 | srcBuffer[i + 3] << 24) & mask;
            i += 4;
        }
        return length;
    }

    public static int convertToBigEndian(int blockSize, byte[] srcBuffer, int[] destBuffer, int srcLength, int destOffset, int destLength) {
        return LittleEndianConverter.convertToBigEndian(blockSize, srcBuffer, destBuffer, srcLength, destOffset, destLength, -1);
    }

    public static int convertToBigEndian(int blockSize, byte[] srcBuffer, int[] destBuffer, int srcLength, int destOffset, int destLength, int mask) {
        int length = Math.min(destLength * blockSize, srcLength / blockSize * blockSize);
        if (blockSize == 2) {
            int i = 0;
            while (i < length) {
                destBuffer[i / 2 + destOffset] = (srcBuffer[i] & 0xFF | srcBuffer[i + 1] << 8) & mask;
                i += 2;
            }
            return length;
        }
        if (blockSize == 3) {
            int i = 0;
            while (i < length) {
                destBuffer[i / 3 + destOffset] = (srcBuffer[i] & 0xFF | srcBuffer[i + 1] << 8 & 0xFF00 | srcBuffer[i + 2] << 24) & mask;
                i += 3;
            }
            return length;
        }
        if (blockSize == 4) {
            return LittleEndianConverter.convertToBigEndian(srcBuffer, destBuffer, srcLength, destOffset, destLength, mask);
        }
        return 0;
    }

    public static int read(byte[] readBuffer, short[] destBuffer, int destOffset, int destLength, InputStream stream) throws IOException {
        return LittleEndianConverter.read(readBuffer, destBuffer, destOffset, destLength, stream, (short)255);
    }

    public static int read(byte[] readBuffer, short[] destBuffer, int destOffset, int destLength, InputStream stream, short mask) throws IOException {
        int numOfBytesRead = 0;
        int numOfData = 0;
        int offset = 0;
        int length = readBuffer.length / 2 * 2;
        while (numOfBytesRead >= 0 && numOfData < destLength) {
            int numOfProcessedBytes;
            int maxBytesToRead = Math.min((destLength - numOfData) * 2, length);
            numOfBytesRead = stream.read(readBuffer, offset, maxBytesToRead - offset);
            if (numOfBytesRead - (numOfProcessedBytes = LittleEndianConverter.convertToBigEndian(readBuffer, destBuffer, numOfBytesRead + offset, destOffset + numOfData, destLength - numOfData, mask)) == 1) {
                offset = 1;
                readBuffer[0] = readBuffer[numOfProcessedBytes];
            } else {
                offset = 0;
            }
            numOfData += numOfProcessedBytes / 2;
        }
        return numOfData;
    }

    public static int read(byte[] readBuffer, int[] destBuffer, int destOffset, int destLength, InputStream stream) throws IOException {
        return LittleEndianConverter.read(readBuffer, destBuffer, destOffset, destLength, stream, -1);
    }

    public static int read(byte[] readBuffer, int[] destBuffer, int destOffset, int destLength, InputStream stream, int mask) throws IOException {
        int numOfBytesRead = 0;
        int numOfData = 0;
        int offset = 0;
        int length = readBuffer.length / 4 * 4;
        while (numOfBytesRead >= 0 && numOfData < destLength) {
            int maxBytesToRead = Math.min((destLength - numOfData) * 4, length);
            numOfBytesRead = stream.read(readBuffer, offset, maxBytesToRead - offset);
            int numOfProcessedBytes = LittleEndianConverter.convertToBigEndian(readBuffer, destBuffer, numOfBytesRead + offset, destOffset + numOfData, destLength - numOfData, mask);
            int diff = numOfBytesRead - numOfProcessedBytes;
            offset = 0;
            if (diff == 1) {
                offset = 1;
                readBuffer[0] = readBuffer[numOfProcessedBytes];
            }
            if (diff == 2) {
                offset = 2;
                readBuffer[1] = readBuffer[numOfProcessedBytes + 1];
            }
            if (diff == 3) {
                offset = 3;
                readBuffer[2] = readBuffer[numOfProcessedBytes + 2];
            }
            numOfData += numOfProcessedBytes / 4;
        }
        return numOfData;
    }

    public static int read(int blockSize, byte[] readBuffer, int[] destBuffer, int destOffset, int destLength, InputStream stream) throws IOException {
        return LittleEndianConverter.read(blockSize, readBuffer, destBuffer, destOffset, destLength, stream, -1);
    }

    public static int read(int blockSize, byte[] readBuffer, int[] destBuffer, int destOffset, int destLength, InputStream stream, int mask) throws IOException {
        if (blockSize == 2) {
            return LittleEndianConverter.read2ByteBlock(readBuffer, destBuffer, destOffset, destLength, stream, mask);
        }
        if (blockSize == 3) {
            return LittleEndianConverter.read3ByteBlock(readBuffer, destBuffer, destOffset, destLength, stream, mask);
        }
        if (blockSize == 4) {
            return LittleEndianConverter.read(readBuffer, destBuffer, destOffset, destLength, stream, mask);
        }
        return 0;
    }

    public static int read4ByteBlock(InputStream stream) throws IOException {
        return LittleEndianConverter.read(stream) & 0xFF | LittleEndianConverter.read(stream) << 8 & 0xFF00 | LittleEndianConverter.read(stream) << 16 & 0xFF0000 | LittleEndianConverter.read(stream) << 24;
    }

    public static int read2ByteBlock(InputStream stream) throws IOException {
        return LittleEndianConverter.read(stream) & 0xFF | LittleEndianConverter.read(stream) << 8;
    }

    public static int read3ByteBlock(InputStream stream) throws IOException {
        return LittleEndianConverter.read(stream) & 0xFF | LittleEndianConverter.read(stream) << 8 & 0xFF00 | LittleEndianConverter.read(stream) << 16;
    }

    private static int read2ByteBlock(byte[] readBuffer, int[] destBuffer, int destOffset, int destLength, InputStream stream, int mask) throws IOException {
        int numOfBytesRead = 0;
        int numOfData = 0;
        int offset = 0;
        int length = readBuffer.length / 2 * 2;
        while (numOfBytesRead >= 0 && numOfData < destLength) {
            int numOfProcessedBytes;
            int maxBytesToRead = Math.max((destLength - numOfData) * 2, length);
            numOfBytesRead = stream.read(readBuffer, offset, maxBytesToRead - offset);
            if (numOfBytesRead - (numOfProcessedBytes = LittleEndianConverter.convertToBigEndian(2, readBuffer, destBuffer, numOfBytesRead + offset, destOffset + numOfData, destLength - numOfData, mask)) == 1) {
                offset = 1;
                readBuffer[0] = readBuffer[numOfProcessedBytes];
            } else {
                offset = 0;
            }
            numOfData += numOfProcessedBytes / 2;
        }
        return numOfData;
    }

    private static int read3ByteBlock(byte[] readBuffer, int[] destBuffer, int destOffset, int destLength, InputStream stream, int mask) throws IOException {
        int numOfBytesRead = 0;
        int numOfData = 0;
        int offset = 0;
        int length = readBuffer.length / 3 * 3;
        while (numOfBytesRead >= 0 && numOfData < destLength) {
            int maxBytesToRead = Math.max((destLength - numOfData) * 3, length);
            numOfBytesRead = stream.read(readBuffer, offset, maxBytesToRead - offset);
            int numOfProcessedBytes = LittleEndianConverter.convertToBigEndian(3, readBuffer, destBuffer, numOfBytesRead + offset, destOffset + numOfData, destLength - numOfData, mask);
            int diff = numOfBytesRead - numOfProcessedBytes;
            offset = 0;
            if (diff == 1) {
                offset = 1;
                readBuffer[0] = readBuffer[numOfProcessedBytes];
            }
            if (diff == 2) {
                offset = 2;
                readBuffer[1] = readBuffer[numOfProcessedBytes + 1];
            }
            numOfData += numOfProcessedBytes / 3;
        }
        return numOfData;
    }

    private static int read(InputStream stream) throws IOException {
        int tempValue = stream.read();
        if (tempValue == -1) {
            throw new IOException("Filesize does not match blocksize");
        }
        return tempValue;
    }

    private static void test() {
        byte[] byArray = new byte[88];
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[11] = 1;
        byArray[12] = 1;
        byArray[14] = 1;
        byArray[15] = 1;
        byArray[23] = -1;
        byArray[26] = -1;
        byArray[29] = -1;
        byArray[32] = -1;
        byArray[36] = -1;
        byArray[39] = -1;
        byArray[41] = -1;
        byArray[42] = -1;
        byArray[44] = -1;
        byArray[45] = -1;
        byArray[46] = -1;
        byArray[47] = -1;
        byArray[48] = -1;
        byArray[49] = -1;
        byArray[54] = -1;
        byArray[55] = -1;
        byArray[63] = 1;
        byArray[66] = 1;
        byArray[69] = 1;
        byArray[72] = 1;
        byArray[76] = 1;
        byArray[79] = 1;
        byArray[81] = 1;
        byArray[82] = 1;
        byArray[84] = 1;
        byArray[85] = 1;
        byArray[86] = 1;
        byArray[87] = 1;
        byte[] src = byArray;
        short[] shortDest = new short[src.length / 2];
        int[] intDest = new int[src.length / 4];
        LittleEndianConverter.convertToBigEndian(src, shortDest, src.length, 0, shortDest.length);
        LittleEndianConverter.convertToBigEndian(src, intDest, src.length, 0, intDest.length);
        System.out.println("Source");
        int length = src.length;
        int i = 0;
        while (i < length) {
            if (i % 4 == 0 && i != 0) {
                System.out.println();
            }
            System.out.print(String.valueOf(Integer.toHexString(src[i] & 0xFF)) + " ");
            ++i;
        }
        System.out.println();
        System.out.println("Short");
        length = shortDest.length;
        i = 0;
        while (i < length) {
            System.out.print(String.valueOf(Integer.toHexString(shortDest[i] & 0xFFFF)) + " ");
            ++i;
        }
        System.out.println();
        System.out.println("int blockSize 4");
        length = intDest.length;
        i = 0;
        while (i < length) {
            System.out.print(String.valueOf(Integer.toHexString(intDest[i])) + " ");
            ++i;
        }
        System.out.println();
    }
}

