/*
 * Decompiled with CFR 0.152.
 */
package misc.stl;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.ProgressMonitorInputStream;
import misc.stl.LittleEndianConverter;
import misc.stl.STLParser;

class STLBinaryParser
extends STLParser {
    private static final int HEADER_SIZE = 84;
    private static final int RECORD_SIZE = 50;
    private static final int COMMENT_SIZE = 80;
    private BufferedInputStream itsStream;
    private final byte[] itsReadBuffer = new byte[48];
    private final int[] itsDataBuffer = new int[12];

    @Override
    public void close() throws IOException {
        if (this.itsStream != null) {
            this.itsStream.close();
        }
    }

    @Override
    public boolean parse(URL url) throws IOException {
        InputStream stream = null;
        int length = -1;
        try {
            URLConnection connection = url.openConnection();
            stream = connection.getInputStream();
            length = connection.getContentLength();
        }
        catch (IOException connection) {
            // empty catch block
        }
        this.itsStream = new BufferedInputStream(stream);
        try {
            int i = 0;
            while (i < 80) {
                this.itsStream.read();
                ++i;
            }
            this.itsNumOfObjects = 1;
            this.itsNumOfFacets = new int[]{LittleEndianConverter.read4ByteBlock(this.itsStream)};
            this.itsNames = new String[1];
            if (length != -1 && length != this.itsNumOfFacets[0] * 50 + 84) {
                throw new IOException("File size does not match.");
            }
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        return false;
    }

    @Override
    public boolean parse(URL url, Component parentComponent) throws InterruptedIOException, IOException {
        InputStream stream = null;
        int length = -1;
        try {
            URLConnection connection = url.openConnection();
            stream = connection.getInputStream();
            length = connection.getContentLength();
        }
        catch (IOException connection) {
            // empty catch block
        }
        stream = new ProgressMonitorInputStream(parentComponent, "parsing " + url.toString(), stream);
        this.itsStream = new BufferedInputStream(stream);
        try {
            int i = 0;
            while (i < 80) {
                this.itsStream.read();
                ++i;
            }
            this.itsNumOfObjects = 1;
            this.itsNumOfFacets = new int[]{LittleEndianConverter.read4ByteBlock(this.itsStream)};
            this.itsNames = new String[1];
            if (length != -1 && length != this.itsNumOfFacets[0] * 50 + 84) {
                throw new IOException("File size does not match.");
            }
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        return false;
    }

    @Override
    public boolean getNextFacet(double[] normal, double[][] vertices) throws InterruptedIOException, IOException {
        LittleEndianConverter.read(this.itsReadBuffer, this.itsDataBuffer, 0, 12, (InputStream)this.itsStream);
        int i = 0;
        while (i < 3) {
            normal[i] = Float.intBitsToFloat(this.itsDataBuffer[i]);
            ++i;
        }
        i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                vertices[i][j] = Float.intBitsToFloat(this.itsDataBuffer[i * 3 + j + 3]);
                ++j;
            }
            ++i;
        }
        this.itsStream.read();
        this.itsStream.read();
        return true;
    }
}

