/*
 * Decompiled with CFR 0.152.
 */
package misc.transform;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import misc.transform.Transformation;

public final class NonrigidTransformation
implements Transformation {
    private float _dx;
    private float _dy;
    private float _dz;
    private int _nx = 20;
    private int _ny = 20;
    private int _nz = 20;
    private Point3f[] _grid;
    private final int _dim_x;
    private final int _dim_y;
    private final int _dim_z;

    public NonrigidTransformation(NonrigidTransformation old) {
        this._grid = new Point3f[old._grid.length];
        int i = 0;
        while (i < this._grid.length) {
            this._grid[i] = new Point3f(old._grid[i]);
            ++i;
        }
        this._dx = old._dx;
        this._dy = old._dy;
        this._dz = old._dz;
        this._nx = old._nx;
        this._ny = old._ny;
        this._nz = old._nz;
        this._dim_x = old._dim_x;
        this._dim_y = old._dim_y;
        this._dim_z = old._dim_z;
    }

    public NonrigidTransformation(int dim_x, int dim_y, int dim_z, int nx, int ny, int nz, Transformation before_trans) {
        this._dim_x = dim_x;
        this._dim_y = dim_y;
        this._dim_z = dim_z;
        this._nx = nx;
        this._ny = ny;
        this._nz = nz;
        this._dx = (float)dim_x * 1.0f / (float)(nx - 3);
        this._dy = (float)dim_y * 1.0f / (float)(ny - 3);
        this._dz = (float)dim_z * 1.0f / (float)(nz - 3);
        this._grid = new Point3f[nx * ny * nz];
        this.create_grid(before_trans);
    }

    private void create_grid(Transformation before_trans) {
        int i = 0;
        while (i < this._nx * this._ny * this._nz) {
            this._grid[i] = new Point3f();
            ++i;
        }
        int x = 0;
        while (x < this._nx) {
            int y = 0;
            while (y < this._ny) {
                int z = 0;
                while (z < this._nz) {
                    Point3f p = this.get_grid_point(x, y, z);
                    p.x = (float)x * this._dx - this._dx;
                    p.y = (float)y * this._dy - this._dy;
                    p.z = (float)z * this._dz - this._dz;
                    before_trans.transform(p);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public void deform() {
        System.err.println("NonrigidTransformation::deform USING THE METHOD 'deform()' IS NOT A GOOD IDEA - IT's JUST FOR TESTING");
        this.get_grid_point((int)0, (int)0, (int)2).x = (float)((double)this.get_grid_point((int)0, (int)0, (int)2).x - 30.0);
        this.get_grid_point((int)1, (int)0, (int)2).x = (float)((double)this.get_grid_point((int)1, (int)0, (int)2).x - 30.0);
        this.get_grid_point((int)2, (int)0, (int)2).x = (float)((double)this.get_grid_point((int)2, (int)0, (int)2).x - 30.0);
        this.get_grid_point((int)0, (int)1, (int)2).x = (float)((double)this.get_grid_point((int)0, (int)1, (int)2).x - 30.0);
        this.get_grid_point((int)1, (int)1, (int)2).x = (float)((double)this.get_grid_point((int)1, (int)1, (int)2).x - 30.0);
        this.get_grid_point((int)2, (int)1, (int)2).x = (float)((double)this.get_grid_point((int)2, (int)1, (int)2).x - 30.0);
    }

    public void print_grid() {
        int x = 0;
        while (x < this._nx) {
            int y = 0;
            while (y < this._ny) {
                int z = 0;
                while (z < this._nz) {
                    Point3f p = this.get_grid_point(x, y, z);
                    System.out.printf("(%d,%d,%d): " + p + "\n", x, y, z);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    private static final float[] computeSplines(float t) {
        float[] B = new float[]{(-1.0f * t * t * t + 3.0f * t * t - 3.0f * t + 1.0f) / 6.0f, (3.0f * t * t * t - 6.0f * t * t + 4.0f) / 6.0f, (-3.0f * t * t * t + 3.0f * t * t + 3.0f * t + 1.0f) / 6.0f, t * t * t / 6.0f};
        return B;
    }

    @Override
    public void transform(Point3f p) {
        float result_x = 0.0f;
        float result_y = 0.0f;
        float result_z = 0.0f;
        if (p.x >= 0.0f && p.x < (float)this._dim_x && p.y >= 0.0f && p.y < (float)this._dim_y && p.z >= 0.0f && p.z < (float)this._dim_z) {
            int i = (int)(p.x / this._dx);
            int j = (int)(p.y / this._dy);
            int k = (int)(p.z / this._dz);
            float u = p.x / this._dx - (float)i;
            float v = p.y / this._dy - (float)j;
            float w = p.z / this._dz - (float)k;
            float[] u_splines = NonrigidTransformation.computeSplines(u);
            float[] v_splines = NonrigidTransformation.computeSplines(v);
            float[] w_splines = NonrigidTransformation.computeSplines(w);
            int l = 0;
            while (l < 4) {
                int m = 0;
                while (m < 4) {
                    int n = 0;
                    while (n < 4) {
                        float factor = u_splines[l] * v_splines[m] * w_splines[n];
                        result_x += factor * this.get_grid_point((int)(i + l), (int)(j + m), (int)(k + n)).x;
                        result_y += factor * this.get_grid_point((int)(i + l), (int)(j + m), (int)(k + n)).y;
                        result_z += factor * this.get_grid_point((int)(i + l), (int)(j + m), (int)(k + n)).z;
                        ++n;
                    }
                    ++m;
                }
                ++l;
            }
            p.x = result_x;
            p.y = result_y;
            p.z = result_z;
        }
    }

    public int get_index(int x, int y, int z) {
        return z * this._ny * this._nx + y * this._nx + x;
    }

    public int get_index(int x, int y, int z, int nx, int ny, int nz) {
        return z * ny * nx + y * nx + x;
    }

    @Override
    public Point3f transform(int x, int y, int z) {
        Point3f result = new Point3f((float)x, (float)y, (float)z);
        this.transform(result);
        return result;
    }

    public Point3f get_grid_point(int x, int y, int z) {
        return this._grid[this.get_index(x, y, z)];
    }

    public Point3f get_grid_point(int index) {
        return this._grid[index];
    }

    public Point3f[] get_grid_points() {
        return (Point3f[])this._grid.clone();
    }

    public void set_grid_point(int x, int y, int z, Point3f new_point) {
        this._grid[this.get_index((int)x, (int)y, (int)z)] = new_point;
    }

    public void set_grid_point(int index, Point3f new_point) {
        this._grid[index] = new_point;
    }

    @Override
    public void invert() {
        System.err.println("NonrigidTransformation::invert CANNOT INVERT NON-RIGID REGISTRATION - DONT KNOW WHAT TO DO");
    }

    public Point3i get_grid_dim() {
        return new Point3i(this._nx, this._ny, this._nz);
    }

    public Point3f get_cell_size() {
        return new Point3f(this._dx, this._dy, this._dz);
    }

    public Point3f[] get_grid() {
        return this._grid;
    }

    private Point3f equation343XZ(int i, int j, int k) {
        Point3f result = new Point3f(this._grid[this.get_index(i, j - 1, k)]);
        result.add((Tuple3f)this._grid[this.get_index(i, j - 1, k + 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j - 1, k)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j - 1, k + 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i, j + 1, k)]);
        result.add((Tuple3f)this._grid[this.get_index(i, j + 1, k + 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j + 1, k)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j + 1, k + 1)]);
        Point3f p = new Point3f(this._grid[this.get_index(i, j, k)]);
        p.add((Tuple3f)this._grid[this.get_index(i, j, k + 1)]);
        p.add((Tuple3f)this._grid[this.get_index(i + 1, j, k)]);
        p.add((Tuple3f)this._grid[this.get_index(i + 1, j, k + 1)]);
        p.scale(6.0f);
        result.add((Tuple3f)p);
        result.scale(0.03125f);
        return result;
    }

    private Point3f equation343XY(int i, int j, int k) {
        Point3f result = new Point3f(this._grid[this.get_index(i, j, k - 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i, j + 1, k - 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j, k - 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j + 1, k - 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i, j, k + 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i, j + 1, k + 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j, k + 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j + 1, k + 1)]);
        Point3f p = new Point3f(this._grid[this.get_index(i, j, k)]);
        p.add((Tuple3f)this._grid[this.get_index(i, j + 1, k)]);
        p.add((Tuple3f)this._grid[this.get_index(i + 1, j, k)]);
        p.add((Tuple3f)this._grid[this.get_index(i + 1, j + 1, k)]);
        p.scale(6.0f);
        result.add((Tuple3f)p);
        result.scale(0.03125f);
        return result;
    }

    private Point3f equation343YZ(int i, int j, int k) {
        Point3f result = new Point3f(this._grid[this.get_index(i - 1, j, k)]);
        result.add((Tuple3f)this._grid[this.get_index(i - 1, j, k + 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i - 1, j + 1, k)]);
        result.add((Tuple3f)this._grid[this.get_index(i - 1, j + 1, k + 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j, k)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j, k + 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j + 1, k)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j + 1, k + 1)]);
        Point3f p = new Point3f(this._grid[this.get_index(i, j, k)]);
        p.add((Tuple3f)this._grid[this.get_index(i, j, k + 1)]);
        p.add((Tuple3f)this._grid[this.get_index(i, j + 1, k)]);
        p.add((Tuple3f)this._grid[this.get_index(i, j + 1, k + 1)]);
        p.scale(6.0f);
        result.add((Tuple3f)p);
        result.scale(0.03125f);
        return result;
    }

    private Point3f equation344Z(int i, int j, int k) {
        Point3f result = new Point3f(this._grid[this.get_index(i - 1, j - 1, k)]);
        result.add((Tuple3f)this._grid[this.get_index(i - 1, j + 1, k)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j - 1, k)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j + 1, k)]);
        result.add((Tuple3f)this._grid[this.get_index(i - 1, j - 1, k + 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i - 1, j + 1, k + 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j - 1, k + 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j + 1, k + 1)]);
        Point3f p = new Point3f(this._grid[this.get_index(i - 1, j, k)]);
        p.add((Tuple3f)this._grid[this.get_index(i, j - 1, k)]);
        p.add((Tuple3f)this._grid[this.get_index(i + 1, j, k)]);
        p.add((Tuple3f)this._grid[this.get_index(i, j + 1, k)]);
        p.add((Tuple3f)this._grid[this.get_index(i - 1, j, k + 1)]);
        p.add((Tuple3f)this._grid[this.get_index(i, j - 1, k + 1)]);
        p.add((Tuple3f)this._grid[this.get_index(i + 1, j, k + 1)]);
        p.add((Tuple3f)this._grid[this.get_index(i, j + 1, k + 1)]);
        p.scale(6.0f);
        result.add((Tuple3f)p);
        p = new Point3f(this._grid[this.get_index(i, j, k)]);
        p.add((Tuple3f)this._grid[this.get_index(i, j, k + 1)]);
        p.scale(36.0f);
        result.add((Tuple3f)p);
        result.scale(0.0078125f);
        return result;
    }

    private Point3f equation344Y(int i, int j, int k) {
        Point3f result = new Point3f(this._grid[this.get_index(i - 1, j, k - 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i - 1, j, k + 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j, k - 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j, k + 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i - 1, j + 1, k - 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i - 1, j + 1, k + 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j + 1, k - 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j + 1, k + 1)]);
        Point3f p = new Point3f(this._grid[this.get_index(i - 1, j, k)]);
        p.add((Tuple3f)this._grid[this.get_index(i, j, k - 1)]);
        p.add((Tuple3f)this._grid[this.get_index(i + 1, j, k)]);
        p.add((Tuple3f)this._grid[this.get_index(i, j, k + 1)]);
        p.add((Tuple3f)this._grid[this.get_index(i - 1, j + 1, k)]);
        p.add((Tuple3f)this._grid[this.get_index(i, j + 1, k - 1)]);
        p.add((Tuple3f)this._grid[this.get_index(i + 1, j + 1, k)]);
        p.add((Tuple3f)this._grid[this.get_index(i, j + 1, k + 1)]);
        p.scale(6.0f);
        result.add((Tuple3f)p);
        p = new Point3f(this._grid[this.get_index(i, j, k)]);
        p.add((Tuple3f)this._grid[this.get_index(i, j + 1, k)]);
        p.scale(36.0f);
        result.add((Tuple3f)p);
        result.scale(0.0078125f);
        return result;
    }

    private Point3f equation344X(int i, int j, int k) {
        Point3f result = new Point3f(this._grid[this.get_index(i, j - 1, k - 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i, j - 1, k + 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i, j + 1, k - 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i, j + 1, k + 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j - 1, k - 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j - 1, k + 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j + 1, k - 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j + 1, k + 1)]);
        Point3f p = new Point3f(this._grid[this.get_index(i, j - 1, k)]);
        p.add((Tuple3f)this._grid[this.get_index(i, j, k - 1)]);
        p.add((Tuple3f)this._grid[this.get_index(i, j + 1, k)]);
        p.add((Tuple3f)this._grid[this.get_index(i, j, k + 1)]);
        p.add((Tuple3f)this._grid[this.get_index(i + 1, j - 1, k)]);
        p.add((Tuple3f)this._grid[this.get_index(i + 1, j, k - 1)]);
        p.add((Tuple3f)this._grid[this.get_index(i + 1, j + 1, k)]);
        p.add((Tuple3f)this._grid[this.get_index(i + 1, j, k + 1)]);
        p.scale(6.0f);
        result.add((Tuple3f)p);
        p = new Point3f(this._grid[this.get_index(i, j, k)]);
        p.add((Tuple3f)this._grid[this.get_index(i + 1, j, k)]);
        p.scale(36.0f);
        result.add((Tuple3f)p);
        result.scale(0.0078125f);
        return result;
    }

    private Point3f equation342(int i, int j, int k) {
        Point3f result = new Point3f(this._grid[this.get_index(i, j, k)]);
        result.add((Tuple3f)this._grid[this.get_index(i, j, k + 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i, j + 1, k)]);
        result.add((Tuple3f)this._grid[this.get_index(i, j + 1, k + 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j, k)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j, k + 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j + 1, k)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j + 1, k + 1)]);
        result.scale(0.125f);
        return result;
    }

    private Point3f equation345(int i, int j, int k) {
        Point3f result = new Point3f();
        result = new Point3f(this._grid[this.get_index(i - 1, j - 1, k - 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i - 1, j + 1, k - 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j - 1, k - 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j + 1, k - 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i - 1, j - 1, k + 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i - 1, j + 1, k + 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j - 1, k + 1)]);
        result.add((Tuple3f)this._grid[this.get_index(i + 1, j + 1, k + 1)]);
        Point3f sum6 = new Point3f(this._grid[this.get_index(i - 1, j - 1, k)]);
        sum6.add((Tuple3f)this._grid[this.get_index(i - 1, j + 1, k)]);
        sum6.add((Tuple3f)this._grid[this.get_index(i + 1, j - 1, k)]);
        sum6.add((Tuple3f)this._grid[this.get_index(i + 1, j + 1, k)]);
        sum6.add((Tuple3f)this._grid[this.get_index(i - 1, j, k - 1)]);
        sum6.add((Tuple3f)this._grid[this.get_index(i, j - 1, k - 1)]);
        sum6.add((Tuple3f)this._grid[this.get_index(i + 1, j, k - 1)]);
        sum6.add((Tuple3f)this._grid[this.get_index(i, j + 1, k - 1)]);
        sum6.add((Tuple3f)this._grid[this.get_index(i - 1, j, k + 1)]);
        sum6.add((Tuple3f)this._grid[this.get_index(i, j - 1, k + 1)]);
        sum6.add((Tuple3f)this._grid[this.get_index(i + 1, j, k + 1)]);
        sum6.add((Tuple3f)this._grid[this.get_index(i, j + 1, k + 1)]);
        sum6.scale(6.0f);
        result.add((Tuple3f)sum6);
        Point3f sum36 = new Point3f(this._grid[this.get_index(i, j, k - 1)]);
        sum36.add((Tuple3f)this._grid[this.get_index(i, j, k + 1)]);
        sum36.add((Tuple3f)this._grid[this.get_index(i - 1, j, k)]);
        sum36.add((Tuple3f)this._grid[this.get_index(i, j - 1, k)]);
        sum36.add((Tuple3f)this._grid[this.get_index(i + 1, j, k)]);
        sum36.add((Tuple3f)this._grid[this.get_index(i, j + 1, k)]);
        sum36.scale(36.0f);
        result.add((Tuple3f)sum36);
        Point3f sum216 = new Point3f(this._grid[this.get_index(i, j, k)]);
        sum216.scale(216.0f);
        result.add((Tuple3f)sum216);
        result.scale(0.001953125f);
        return result;
    }

    public void inc_resolution() {
        Point3f[] new_grid = new Point3f[(2 * this._nx - 3) * (2 * this._ny - 3) * (2 * this._nz - 3)];
        int i = 0;
        while (i < this._nx - 1) {
            int j = 0;
            while (j < this._ny - 1) {
                int k = 0;
                while (k < this._nz - 1) {
                    Point3f result;
                    if (i != 0 && j != 0 && k != 0) {
                        new_grid[this.get_index((int)(2 * i - 1), (int)(2 * j - 1), (int)(2 * k - 1), (int)(2 * this._nx - 3), (int)(2 * this._ny - 3), (int)(2 * this._nz - 3))] = result = this.equation345(i, j, k);
                    }
                    new_grid[this.get_index((int)(2 * i), (int)(2 * j), (int)(2 * k), (int)(2 * this._nx - 3), (int)(2 * this._ny - 3), (int)(2 * this._nz - 3))] = result = this.equation342(i, j, k);
                    if (j != 0 && k != 0) {
                        new_grid[this.get_index((int)(2 * i), (int)(2 * j - 1), (int)(2 * k - 1), (int)(2 * this._nx - 3), (int)(2 * this._ny - 3), (int)(2 * this._nz - 3))] = result = this.equation344X(i, j, k);
                    }
                    if (i != 0 && k != 0) {
                        new_grid[this.get_index((int)(2 * i - 1), (int)(2 * j), (int)(2 * k - 1), (int)(2 * this._nx - 3), (int)(2 * this._ny - 3), (int)(2 * this._nz - 3))] = result = this.equation344Y(i, j, k);
                    }
                    if (i != 0 && j != 0) {
                        new_grid[this.get_index((int)(2 * i - 1), (int)(2 * j - 1), (int)(2 * k), (int)(2 * this._nx - 3), (int)(2 * this._ny - 3), (int)(2 * this._nz - 3))] = result = this.equation344Z(i, j, k);
                    }
                    if (i != 0) {
                        new_grid[this.get_index((int)(2 * i - 1), (int)(2 * j), (int)(2 * k), (int)(2 * this._nx - 3), (int)(2 * this._ny - 3), (int)(2 * this._nz - 3))] = result = this.equation343YZ(i, j, k);
                    }
                    if (j != 0) {
                        new_grid[this.get_index((int)(2 * i), (int)(2 * j - 1), (int)(2 * k), (int)(2 * this._nx - 3), (int)(2 * this._ny - 3), (int)(2 * this._nz - 3))] = result = this.equation343XZ(i, j, k);
                    }
                    if (k != 0) {
                        new_grid[this.get_index((int)(2 * i), (int)(2 * j), (int)(2 * k - 1), (int)(2 * this._nx - 3), (int)(2 * this._ny - 3), (int)(2 * this._nz - 3))] = result = this.equation343XY(i, j, k);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this._nx = 2 * this._nx - 3;
        this._ny = 2 * this._ny - 3;
        this._nz = 2 * this._nz - 3;
        this._grid = new_grid;
        this._dx = (float)this._dim_x * 1.0f / (float)(this._nx - 3);
        this._dy = (float)this._dim_y * 1.0f / (float)(this._ny - 3);
        this._dz = (float)this._dim_z * 1.0f / (float)(this._nz - 3);
    }

    public float get_dx() {
        return this._dx;
    }

    public float get_dy() {
        return this._dy;
    }

    public float get_dz() {
        return this._dz;
    }
}

