/*
 * Decompiled with CFR 0.152.
 */
package raycaster;

import javax.vecmath.Color4f;
import javax.vecmath.Point3f;
import misc.Voxel;
import misc.grid.BitCube;
import misc.grid.RegularGrid3i;
import raycaster.SegmentInfoOctree;

public final class BinVolumeOctree {
    private final BitCube[] _cube;
    private final int _max_level;

    public BinVolumeOctree(Color4f[] color_table, RegularGrid3i voxelCube, SegmentInfoOctree segment_opacity) {
        this._max_level = this.calc_max_level(voxelCube);
        this._cube = new BitCube[this._max_level + 1];
        int i = 0;
        while (i < this._max_level + 1) {
            int dim = 1 << this._max_level - i;
            this._cube[i] = new BitCube(dim, dim, dim);
            ++i;
        }
        this.fill_cubes(voxelCube, color_table, segment_opacity);
    }

    public int get_max_level() {
        return this._max_level;
    }

    public void make_index(int level, Point3f p, Voxel index) {
        index.set((int)p.x >> level, (int)p.y >> level, (int)p.z >> level);
    }

    public void parent_index(Voxel index, Voxel parent) {
        parent._x = index._x >> 1;
        parent._y = index._y >> 1;
        parent._z = index._z >> 1;
    }

    public boolean is_visible(int level, Voxel index) {
        return this._cube[level].getXYZ(index._x, index._y, index._z);
    }

    public boolean is_visible(int level, int x, int y, int z) {
        return this._cube[level].getXYZ(x, y, z);
    }

    private void fill_cubes(RegularGrid3i voxelCube, Color4f[] color_table, SegmentInfoOctree segment_opacity) {
        int x;
        int y;
        this._cube[0].clear();
        int dim = this._cube[0].get_dim_x();
        boolean use_bitshift = dim >= 32;
        int z = 1;
        while (z < voxelCube.get_dim_z()) {
            int pos = z * dim * dim;
            y = 1;
            while (y < voxelCube.get_dim_y()) {
                pos += dim;
                x = 1;
                while (x < voxelCube.get_dim_x()) {
                    int intensity = voxelCube.get(x, y, z);
                    if (color_table[intensity].w > 0.0f || segment_opacity.opacity_is_greater_than_zero_at(x, y, z, intensity)) {
                        int intnum = pos + x >>> 5;
                        int bitnum = (pos + x) % 32;
                        if (bitnum == 0 || !use_bitshift) {
                            this._cube[0].setXYZ(x, y, z, true);
                            this._cube[0].setXYZ(x - 1, y, z, true);
                            this._cube[0].setXYZ(x, y - 1, z, true);
                            this._cube[0].setXYZ(x - 1, y - 1, z, true);
                            this._cube[0].setXYZ(x, y, z - 1, true);
                            this._cube[0].setXYZ(x - 1, y, z - 1, true);
                            this._cube[0].setXYZ(x, y - 1, z - 1, true);
                            this._cube[0].setXYZ(x - 1, y - 1, z - 1, true);
                        } else {
                            int mask = 1 << bitnum | 1 << bitnum - 1;
                            int[] data = this._cube[0].get_data();
                            int n = intnum;
                            data[n] = data[n] | mask;
                            int n2 = intnum - (dim >> 5);
                            data[n2] = data[n2] | mask;
                            int n3 = intnum - (dim * dim >> 5);
                            data[n3] = data[n3] | mask;
                            int n4 = intnum - (dim * dim + dim >> 5);
                            data[n4] = data[n4] | mask;
                        }
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        int level = 1;
        while (level < this._max_level + 1) {
            this._cube[level].clear();
            int z2 = 0;
            while (z2 < this._cube[level].get_dim_z()) {
                y = 0;
                while (y < this._cube[level].get_dim_y()) {
                    x = 0;
                    while (x < this._cube[level].get_dim_x()) {
                        if (this._cube[level - 1].getXYZ(x << 1, y << 1, z2 << 1) || this._cube[level - 1].getXYZ((x << 1) + 1, y << 1, z2 << 1) || this._cube[level - 1].getXYZ(x << 1, (y << 1) + 1, z2 << 1) || this._cube[level - 1].getXYZ(x << 1, y << 1, (z2 << 1) + 1) || this._cube[level - 1].getXYZ((x << 1) + 1, (y << 1) + 1, z2 << 1) || this._cube[level - 1].getXYZ((x << 1) + 1, y << 1, (z2 << 1) + 1) || this._cube[level - 1].getXYZ(x << 1, (y << 1) + 1, (z2 << 1) + 1) || this._cube[level - 1].getXYZ((x << 1) + 1, (y << 1) + 1, (z2 << 1) + 1)) {
                            this._cube[level].setXYZ(x, y, z2, true);
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z2;
            }
            ++level;
        }
    }

    private int calc_max_level(RegularGrid3i voxelCube) {
        int max_size = Math.max(Math.max(voxelCube.get_dim_x(), voxelCube.get_dim_y()), voxelCube.get_dim_z());
        int max_level = 0;
        while ((1 << max_level) + 1 < max_size) {
            ++max_level;
        }
        return max_level;
    }

    public String create_str_representation() {
        return this.create_str_representation(this._max_level);
    }

    public String create_str_representation(int depth) {
        StringBuilder sb = new StringBuilder("BinVolumeOctree leve " + (this._cube.length - 1));
        int i = this._max_level - depth;
        while (i < this._cube.length) {
            sb.append("\n[" + this._cube[i].get_dim_x() + "]:\n");
            sb.append(this._cube[i].create_str_representation());
            ++i;
        }
        return sb.toString();
    }
}

