/*
 * Decompiled with CFR 0.152.
 */
package raycaster;

import javax.vecmath.Color4f;
import javax.vecmath.Point3f;
import main.Segment;
import misc.Voxel;
import misc.grid.VoxelCube;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import raycaster.BinVolumeOctree;
import raycaster.SegmentInfoOctree;
import raycaster.gui.SegmentService;
import raycaster.settings.ControlPoint;
import raycaster.settings.SegmentRetrieverMock;
import raycaster.settings.SegmentSettingFactory;
import raycaster.settings.SegmentSettings;
import raycaster.settings.TransferFunctionSetting;

public class BinVolumeOctreeTest {
    Color4f[] _color_table;
    VoxelCube _vc;
    BinVolumeOctree _bvo;
    SegmentInfoOctree _soc;
    SegmentSettings _global_opaque;

    @Before
    public void before() {
        this._color_table = new Color4f[]{new Color4f(0.0f, 0.0f, 0.0f, 0.0f), new Color4f(1.0f, 1.0f, 1.0f, 1.0f)};
        this._vc = new VoxelCube(5, 4, 3);
        this._vc.set(1, 3, 1, 1);
        this._vc.set(2, 2, 1, 1);
        this._vc.set(3, 1, 2, 1);
        this._vc.set(3, 2, 2, 1);
        this._global_opaque = new SegmentSettings();
        this._global_opaque.add_segment(SegmentService.ALL_VOXELS_SEGMENT, new TransferFunctionSetting());
        this._soc = new SegmentInfoOctree(this._vc.get_dim_x(), this._vc.get_dim_y(), this._vc.get_dim_z(), 1, this._global_opaque);
        this._bvo = new BinVolumeOctree(this._color_table, this._vc, this._soc);
    }

    @Test
    public void test_max_level() {
        Assert.assertEquals((long)2L, (long)this._bvo.get_max_level());
        Assert.assertEquals((long)0L, (long)new BinVolumeOctree(this._color_table, new VoxelCube(1, 0, 0), new SegmentInfoOctree(1, 0, 0, 1, this._global_opaque)).get_max_level());
        Assert.assertEquals((long)2L, (long)new BinVolumeOctree(this._color_table, new VoxelCube(0, 4, 0), new SegmentInfoOctree(0, 4, 0, 1, this._global_opaque)).get_max_level());
        Assert.assertEquals((long)2L, (long)new BinVolumeOctree(this._color_table, new VoxelCube(0, 0, 5), new SegmentInfoOctree(0, 0, 5, 1, this._global_opaque)).get_max_level());
        Assert.assertEquals((long)4L, (long)new BinVolumeOctree(this._color_table, new VoxelCube(0, 0, 16), new SegmentInfoOctree(0, 0, 16, 1, this._global_opaque)).get_max_level());
        Assert.assertEquals((long)4L, (long)new BinVolumeOctree(this._color_table, new VoxelCube(0, 0, 17), new SegmentInfoOctree(0, 0, 17, 1, this._global_opaque)).get_max_level());
        Assert.assertEquals((long)5L, (long)new BinVolumeOctree(this._color_table, new VoxelCube(0, 0, 18), new SegmentInfoOctree(0, 0, 18, 1, this._global_opaque)).get_max_level());
        Assert.assertEquals((long)7L, (long)new BinVolumeOctree(this._color_table, new VoxelCube(7, 26, 69), new SegmentInfoOctree(7, 26, 69, 1, this._global_opaque)).get_max_level());
    }

    @Test
    public void test_make_index() {
        Voxel index = new Voxel();
        this._bvo.make_index(0, new Point3f(4.3f, 3.0f, 0.0f), index);
        Assert.assertEquals((Object)new Voxel(4, 3, 0), (Object)index);
        this._bvo.make_index(1, new Point3f(4.3f, 3.0f, 7.0f), index);
        Assert.assertEquals((Object)new Voxel(2, 1, 3), (Object)index);
        this._bvo.make_index(2, new Point3f(4.3f, 3.0f, 0.0f), index);
        Assert.assertEquals((Object)new Voxel(1, 0, 0), (Object)index);
        this._bvo.make_index(3, new Point3f(4.3f, 3.0f, 0.0f), index);
        Assert.assertEquals((Object)new Voxel(0, 0, 0), (Object)index);
        this._bvo.make_index(4, new Point3f(4.3f, 3.0f, 0.0f), index);
        Assert.assertEquals((Object)new Voxel(0, 0, 0), (Object)index);
    }

    @Test
    public void test_parent_index() {
        Voxel parent = new Voxel();
        this._bvo.parent_index(new Voxel(5, 0, 2), parent);
        Assert.assertEquals((Object)new Voxel(2, 0, 1), (Object)parent);
        this._bvo.parent_index(new Voxel(0, 0, 0), parent);
        Assert.assertEquals((Object)new Voxel(0, 0, 0), (Object)parent);
        this._bvo.parent_index(new Voxel(9, 4, 1), parent);
        Assert.assertEquals((Object)new Voxel(4, 2, 0), (Object)parent);
    }

    @Test
    public void test_level_0() {
        boolean[][][] blArrayArray = new boolean[4][][];
        boolean[][] blArrayArray2 = new boolean[4][];
        blArrayArray2[0] = new boolean[4];
        boolean[] blArray = new boolean[4];
        blArray[1] = true;
        blArray[2] = true;
        blArrayArray2[1] = blArray;
        boolean[] blArray2 = new boolean[4];
        blArray2[0] = true;
        blArray2[1] = true;
        blArray2[2] = true;
        blArrayArray2[2] = blArray2;
        boolean[] blArray3 = new boolean[4];
        blArray3[0] = true;
        blArray3[1] = true;
        blArrayArray2[3] = blArray3;
        blArrayArray[0] = blArrayArray2;
        boolean[][] blArrayArray3 = new boolean[4][];
        boolean[] blArray4 = new boolean[4];
        blArray4[2] = true;
        blArray4[3] = true;
        blArrayArray3[0] = blArray4;
        boolean[] blArray5 = new boolean[4];
        blArray5[1] = true;
        blArray5[2] = true;
        blArray5[3] = true;
        blArrayArray3[1] = blArray5;
        blArrayArray3[2] = new boolean[]{true, true, true, true};
        boolean[] blArray6 = new boolean[4];
        blArray6[0] = true;
        blArray6[1] = true;
        blArrayArray3[3] = blArray6;
        blArrayArray[1] = blArrayArray3;
        boolean[][] blArrayArray4 = new boolean[4][];
        boolean[] blArray7 = new boolean[4];
        blArray7[2] = true;
        blArray7[3] = true;
        blArrayArray4[0] = blArray7;
        boolean[] blArray8 = new boolean[4];
        blArray8[2] = true;
        blArray8[3] = true;
        blArrayArray4[1] = blArray8;
        boolean[] blArray9 = new boolean[4];
        blArray9[2] = true;
        blArray9[3] = true;
        blArrayArray4[2] = blArray9;
        blArrayArray4[3] = new boolean[4];
        blArrayArray[2] = blArrayArray4;
        blArrayArray[3] = new boolean[][]{new boolean[4], new boolean[4], new boolean[4], new boolean[4]};
        boolean[][][] data = blArrayArray;
        int z = 0;
        while (z < 4) {
            int y = 0;
            while (y < 4) {
                int x = 0;
                while (x < 4) {
                    Assert.assertEquals((Object)data[z][y][x], (Object)this._bvo.is_visible(0, new Voxel(x, y, z)));
                    ++x;
                }
                ++y;
            }
            ++z;
        }
    }

    @Test
    public void test_higher_level() {
        Assert.assertTrue((boolean)this._bvo.is_visible(1, new Voxel(0, 0, 0)));
        Assert.assertTrue((boolean)this._bvo.is_visible(1, new Voxel(1, 0, 0)));
        Assert.assertTrue((boolean)this._bvo.is_visible(1, new Voxel(0, 1, 0)));
        Assert.assertTrue((boolean)this._bvo.is_visible(1, new Voxel(1, 1, 0)));
        Assert.assertTrue((boolean)this._bvo.is_visible(1, new Voxel(1, 0, 1)));
        Assert.assertTrue((boolean)this._bvo.is_visible(1, new Voxel(1, 1, 1)));
        Assert.assertFalse((boolean)this._bvo.is_visible(1, new Voxel(0, 0, 1)));
        Assert.assertFalse((boolean)this._bvo.is_visible(1, new Voxel(0, 1, 1)));
        Assert.assertTrue((boolean)this._bvo.is_visible(2, new Voxel(0, 0, 0)));
    }

    @Test
    public void test_only_segment_opaque() {
        Segment segment = new Segment("small semgment", this._vc.get_dim_x(), this._vc.get_dim_y(), this._vc.get_dim_z());
        segment.get_bc().setXYZ(1, 3, 1, true);
        SegmentSettings settings = new SegmentSettings();
        TransferFunctionSetting tf = new TransferFunctionSetting();
        ControlPoint cp1 = new ControlPoint();
        ControlPoint cp2 = new ControlPoint();
        cp1.set_opacity(0.5f);
        cp2.set_opacity(0.5f);
        cp1.set_intensity(0);
        cp2.set_intensity(0);
        tf.add_control_point(cp1);
        tf.add_control_point(cp2);
        SegmentSettingFactory.set_segment_retriever(new SegmentRetrieverMock(segment));
        settings.add_segment(segment, tf);
        SegmentInfoOctree soc = new SegmentInfoOctree(this._vc.get_dim_x(), this._vc.get_dim_y(), this._vc.get_dim_z(), 1, settings);
        BinVolumeOctree bvo = new BinVolumeOctree(this._color_table, this._vc, soc);
        Assert.assertTrue((boolean)bvo.is_visible(2, new Voxel(0, 0, 0)));
    }

    @Test
    public void test_reverse_indexing() {
        int dim_x = 11;
        int dim_y = 7;
        int dim_z = 23;
        int z = 0;
        while (z < 23) {
            int y = 0;
            while (y < 7) {
                int x = 0;
                while (x < 11) {
                    int index = x + 11 * (y + 7 * z);
                    int dz = 77;
                    int dy = 11;
                    int zz = index / 77;
                    int yy = index % 77 / 11;
                    int xx = index % 11;
                    Assert.assertTrue((x == xx ? 1 : 0) != 0);
                    Assert.assertTrue((y == yy ? 1 : 0) != 0);
                    Assert.assertTrue((z == zz ? 1 : 0) != 0);
                    ++x;
                }
                ++y;
            }
            ++z;
        }
    }
}

