/*
 * Decompiled with CFR 0.152.
 */
package raycaster;

import javax.media.j3d.Transform3D;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import misc.helper.Interpolation;

final class Camera {
    private final int _img_width;
    private final int _img_height;
    private final float _x_half_size;
    private final float _y_half_size;
    private final Point3f _eye;
    private final Transform3D _transform;

    public Camera(int width, int height, Transform3D view_transform, Transform3D ray_to_cube_transform) {
        this._img_width = width;
        this._img_height = height;
        float aspect_ratio = (float)width / (float)height;
        Vector3f tmp_eye = new Vector3f();
        view_transform.get(tmp_eye);
        this._eye = new Point3f((Tuple3f)tmp_eye);
        ray_to_cube_transform.transform(this._eye);
        this._transform = new Transform3D();
        this._transform.mul(view_transform, ray_to_cube_transform);
        float scaling = 0.7f;
        this._x_half_size = 0.35f;
        this._y_half_size = -this._x_half_size / aspect_ratio;
    }

    public final Point3f get_eye_in_world() {
        return this._eye;
    }

    public final void make_dir(int x, int y, Vector3f dir) {
        float fx = Interpolation.linear(x, 0.0f, this._img_width, -this._x_half_size, this._x_half_size);
        float fy = Interpolation.linear(y, 0.0f, this._img_height, -this._y_half_size, this._y_half_size);
        dir.set(fx, fy, -1.0f);
        this._transform.transform(dir);
    }
}

