/*
 * Decompiled with CFR 0.152.
 */
package raycaster;

import raycaster.BinVolumeOctree;
import raycaster.Ray;
import raycaster.RayStrategy;

final class EmptySpaceSkipping
implements RayStrategy {
    private final BinVolumeOctree _bvo;
    private final int _edge_size;
    private final int _stop_level;
    private final int _max_level;

    public EmptySpaceSkipping(BinVolumeOctree bvo) {
        this._bvo = bvo;
        this._edge_size = 1 << this._bvo.get_max_level();
        this._stop_level = 2;
        this._max_level = this._bvo.get_max_level();
    }

    @Override
    public final void cast_ray(Ray ray, float t_start, float t_stop) {
        double rox = ray.get_base().x;
        double roy = ray.get_base().y;
        double roz = ray.get_base().z;
        double rdx = ray.get_dir().x;
        double rdy = ray.get_dir().y;
        double rdz = ray.get_dir().z;
        int ax = 0;
        int ay = 0;
        int az = 0;
        if (rdx < 0.0) {
            rox = (double)this._edge_size - rox;
            rdx = -rdx;
            ax = 1;
        }
        if (rdy < 0.0) {
            roy = (double)this._edge_size - roy;
            rdy = -rdy;
            ay = 1;
        }
        if (rdz < 0.0) {
            roz = (double)this._edge_size - roz;
            rdz = -rdz;
            az = 1;
        }
        double tx0 = (0.0 - rox) / rdx;
        double tx1 = ((double)this._edge_size - rox) / rdx;
        double ty0 = (0.0 - roy) / rdy;
        double ty1 = ((double)this._edge_size - roy) / rdy;
        double tz0 = (0.0 - roz) / rdz;
        double tz1 = ((double)this._edge_size - roz) / rdz;
        if (EmptySpaceSkipping.max(tx0, ty0, tz0) < EmptySpaceSkipping.min(tx1, ty1, tz1)) {
            this.proc_subtree(ray, tx0, ty0, tz0, tx1, ty1, tz1, this._max_level, 0, 0, 0, t_start, t_stop, ax, ay, az);
        }
    }

    private final void proc_subtree(Ray ray, double tx0, double ty0, double tz0, double tx1, double ty1, double tz1, int level, int ix, int iy, int iz, double t_min, double t_max, int ax, int ay, int az) {
        if (tx1 < 0.0 || ty1 < 0.0 || tz1 < 0.0) {
            return;
        }
        if (!this._bvo.is_visible(level, ix, iy, iz)) {
            return;
        }
        if (level <= this._stop_level) {
            ray.render_interval((float)Math.max(t_min, EmptySpaceSkipping.max(tx0, ty0, tz0)), (float)Math.min(t_max, EmptySpaceSkipping.min(tx1, ty1, tz1)));
            return;
        }
        double txm = this.calc_tm(tx0, tx1, level, ix, ray.get_dir().x, ray.get_base().x);
        double tym = this.calc_tm(ty0, ty1, level, iy, ray.get_dir().y, ray.get_base().y);
        double tzm = this.calc_tm(tz0, tz1, level, iz, ray.get_dir().z, ray.get_base().z);
        int current_node = this.first_node(tx0, ty0, tz0, txm, tym, tzm);
        do {
            switch (current_node) {
                case 0: {
                    this.proc_subtree(ray, tx0, ty0, tz0, txm, tym, tzm, level - 1, 2 * ix + ax, 2 * iy + ay, 2 * iz + az, t_min, t_max, ax, ay, az);
                    current_node = this.next_node(txm, tym, tzm, 4, 2, 1);
                    break;
                }
                case 1: {
                    this.proc_subtree(ray, tx0, ty0, tzm, txm, tym, tz1, level - 1, 2 * ix + ax, 2 * iy + ay, 2 * iz + (1 ^ az), t_min, t_max, ax, ay, az);
                    current_node = this.next_node(txm, tym, tz1, 5, 3, 8);
                    break;
                }
                case 2: {
                    this.proc_subtree(ray, tx0, tym, tz0, txm, ty1, tzm, level - 1, 2 * ix + ax, 2 * iy + (1 ^ ay), 2 * iz + az, t_min, t_max, ax, ay, az);
                    current_node = this.next_node(txm, ty1, tzm, 6, 8, 3);
                    break;
                }
                case 3: {
                    this.proc_subtree(ray, tx0, tym, tzm, txm, ty1, tz1, level - 1, 2 * ix + ax, 2 * iy + (1 ^ ay), 2 * iz + (1 ^ az), t_min, t_max, ax, ay, az);
                    current_node = this.next_node(txm, ty1, tz1, 7, 8, 8);
                    break;
                }
                case 4: {
                    this.proc_subtree(ray, txm, ty0, tz0, tx1, tym, tzm, level - 1, 2 * ix + (1 ^ ax), 2 * iy + ay, 2 * iz + az, t_min, t_max, ax, ay, az);
                    current_node = this.next_node(tx1, tym, tzm, 8, 6, 5);
                    break;
                }
                case 5: {
                    this.proc_subtree(ray, txm, ty0, tzm, tx1, tym, tz1, level - 1, 2 * ix + (1 ^ ax), 2 * iy + ay, 2 * iz + (1 ^ az), t_min, t_max, ax, ay, az);
                    current_node = this.next_node(tx1, tym, tz1, 8, 7, 8);
                    break;
                }
                case 6: {
                    this.proc_subtree(ray, txm, tym, tz0, tx1, ty1, tzm, level - 1, 2 * ix + (1 ^ ax), 2 * iy + (1 ^ ay), 2 * iz + az, t_min, t_max, ax, ay, az);
                    current_node = this.next_node(tx1, ty1, tzm, 8, 8, 7);
                    break;
                }
                case 7: {
                    this.proc_subtree(ray, txm, tym, tzm, tx1, ty1, tz1, level - 1, 2 * ix + (1 ^ ax), 2 * iy + (1 ^ ay), 2 * iz + (1 ^ az), t_min, t_max, ax, ay, az);
                    current_node = 8;
                }
            }
        } while (8 != current_node && !ray.is_terminated());
    }

    private final double calc_tm(double t0, double t1, int level, int i, double ray_dir, double ray_base) {
        if (0.0 == ray_dir) {
            double center = (this._edge_size >> this._max_level - level) * (2 * i + 1) / 2;
            return ray_base < center ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        return (t0 + t1) / 2.0;
    }

    private final int first_node(double tx0, double ty0, double tz0, double txm, double tym, double tzm) {
        int bit0 = 4;
        int bit1 = 2;
        boolean bit2 = true;
        int node = 0;
        if (tx0 >= ty0 && tx0 >= tz0) {
            if (tym < tx0) {
                node |= 2;
            }
            if (tzm < tx0) {
                node |= 1;
            }
        } else if (ty0 >= tx0 && ty0 >= tz0) {
            if (txm < ty0) {
                node |= 4;
            }
            if (tzm < ty0) {
                node |= 1;
            }
        } else {
            if (txm < tz0) {
                node |= 4;
            }
            if (tym < tz0) {
                node |= 2;
            }
        }
        return node;
    }

    private final int next_node(double tx, double ty, double tz, int a, int b, int c) {
        if (tx <= ty && tx <= tz) {
            return a;
        }
        if (ty <= tx && ty <= tz) {
            return b;
        }
        return c;
    }

    private static final double max(double a, double b, double c) {
        return Math.max(Math.max(a, b), c);
    }

    private static final double min(double a, double b, double c) {
        return Math.min(Math.min(a, b), c);
    }
}

