/*
 * Decompiled with CFR 0.152.
 */
package raycaster;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.vecmath.Color4f;
import misc.MutableColor;
import raycaster.gui.TransferFunctionTab;
import settings.Settings;

public final class LitSphereMap {
    private final BufferedImage _map;
    private final int[] _map_pixels;
    private final int _map_width;
    private final int _map_height;
    private final MutableColor _lit_sphere_color;
    private final int _intensity;
    private final float _opacity;
    private final int _crop_size;
    private final Color4f _color;

    public LitSphereMap(BufferedImage map, float opacity, int intensity, Color4f return_color) {
        this._color = return_color;
        this._crop_size = Settings.get_int_option(TransferFunctionTab.class, TransferFunctionTab.OPT_CROP_SIZE);
        this._map = new BufferedImage(map.getWidth() - 2 * this._crop_size, map.getHeight() - 2 * this._crop_size, 2);
        this._map.createGraphics().drawImage(map, 0, 0, this._map.getWidth(), this._map.getHeight(), this._crop_size, this._crop_size, map.getWidth() - this._crop_size, map.getHeight() - this._crop_size, null);
        this._map_pixels = ((DataBufferInt)this._map.getRaster().getDataBuffer()).getData();
        this._map_width = this._map.getWidth();
        this._map_height = this._map.getHeight();
        this._opacity = opacity;
        this._lit_sphere_color = new MutableColor();
        this._intensity = intensity;
    }

    public int get_intensity() {
        return this._intensity;
    }

    public float get_opacity() {
        return this._opacity;
    }

    public void addSampleWeighted(float nx, float ny, float weight) {
        int x = (int)((-nx + 1.0f) * 0.5f * (float)(this._map_width - 1) + 0.5f);
        int y = (int)((ny + 1.0f) * 0.5f * (float)(this._map_height - 1) + 0.5f);
        this._lit_sphere_color.setRGB(this._map_pixels[y * this._map_width + x]);
        this._color.x += (float)this._lit_sphere_color.getRed() / 255.0f * weight;
        this._color.y += (float)this._lit_sphere_color.getGreen() / 255.0f * weight;
        this._color.z += (float)this._lit_sphere_color.getBlue() / 255.0f * weight;
        this._color.w += (float)this._lit_sphere_color.getAlpha() / 255.0f * weight;
    }
}

