/*
 * Decompiled with CFR 0.152.
 */
package raycaster;

import java.io.File;
import main.tools.ToolRayCasting;
import settings.Settings;

public class LitSphereMapFile
extends File {
    public static final String BRUSHES_SUBDIR = "brushes";
    private String _trimmed_path;

    public static LitSphereMapFile create(String path) {
        File brushes_dir = new File(LitSphereMapFile.get_brushes_path());
        if (LitSphereMapFile.path_lies_in_brushes_dir(path) || LitSphereMapFile.path_exists_in_brushes_dir(path)) {
            String file_name = LitSphereMapFile.get_file_name_if_in_def_dir(path);
            LitSphereMapFile local_file = new LitSphereMapFile(brushes_dir + File.separator + file_name);
            local_file._trimmed_path = file_name;
            return local_file;
        }
        LitSphereMapFile file = new LitSphereMapFile(path);
        file._trimmed_path = file.getAbsolutePath();
        return file;
    }

    public static LitSphereMapFile create(File source) {
        return LitSphereMapFile.create(source.getAbsolutePath());
    }

    private LitSphereMapFile(String path) {
        super(path);
    }

    private static String get_brushes_path() {
        File resources_dir = new File(Settings.get_str_option(ToolRayCasting.class, ToolRayCasting.OPT_RESOURCES_DIR));
        String resources_path = resources_dir.getAbsolutePath();
        return String.valueOf(resources_path) + File.separator + BRUSHES_SUBDIR;
    }

    private static String get_file_name_if_in_def_dir(String path) {
        File file = new File(path);
        String absolute_path = file.getAbsolutePath();
        if (LitSphereMapFile.path_lies_in_brushes_dir(absolute_path)) {
            return file.getName();
        }
        if (LitSphereMapFile.path_exists_in_brushes_dir(path)) {
            return path;
        }
        throw new RuntimeException("Could not resolve path");
    }

    private static boolean path_lies_in_brushes_dir(String path) {
        File file = new File(path);
        return file.getAbsolutePath().startsWith(LitSphereMapFile.get_brushes_path());
    }

    private static boolean path_exists_in_brushes_dir(String path) {
        File file = new File(String.valueOf(LitSphereMapFile.get_brushes_path()) + File.separator + path);
        return file.exists();
    }

    public String get_trimmed_path() {
        return this._trimmed_path;
    }
}

