/*
 * Decompiled with CFR 0.152.
 */
package raycaster;

import java.io.File;
import junit.framework.Assert;
import main.tools.ToolRayCasting;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import raycaster.LitSphereMapFile;
import settings.Settings;

public class LitSphereMapFileTest {
    private final String RESOURCE_FILE_NAME = "sphere1.png";
    private final String RESOURCES_DIR = "resources";
    private final String NON_RESOURCES_DIR = "anywhere/and/does/not/exist";
    private final File RESOURCES_FILE = new File("resources" + File.separator + "brushes" + File.separator + "sphere1.png");
    private final File NON_RESOURCES_FILE = new File("anywhere/and/does/not/exist" + File.separator + "sphere1.png");
    private String path;
    private LitSphereMapFile testFile;

    @Before
    public void setUp() {
        this.registerResourcesDirSetting();
    }

    @After
    public void tearDown() {
        this.path = null;
        this.testFile = null;
    }

    private void registerResourcesDirSetting() {
        Settings.register_str_opt(ToolRayCasting.class, "resources directory", "", "resources");
    }

    @Test
    public void testResourcesFileWithAbsolutePath() {
        this.givenAbsolutePathFromResourcesFile();
        this.whenCreateLsmFile();
        this.thenNameAndPathsShouldEqualResourcesFile();
    }

    private void whenCreateLsmFile() {
        this.testFile = LitSphereMapFile.create(this.path);
    }

    private void givenAbsolutePathFromResourcesFile() {
        this.path = this.RESOURCES_FILE.getAbsolutePath();
    }

    private void thenNameAndPathsShouldEqualResourcesFile() {
        Assert.assertEquals((String)"sphere1.png", (String)this.testFile.getName());
        Assert.assertEquals((String)"sphere1.png", (String)this.testFile.get_trimmed_path());
        Assert.assertEquals((String)this.RESOURCES_FILE.getAbsolutePath(), (String)this.testFile.getAbsolutePath());
    }

    @Test
    public void testResourcesFileWithRelativePath() {
        this.givenRelativePathFromResourcesFile();
        this.whenCreateLsmFile();
        this.thenNameAndPathsShouldEqualResourcesFile();
    }

    private void givenRelativePathFromResourcesFile() {
        this.path = "resources" + File.separator + "brushes" + File.separator + "sphere1.png";
    }

    @Test
    public void testResourcesFileWithFileName() {
        this.givenFileNameFromResourcesFile();
        this.whenCreateLsmFile();
        this.thenNameAndPathsShouldEqualResourcesFile();
    }

    private void givenFileNameFromResourcesFile() {
        this.path = "sphere1.png";
    }

    @Test
    public void testNonResourcesFileWithAbsolutePath() {
        this.givenAbsolutePathFromNonResourcesFile();
        this.whenCreateLsmFile();
        this.thenNameAndPathsShouldEqualNonResourcesFile();
    }

    private void givenAbsolutePathFromNonResourcesFile() {
        this.path = this.NON_RESOURCES_FILE.getAbsolutePath();
    }

    private void thenNameAndPathsShouldEqualNonResourcesFile() {
        Assert.assertEquals((String)"sphere1.png", (String)this.testFile.getName());
        Assert.assertEquals((String)this.NON_RESOURCES_FILE.getAbsolutePath(), (String)this.testFile.get_trimmed_path());
        Assert.assertEquals((String)this.NON_RESOURCES_FILE.getAbsolutePath(), (String)this.testFile.getAbsolutePath());
    }

    @Test
    public void testNonResourcesFileWithRelativePath() {
        this.givenRelativePathFromNonResourcesFile();
        this.whenCreateLsmFile();
        this.thenNameAndPathsShouldEqualNonResourcesFile();
    }

    private void givenRelativePathFromNonResourcesFile() {
        this.path = "anywhere/and/does/not/exist/sphere1.png";
    }
}

