/*
 * Decompiled with CFR 0.152.
 */
package raycaster;

import java.util.Arrays;
import javax.media.j3d.Transform3D;
import javax.vecmath.Color4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import raycaster.RenderContext;

public final class Ray {
    private final Point3f _base = new Point3f();
    private final Vector3f _dir = new Vector3f();
    private RenderContext _render_context;
    private boolean _terminated = false;
    private final Color4f _color = new Color4f();
    private boolean[] _inside_segment;
    private boolean[] _segment_surface_traversed;

    public Ray(Point3f base, Vector3f dir) {
        this._base.set((Tuple3f)base);
        this._dir.set((Tuple3f)dir);
        this._dir.normalize();
    }

    public Ray() {
    }

    public Point3f get_base() {
        return this._base;
    }

    public Vector3f get_dir() {
        return this._dir;
    }

    public void set(Point3f base, Vector3f dir) {
        this._base.set((Tuple3f)base);
        this._dir.set((Tuple3f)dir);
        this._dir.normalize();
    }

    public void eval(float t, Point3f p) {
        p.scaleAdd(t, (Tuple3f)this._dir, (Tuple3f)this._base);
    }

    public void transform(Transform3D transformation) {
        transformation.transform(this._base);
        transformation.transform(this._dir);
        this._dir.normalize();
    }

    public final void set_render_context(RenderContext render_context) {
        this._render_context = render_context;
        int segment_count = this._render_context.get_segment_settings().get_segment_count();
        this._inside_segment = new boolean[segment_count];
        this._segment_surface_traversed = new boolean[segment_count];
    }

    public final void render_interval(float t_min, float t_max) {
        this._terminated = this._render_context.render_interval(this, t_min, t_max, this._color);
    }

    public final boolean is_terminated() {
        return this._terminated;
    }

    public final void get_color(Color4f result_color, Color4f background) {
        result_color.scaleAdd(1.0f - this._color.w, (Tuple4f)background, (Tuple4f)this._color);
    }

    public final void set_base(Point3f base) {
        this._base.set((Tuple3f)base);
    }

    public final void init(Vector3f dir) {
        this._dir.normalize(dir);
        this._color.set(0.0f, 0.0f, 0.0f, 0.0f);
        this._terminated = false;
        Arrays.fill(this._inside_segment, false);
        Arrays.fill(this._segment_surface_traversed, false);
    }

    public final boolean has_traversed_segment_surface(int i) {
        return this._segment_surface_traversed[i];
    }

    public final void set_inside_segment(int i) {
        this._segment_surface_traversed[i] = !this._inside_segment[i];
        this._inside_segment[i] = true;
    }

    public final void set_outside_segment(int i) {
        this._segment_surface_traversed[i] = this._inside_segment[i];
        this._inside_segment[i] = false;
    }

    public boolean box_intersection(float[] box_min, float[] box_max, BoxIntersection intersection) {
        float t_near = Float.NEGATIVE_INFINITY;
        float t_far = Float.POSITIVE_INFINITY;
        intersection.dir[0] = this._dir.x;
        intersection.dir[1] = this._dir.y;
        intersection.dir[2] = this._dir.z;
        intersection.base[0] = this._base.x;
        intersection.base[1] = this._base.y;
        intersection.base[2] = this._base.z;
        float EPSILON = 1.0E-5f;
        int i = 0;
        while (i < 3) {
            if (Math.abs(intersection.dir[i]) < 1.0E-5f) {
                if (intersection.base[i] < box_min[i] || intersection.base[i] > box_max[i]) {
                    return false;
                }
            } else {
                float t1 = (box_min[i] - intersection.base[i]) / intersection.dir[i];
                float t2 = (box_max[i] - intersection.base[i]) / intersection.dir[i];
                if (t1 > t2) {
                    float tmp = t1;
                    t1 = t2;
                    t2 = tmp;
                }
                if (t1 > t_near) {
                    t_near = t1;
                }
                if (t2 < t_far) {
                    t_far = t2;
                }
                if (t_near > t_far) {
                    return false;
                }
                if (t_far < 0.0f) {
                    return false;
                }
            }
            ++i;
        }
        intersection._near = t_near;
        intersection._far = t_far;
        return true;
    }

    public static class BoxIntersection {
        float _near;
        float _far;
        float[] dir = new float[3];
        float[] base = new float[3];

        public BoxIntersection(float f, float l) {
            this._near = f;
            this._far = l;
        }

        public BoxIntersection() {
            this._far = 0.0f;
            this._near = 0.0f;
        }

        public float get_near() {
            return this._near;
        }

        public float get_far() {
            return this._far;
        }
    }
}

