/*
 * Decompiled with CFR 0.152.
 */
package raycaster;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.util.Stack;
import javax.media.j3d.Transform3D;
import javax.vecmath.Color4f;
import javax.vecmath.Vector3d;
import main.Segment;
import main.tools.ToolRayCasting;
import misc.grid.VoxelCube;
import misc.grid.filter.FilterType;
import misc.grid.gradients.GradientCachingMethod;
import misc.grid.gradients.GradientFunctionType;
import org.apache.log4j.PropertyConfigurator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import raycaster.RayCastingRenderer;
import raycaster.gui.SegmentService;
import raycaster.gui.StyleChooser;
import raycaster.renderer.RenderMethod;
import raycaster.settings.ControlPoint;
import raycaster.settings.FilterSettings;
import raycaster.settings.GradientSettings;
import raycaster.settings.LightingSettings;
import raycaster.settings.RenderInfo;
import raycaster.settings.RenderSettings;
import raycaster.settings.SegmentRetrieverMock;
import raycaster.settings.SegmentSettingFactory;
import raycaster.settings.SegmentSettings;
import raycaster.settings.TransferFunctionSetting;
import settings.Settings;

public class RayCastingRenderTest {
    private final String RESOURCES_DIR = "resources";
    private static final int VOXEL_VALUE_RANGE = 100;
    private static final int CUBE_SIZE = 10;

    @Before
    public void register_stuff() {
        PropertyConfigurator.configure((String)"resources/log4j.properties");
        Settings.register_str_opt(ToolRayCasting.class, "resources directory", "", "resources");
    }

    public static Transform3D add_transform(Stack<Transform3D> stack) {
        stack.push(new Transform3D());
        return stack.peek();
    }

    public RenderSettings get_render_settings() {
        Segment segment = new Segment("seg 1", 10, 10, 10);
        segment.set_color(0xFFFF00);
        segment.get_bc().setXYZ(5, 5, 5, true);
        segment.get_bc().setXYZ(5, 6, 5, true);
        segment.get_bc().setXYZ(6, 5, 5, true);
        Segment segment2 = new Segment("seg 2", 10, 10, 10);
        segment2.set_color(65280);
        segment2.get_bc().setXYZ(4, 5, 5, true);
        segment2.get_bc().setXYZ(5, 4, 5, true);
        SegmentSettings segment_settings = new SegmentSettings();
        LightingSettings lighting_settings = new LightingSettings();
        lighting_settings.set_gradient_settings(new GradientSettings(GradientFunctionType.NEUMANN_4D_LINEAR_REGRESSION, GradientCachingMethod.ON_THE_FLY));
        TransferFunctionSetting tf = new TransferFunctionSetting();
        tf.set_render_method(RenderMethod.PHONG_SHADING);
        ControlPoint cp1 = new ControlPoint(0, 0.0f);
        tf.add_control_point(cp1);
        ControlPoint cp2 = new ControlPoint(25, 0.2f);
        tf.add_control_point(cp2);
        ControlPoint cp3 = new ControlPoint(99, 1.0f);
        tf.add_control_point(cp3);
        for (ControlPoint cp : tf) {
            cp.set_color(new Color4f(StyleChooser.get_default_color()));
            cp.set_style_source(StyleChooser.get_default_style().get_absolute_path());
        }
        TransferFunctionSetting seg_tf = new TransferFunctionSetting();
        seg_tf.set_render_method(RenderMethod.PHONG_SHADING);
        ControlPoint seg_cp1 = new ControlPoint(9, 0.0f);
        seg_tf.add_control_point(seg_cp1);
        ControlPoint seg_cp2 = new ControlPoint(12, 0.2f);
        seg_tf.add_control_point(seg_cp2);
        ControlPoint seg_cp3 = new ControlPoint(50, 1.0f);
        seg_tf.add_control_point(seg_cp3);
        for (ControlPoint cp : seg_tf) {
            cp.set_color(new Color4f(StyleChooser.get_default_color()));
            cp.set_style_source(StyleChooser.get_default_style().get_absolute_path());
        }
        SegmentSettingFactory.set_segment_retriever(new SegmentRetrieverMock(segment, segment2));
        segment_settings.add_segment(SegmentService.ALL_VOXELS_SEGMENT, tf);
        segment_settings.add_segment(segment, seg_tf);
        segment_settings.add_segment(segment2, seg_tf);
        Transform3D view_transform = new Transform3D();
        view_transform.setTranslation(new Vector3d(0.0, 0.0, 1.0 + Math.sqrt(2.0)));
        Transform3D world_transform = new Transform3D();
        Stack<Transform3D> stack = new Stack<Transform3D>();
        RayCastingRenderTest.add_transform(stack).setScale(0.1111111111111111);
        RayCastingRenderTest.add_transform(stack).setTranslation(new Vector3d(-0.5, -0.5, -0.5));
        RayCastingRenderTest.add_transform(stack).setScale((double)1.6f);
        while (!stack.empty()) {
            world_transform.mul(stack.pop());
        }
        RenderSettings settings = new RenderSettings();
        settings.set_segment_settings(segment_settings);
        settings.set_lighting_settings(lighting_settings);
        settings.set_width(50);
        settings.set_height(50);
        settings.set_sampling_rate(1.0f);
        settings.set_ray_termination(0.005f);
        settings.set_thread_count(1);
        settings.set_use_octree(true);
        settings.set_filter_settings(new FilterSettings(FilterType.TRILINEAR));
        settings.set_view_transform(view_transform);
        settings.set_world_transform(world_transform);
        settings.set_light_transform(new Transform3D());
        RenderInfo info = new RenderInfo();
        info.set_slice_count(10);
        info.set_slice_height(10);
        info.set_slice_width(10);
        info.set_max_voxel_value(100);
        settings.set_render_info(info);
        return settings;
    }

    @Test
    public void render() throws IOException {
        RenderSettings render_settings = this.get_render_settings();
        VoxelCube voxel_cube = this.createVoxelCube();
        RayCastingRenderer renderer = new RayCastingRenderer(render_settings, voxel_cube);
        BufferedImage bimg = new BufferedImage(render_settings.get_width(), render_settings.get_height(), 2);
        int[] img_data = ((DataBufferInt)bimg.getRaster().getDataBuffer()).getData();
        try {
            renderer.render(img_data, null, null);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private VoxelCube createVoxelCube() {
        VoxelCube voxel_cube = new VoxelCube(10, 10, 10);
        voxel_cube.set(5, 5, 5, 99);
        voxel_cube.set(4, 5, 5, 99);
        voxel_cube.set(5, 4, 5, 99);
        voxel_cube.set(6, 5, 5, 99);
        voxel_cube.set(5, 6, 5, 99);
        return voxel_cube;
    }
}

