/*
 * Decompiled with CFR 0.152.
 */
package raycaster;

import javax.media.j3d.Transform3D;
import javax.swing.JFrame;
import javax.vecmath.Color4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import misc.StopWatch;
import misc.grid.RegularGrid3i;
import raycaster.BinVolumeOctree;
import raycaster.Camera;
import raycaster.EmptySpaceSkipping;
import raycaster.Ray;
import raycaster.RayStrategy;
import raycaster.RenderContext;
import raycaster.SegmentInfoOctree;
import raycaster.gui.GuiTransferFunction;
import raycaster.gui.SegmentService;
import raycaster.settings.RenderSettings;
import raycaster.settings.SegmentSettings;
import threads.RSThread;

public final class RayCastingRenderer {
    private final RenderSettings _render_settings;
    private final SegmentSettings _segment_settings;
    private final int _width;
    private final int _height;
    private final float _sample_dist;
    private float[] _box_min;
    private float[] _box_max;
    private final Color4f[] _color_table;
    private final RegularGrid3i _vc;
    private final Camera _camera;
    private final Transform3D _ray_to_cube_transform;
    private final SegmentInfoOctree _segment_opacity;
    private final BinVolumeOctree _bvo;
    private final int _thread_count;
    private volatile boolean _stop = false;
    private final Color4f _background;

    public RayCastingRenderer(RenderSettings render_settings, RegularGrid3i voxel_cube) {
        this._render_settings = render_settings;
        this._vc = voxel_cube;
        this._width = render_settings.get_width();
        this._height = render_settings.get_height();
        this._background = new Color4f(render_settings.get_background_color());
        this._background.w = 1.0f;
        this._sample_dist = 1.0f / this._render_settings.get_sampling_rate();
        this._ray_to_cube_transform = new Transform3D();
        this._camera = this.init_environment(this._ray_to_cube_transform);
        this.init_bouding_boxes();
        this._segment_settings = this._render_settings.get_segment_settings();
        int max_intensity_value = this._render_settings.get_render_info().get_max_voxel_value();
        StopWatch op_seg_sw = new StopWatch(true);
        this._segment_opacity = new SegmentInfoOctree(this._vc.get_dim_x(), this._vc.get_dim_y(), this._vc.get_dim_z(), max_intensity_value, this._segment_settings);
        op_seg_sw.stop();
        System.out.println("RayCastingRenderer::RayCastingRenderer - Created Segment Opacity Octree in " + op_seg_sw);
        this._color_table = this.make_color_table(max_intensity_value);
        if (render_settings.is_use_octree()) {
            StopWatch bvo_gen_sw = new StopWatch(true);
            this._bvo = new BinVolumeOctree(this._color_table, voxel_cube, this._segment_opacity);
            bvo_gen_sw.stop();
            System.out.println("RayCastingRenderer::RayCastingRenderer - Created Bin Visibility Volume on " + bvo_gen_sw);
        } else {
            this._bvo = null;
        }
        this._thread_count = render_settings.get_thread_count();
    }

    public final void stop_soon() {
        this._stop = true;
    }

    public final void render(int[] pixels, JFrame frame, RSThread starting_thread) {
        if (starting_thread != null) {
            starting_thread.set_progress_min(0);
            starting_thread.set_progress_max(this._height - 1);
            starting_thread.set_progress_val(0);
        }
        RenderThread[] threads = new RenderThread[this._thread_count];
        int i = 0;
        while (i < this._thread_count) {
            threads[i] = new RenderThread(i, pixels, frame, starting_thread);
            ++i;
        }
        RenderThread[] renderThreadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            RenderThread t = renderThreadArray[n2];
            t.start();
            ++n2;
        }
        renderThreadArray = threads;
        n = threads.length;
        n2 = 0;
        while (n2 < n) {
            RenderThread t = renderThreadArray[n2];
            try {
                t.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    private final Camera init_environment(Transform3D ray_to_cube_transform) {
        ray_to_cube_transform.set(this._render_settings.get_world_transform());
        ray_to_cube_transform.invert();
        Transform3D view_transform = new Transform3D();
        view_transform.set(this._render_settings.get_view_transform());
        Camera camera = new Camera(this._width, this._height, view_transform, ray_to_cube_transform);
        return camera;
    }

    private final Color4f[] make_color_table(int size) {
        Color4f[] color_table = null;
        GuiTransferFunction transfer_function = new GuiTransferFunction(this._segment_settings.get_setting_for_segment(SegmentService.ALL_VOXELS_SEGMENT).get_transfer_function());
        Color4f[] color4fArray = color_table = transfer_function.calculateColorTable(size);
        int n = color_table.length;
        int n2 = 0;
        while (n2 < n) {
            Color4f color = color4fArray[n2];
            color.w = (float)(1.0 - Math.pow(1.0f - color.w, this._sample_dist));
            ++n2;
        }
        return color_table;
    }

    private final void init_bouding_boxes() {
        this._box_min = new float[]{0.0f, 0.0f, 0.0f};
        this._box_max = new float[]{this._vc.get_dim_x() - 1, this._vc.get_dim_y() - 1, this._vc.get_dim_z() - 1};
    }

    private final class RenderThread
    extends Thread {
        private final int _i;
        private final int[] _data;
        private final RSThread _starting_thread;
        private final JFrame _frame;

        public RenderThread(int i, int[] data, JFrame frame, RSThread starting_thread) {
            this._i = i;
            this._data = data;
            this._starting_thread = starting_thread;
            this._frame = frame;
        }

        @Override
        public final void run() {
            Color4f color = new Color4f();
            Vector3f ray_dir = new Vector3f();
            Ray.BoxIntersection intersection_result = new Ray.BoxIntersection();
            RenderContext _render_context = new RenderContext(RayCastingRenderer.this._render_settings, RayCastingRenderer.this._vc);
            RayStrategy ray_strategy = this.new_ray_strategy();
            Ray ray = new Ray();
            ray.set_render_context(_render_context);
            ray.set_base(RayCastingRenderer.this._camera.get_eye_in_world());
            int y = this._i;
            while (y < RayCastingRenderer.this._height) {
                if (RayCastingRenderer.this._stop) {
                    return;
                }
                if (y % 10 == 0) {
                    if (this._starting_thread != null) {
                        this._starting_thread.inc_progress_value(10);
                    }
                    if (this._frame != null) {
                        this._frame.repaint();
                    }
                }
                int x = 0;
                while (x < RayCastingRenderer.this._width) {
                    RayCastingRenderer.this._camera.make_dir(x, y, ray_dir);
                    ray.init(ray_dir);
                    if (ray.box_intersection(RayCastingRenderer.this._box_min, RayCastingRenderer.this._box_max, intersection_result)) {
                        ray_strategy.cast_ray(ray, intersection_result.get_near(), intersection_result.get_far());
                        ray.get_color(color, RayCastingRenderer.this._background);
                    } else {
                        color.set((Tuple4f)RayCastingRenderer.this._background);
                    }
                    color.clampMax(1.0f);
                    this._data[x + ((RayCastingRenderer)RayCastingRenderer.this)._width * y] = color.get().getRGB();
                    ++x;
                }
                y += RayCastingRenderer.this._thread_count;
            }
        }

        private final RayStrategy new_ray_strategy() {
            if (RayCastingRenderer.this._render_settings.is_use_octree()) {
                return new EmptySpaceSkipping(RayCastingRenderer.this._bvo);
            }
            return new SimpleRayStrategy();
        }
    }

    private class SimpleRayStrategy
    implements RayStrategy {
        private SimpleRayStrategy() {
        }

        @Override
        public void cast_ray(Ray ray, float t_start, float t_stop) {
            ray.render_interval(t_start, t_stop);
        }
    }
}

