/*
 * Decompiled with CFR 0.152.
 */
package raycaster;

import javax.media.j3d.Transform3D;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import raycaster.Ray;

public class RayTest {
    private static float epsilon = 1.0E-5f;
    private Transform3D transformation;
    private Point3f pos;
    private Vector3f dir;
    private Vector3f dir_norm;
    private Point3f eval_expected;
    private Ray ray;

    @Before
    public void init() {
        this.transformation = new Transform3D();
        this.transformation.set(new Vector3d(5.0, -2.5, 0.0));
        this.transformation.rotX(4.5);
        this.transformation.rotY(-0.2);
        this.pos = new Point3f(3.0f, 1.0f, 3.0f);
        this.dir = new Vector3f(-6.0f, 2.0f, 3.0f);
        this.dir_norm = new Vector3f(this.dir);
        this.dir_norm.normalize();
        this.eval_expected = new Point3f();
        this.eval_expected.add((Tuple3f)this.pos, (Tuple3f)this.dir);
        this.ray = new Ray(this.pos, this.dir);
    }

    @Test
    public void constructor() {
        Ray my_ray = new Ray(this.pos, this.dir);
        Assert.assertNotSame((Object)this.pos, (Object)my_ray.get_base());
        Assert.assertNotSame((Object)this.dir, (Object)my_ray.get_dir());
        Assert.assertTrue((boolean)this.pos.epsilonEquals((Tuple3f)my_ray.get_base(), epsilon));
        Assert.assertEquals((double)1.0, (double)my_ray.get_dir().length(), (double)epsilon);
        Assert.assertTrue((boolean)this.dir_norm.epsilonEquals((Tuple3f)my_ray.get_dir(), epsilon));
    }

    @Test
    public void set_function() {
        Ray my_ray = new Ray();
        my_ray.set(this.pos, this.dir);
        Assert.assertNotSame((Object)this.pos, (Object)my_ray.get_base());
        Assert.assertNotSame((Object)this.dir, (Object)my_ray.get_dir());
        Assert.assertTrue((boolean)this.pos.epsilonEquals((Tuple3f)my_ray.get_base(), epsilon));
        Assert.assertEquals((double)1.0, (double)my_ray.get_dir().length(), (double)epsilon);
        Assert.assertTrue((boolean)this.dir_norm.epsilonEquals((Tuple3f)my_ray.get_dir(), epsilon));
    }

    @Test
    public void eval() {
        Point3f test = new Point3f();
        this.ray.eval(this.dir.length(), test);
        Assert.assertTrue((boolean)this.eval_expected.epsilonEquals((Tuple3f)test, epsilon));
    }

    @Test
    public void transform() {
        Point3f test = new Point3f();
        this.ray.transform(this.transformation);
        Assert.assertEquals((double)1.0, (double)this.ray.get_dir().length(), (double)epsilon);
        this.ray.eval(7.0f, test);
        Point3f trans_eval_expected = (Point3f)this.eval_expected.clone();
        this.transformation.transform(trans_eval_expected);
        Assert.assertTrue((boolean)trans_eval_expected.epsilonEquals((Tuple3f)test, epsilon));
    }
}

