/*
 * Decompiled with CFR 0.152.
 */
package raycaster;

import java.util.Iterator;
import javax.media.j3d.Transform3D;
import javax.vecmath.Color4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import main.Segment;
import main.view3d.Shader;
import misc.grid.PaddedRegularGrid3i;
import misc.grid.RegularGrid3i;
import misc.grid.filter.FilterFactory;
import misc.grid.filter.FilterOptions;
import misc.grid.filter.FilterType;
import misc.grid.filter.GridAndGradientFilter;
import misc.grid.gradients.GradientCachingMethod;
import misc.grid.gradients.GradientFunction;
import misc.grid.gradients.GradientFunctionFactory;
import misc.grid.gradients.GradientFunctionType;
import misc.helper.Interpolation;
import org.apache.log4j.Logger;
import raycaster.Ray;
import raycaster.SegmentNormalMerger;
import raycaster.SegmentTfMerger;
import raycaster.renderer.RenderData;
import raycaster.renderer.Renderer;
import raycaster.renderer.RendererFactory;
import raycaster.settings.ControlPoint;
import raycaster.settings.FilterSettings;
import raycaster.settings.GradientSettings;
import raycaster.settings.LightingSettings;
import raycaster.settings.RenderSettings;
import raycaster.settings.SegmentSetting;
import raycaster.settings.SegmentSettings;
import raycaster.settings.TransferFunctionSetting;

public final class RenderContext {
    private static final Logger logger = Logger.getLogger(RenderContext.class);
    private static final float SEGMENT_SCORE_THRESHOLD = 0.5f;
    private final RenderSettings _render_settings;
    private final SegmentSettings _segment_settings;
    private final SegmentSetting[] _segment_settings_array;
    private final RenderData _render_data = new RenderData();
    private final Segment[] _segments;
    private final SegmentTfMerger _segment_merger;
    private final Renderer[] _renderers;
    private GridAndGradientFilter[] _filters;
    private final GridAndGradientFilter[] _unsafe_filters;
    private final GridAndGradientFilter[] _safe_filters;
    private final int _safe_filter_padding;
    private final int _safe_upper_x_bound;
    private final int _safe_upper_y_bound;
    private final int _safe_upper_z_bound;
    private final boolean _illustrative_transparency;
    private final boolean _renderers_need_ray_surface_product;
    private final boolean _renderers_need_gradient_length;
    private final boolean _renderers_need_sample_point;
    private final boolean _renderers_need_curvature;
    private final boolean _renderers_need_contour_theshold;
    private final float[][] _opacity_tables;
    private final float _sample_dist;
    private final float _alpha_cap;
    private final Transform3D _light_transform;
    private final Transform3D _world_transform;
    private final LightingSettings _lighting;
    private final Shader _shader_chain;
    private final Point3f _sample_point = new Point3f();
    private final Point3f _prev_sample_point = new Point3f();
    private final Vector3f _normal = new Vector3f();
    private final Vector3f _prev_normal = new Vector3f();
    private float _gradient_length;
    private final Vector3f _tmp_normal = new Vector3f();
    private final Vector3f _segment_normal = new Vector3f();
    private final Color4f _sample_color = new Color4f();
    private final Color4f[] _render_tmp_colors;
    private final Vector3f[] _grads = new Vector3f[8];
    private float _opacity_factor;
    private float _curvature;
    private float _pre_contour_threshold;
    private float _contour_threshold;
    private final Point3f _bisection_point = new Point3f();
    private final Vector3f ray_dir = new Vector3f();

    public RenderContext(RenderSettings render_settings, RegularGrid3i vc) {
        this._render_settings = render_settings;
        this._segment_settings = this._render_settings.get_segment_settings();
        this._segment_merger = this._segment_settings.get_segment_tf_merge_mode();
        this._lighting = this._render_settings.get_lighting_settings();
        this._shader_chain = Shader.copy_all(this._lighting.shader_chain());
        this._sample_dist = 1.0f / this._render_settings.get_sampling_rate();
        this._alpha_cap = 1.0f - this._render_settings.get_ray_termination();
        RendererFactory renderer_factory = new RendererFactory(this._render_settings, this._render_data, this._shader_chain);
        int number_of_segments = this._segment_settings.get_segment_count() + 1;
        this._segment_settings_array = new SegmentSetting[number_of_segments];
        this._segment_settings.get_segments().toArray(this._segment_settings_array);
        this._renderers = new Renderer[number_of_segments];
        this._opacity_tables = new float[number_of_segments][];
        this._render_tmp_colors = new Color4f[number_of_segments];
        this._segments = new Segment[number_of_segments - 1];
        int i = 0;
        while (i < this._segments.length) {
            this._segments[i] = this._segment_settings.get_segments().get(i + 1).segment();
            ++i;
        }
        i = 0;
        while (i < number_of_segments) {
            this._render_tmp_colors[i] = new Color4f();
            SegmentSetting segment_setting = this._segment_settings_array[i];
            TransferFunctionSetting tf_setting = segment_setting.get_transfer_function();
            float[] opacity_table = this.create_opacity_table(tf_setting);
            this._opacity_tables[i] = opacity_table;
            this._renderers[i] = renderer_factory.create(segment_setting, opacity_table, this._render_tmp_colors[i]);
            ++i;
        }
        GradientSettings gradient_settings = render_settings.get_lighting_settings().get_gradient_settings();
        GradientFunctionType gradient_type = gradient_settings.get_type();
        GradientCachingMethod gradient_caching_method = gradient_settings.get_caching_method();
        FilterSettings filter_settings = render_settings.get_filter_settings();
        FilterType filter_type = filter_settings.get_filter_type();
        FilterOptions filter_options = null;
        if (filter_settings.get_filter_options() != null) {
            filter_options = filter_settings.get_filter_options().toFilterOptions();
        }
        this._safe_filter_padding = filter_type.get_filter_radius() + gradient_type.get_filter_radius();
        this._safe_upper_x_bound = vc.get_dim_x() - this._safe_filter_padding - 1;
        this._safe_upper_y_bound = vc.get_dim_y() - this._safe_filter_padding - 1;
        this._safe_upper_z_bound = vc.get_dim_z() - this._safe_filter_padding - 1;
        this._unsafe_filters = new GridAndGradientFilter[number_of_segments];
        this._safe_filters = new GridAndGradientFilter[number_of_segments];
        this._filters = this._safe_filters;
        int i2 = 0;
        while (i2 < number_of_segments) {
            RegularGrid3i volume = this.get_ith_volume(i2, vc);
            PaddedRegularGrid3i safe_volume = new PaddedRegularGrid3i(volume, this._safe_filter_padding);
            GradientFunction gradient_function = GradientFunctionFactory.get_gradient_function(volume, gradient_type, gradient_caching_method);
            GradientFunction safe_gradient_function = GradientFunctionFactory.get_gradient_function(safe_volume, gradient_type, gradient_caching_method);
            this._unsafe_filters[i2] = FilterFactory.create_grid_and_gradient_filter(volume, gradient_function, filter_type, filter_options);
            this._safe_filters[i2] = FilterFactory.create_grid_and_gradient_filter(safe_volume, safe_gradient_function, filter_type, filter_options);
            ++i2;
        }
        boolean renderers_need_contour_theshold = false;
        boolean renderers_need_curvature = false;
        boolean renderers_need_gradient_length = false;
        boolean renderers_need_ray_surface_product = false;
        boolean renderers_need_sample_point = false;
        Renderer[] rendererArray = this._renderers;
        int n = this._renderers.length;
        int n2 = 0;
        while (n2 < n) {
            Renderer r = rendererArray[n2];
            renderers_need_contour_theshold |= r.needs_contour_threshold();
            renderers_need_curvature |= r.needs_curvature();
            renderers_need_gradient_length |= r.needs_gradient_length();
            renderers_need_ray_surface_product |= r.needs_ray_surface_product();
            renderers_need_sample_point |= r.needs_sample_point();
            ++n2;
        }
        this._renderers_need_contour_theshold = renderers_need_contour_theshold;
        this._renderers_need_curvature = renderers_need_curvature;
        this._renderers_need_gradient_length = renderers_need_gradient_length;
        this._renderers_need_ray_surface_product = renderers_need_ray_surface_product;
        this._renderers_need_sample_point = renderers_need_sample_point;
        this._illustrative_transparency = render_settings.is_use_transparency();
        this._light_transform = render_settings.get_light_transform();
        this._world_transform = render_settings.get_world_transform();
        int i3 = 0;
        while (i3 < this._grads.length) {
            this._grads[i3] = new Vector3f();
            ++i3;
        }
    }

    private RegularGrid3i get_ith_volume(int i, RegularGrid3i vc) {
        if (i == 0) {
            return vc;
        }
        return this._segments[i - 1].get_bc();
    }

    private float[] create_opacity_table(TransferFunctionSetting transfer_function) {
        int max_voxel_value = this._render_settings.get_render_info().get_max_voxel_value();
        float[] opacity_table = new float[max_voxel_value + 1];
        Iterator<ControlPoint> map_iter = transfer_function.get_control_points().iterator();
        if (map_iter.hasNext()) {
            ControlPoint right = map_iter.next();
            while (map_iter.hasNext()) {
                ControlPoint left = right;
                right = map_iter.next();
                int i = left.get_intensity();
                while (i < right.get_intensity()) {
                    float opacity = Interpolation.linear(i, left.get_intensity(), right.get_intensity(), left.get_opacity(), right.get_opacity());
                    opacity_table[i] = (float)(1.0 - Math.pow(1.0f - opacity, this._sample_dist));
                    ++i;
                }
            }
        }
        return opacity_table;
    }

    public final boolean render_interval(Ray ray, float t_min, float t_max, Color4f accumulated_color) {
        this._prev_normal.set(0.0f, 0.0f, 0.0f);
        float t = RenderContext.next_sampel_t(t_min, this._sample_dist);
        this._tmp_normal.set((Tuple3f)ray.get_dir());
        this._light_transform.transform(this._tmp_normal);
        this._tmp_normal.normalize();
        Shader.calculate_halfway_all(this._shader_chain, this._tmp_normal);
        while (t < t_max && accumulated_color.w <= this._alpha_cap) {
            ray.eval(t, this._sample_point);
            this.set_correct_filters();
            float intensity = this._filters[0].sample_grid_value_and_gradient_at(this._sample_point, this._normal);
            if (this._renderers_need_gradient_length) {
                this._gradient_length = this._normal.length();
            }
            this.ray_dir.set((Tuple3f)ray.get_dir());
            this._world_transform.transform(this.ray_dir);
            this.ray_dir.normalize();
            this._world_transform.transform(this._normal);
            if (this._normal.x == 0.0f && this._normal.y == 0.0f && this._normal.z == 0.0f) {
                this._normal.set((Tuple3f)this.ray_dir);
            }
            this._normal.normalize();
            this.set_render_data(intensity);
            this.set_renderer_specific_render_data(0);
            this.calculate_sample_color_contribution(0);
            int i = 1;
            while (i < this._renderers.length) {
                int segment_index = i - 1;
                SegmentSetting segment_setting = this._segment_settings_array[i];
                this.set_renderer_specific_render_data(i);
                float segment_score = this.calculate_segment_score_and_normal(i, this._sample_point);
                boolean surface_traversed = ray.has_traversed_segment_surface(segment_index);
                if (segment_score >= 0.5f || surface_traversed) {
                    boolean is_surface_voxel;
                    boolean accurate_surface_detection = this._segment_settings.get_use_accurate_surface_detection();
                    boolean is_direct_surface_voxel = (ray.has_traversed_segment_surface(segment_index) || surface_traversed) && accurate_surface_detection;
                    boolean bl = is_surface_voxel = this.is_surface_voxel() && !accurate_surface_detection && !surface_traversed;
                    if (is_surface_voxel || is_direct_surface_voxel) {
                        if (is_direct_surface_voxel) {
                            this.aprox_intersection(i, this._bisection_point);
                            this._filters[i].sample_gradient_at(this._bisection_point, this._tmp_normal);
                            this._world_transform.transform(this._tmp_normal);
                            this._tmp_normal.normalize();
                        }
                        SegmentNormalMerger normal_merger = segment_setting.get_segment_normal_merger();
                        if (this._segment_settings.get_use_accurate_surface_detection()) {
                            normal_merger.calculate(this._tmp_normal, this._segment_normal);
                        } else {
                            normal_merger.calculate(this._normal, this._segment_normal);
                        }
                        this._render_data.nx = this._segment_normal.x;
                        this._render_data.ny = this._segment_normal.y;
                        this._render_data.nz = this._segment_normal.z;
                        this.calculate_sample_color_contribution(i);
                        float surface_opacity = segment_setting.get_surface_opacity();
                        if (surface_opacity > 0.0f && this._render_tmp_colors[i].w >= 0.0f) {
                            this._render_tmp_colors[i].w = surface_opacity;
                        }
                    } else if (segment_setting.is_surface_rendering()) {
                        this.clean_up_renderer_color(i);
                    } else {
                        this._render_data.nx = this._normal.x;
                        this._render_data.ny = this._normal.y;
                        this._render_data.nz = this._normal.z;
                        this.calculate_sample_color_contribution(i);
                    }
                    if (segment_score >= 0.5f) {
                        ray.set_inside_segment(segment_index);
                    }
                } else {
                    this.clean_up_renderer_color(i);
                    if (segment_setting.is_show_backplane()) {
                        ray.set_outside_segment(segment_index);
                    }
                }
                ++i;
            }
            this._sample_color.set(0.0f, 0.0f, 0.0f, 0.0f);
            this._segment_merger.calculate(this._sample_color, this._render_tmp_colors);
            this.add_alpha_weighted(accumulated_color);
            t += this._sample_dist;
            this._prev_normal.set((Tuple3f)this._normal);
            this._prev_sample_point.set((Tuple3f)this._sample_point);
        }
        return accumulated_color.w > this._alpha_cap;
    }

    private void set_correct_filters() {
        this._filters = this.sample_point_is_in_border_region() ? this._safe_filters : this._unsafe_filters;
    }

    private boolean sample_point_is_in_border_region() {
        return this._sample_point.x < (float)this._safe_filter_padding || this._sample_point.y < (float)this._safe_filter_padding || this._sample_point.z < (float)this._safe_filter_padding || this._sample_point.x >= (float)this._safe_upper_x_bound || this._sample_point.y >= (float)this._safe_upper_y_bound || this._sample_point.z >= (float)this._safe_upper_z_bound;
    }

    private void clean_up_renderer_color(int renderer_index) {
        this._render_tmp_colors[renderer_index].w = -1.0f;
    }

    private void set_render_data(float density) {
        this._render_data.intensity = density;
        this._render_data.nx = this._normal.x;
        this._render_data.ny = this._normal.y;
        this._render_data.nz = this._normal.z;
        this._render_data.gradient_length = this._gradient_length;
        if (this._renderers_need_ray_surface_product) {
            this._render_data.ray_surface_product = this._normal.dot(this.ray_dir);
        }
        if (this._renderers_need_sample_point) {
            this._render_data.sample_point.set((Tuple3f)this._sample_point);
        }
        if (this._renderers_need_curvature || this._renderers_need_contour_theshold) {
            this._curvature = this._normal.lengthSquared() == 0.0f || this._prev_normal.lengthSquared() == 0.0f ? 0.0f : this._normal.angle(this._prev_normal) / this._sample_dist;
            this._render_data.curvature = this._curvature;
        }
    }

    private void set_renderer_specific_render_data(int renderer_index) {
        Renderer renderer = this._renderers[renderer_index];
        SegmentSetting segment_setting = this._segment_settings_array[renderer_index];
        if (renderer.needs_contour_threshold()) {
            float contour_thickness = segment_setting.get_contour_thickness();
            if (this._curvature > 1.0f / contour_thickness) {
                this._curvature = 1.0f / contour_thickness;
            }
            this._pre_contour_threshold = contour_thickness * this._curvature * (2.0f - contour_thickness * this._curvature);
            if (this._pre_contour_threshold >= 0.0f) {
                this._contour_threshold = (float)Math.sqrt(this._pre_contour_threshold);
            } else {
                logger.warn((Object)">>>>>>>>>>>>>>>>>>>>Failed contour-threshold calculation");
                logger.warn((Object)("curvature: " + this._curvature + ", pre-thresh: " + this._pre_contour_threshold + ", x:" + this._normal.x + ", y:" + this._normal.y));
                logger.warn((Object)("ray_surface_prod: " + this._normal.dot(this.ray_dir)));
            }
            this._render_data.contour_threshold = this._contour_threshold;
        }
    }

    private void calculate_sample_color_contribution(int renderer_index) {
        Renderer renderer = this._renderers[renderer_index];
        if (renderer.needs_normal() && this._render_data.nx == 0.0f && this._render_data.ny == 0.0f && this._render_data.nz == 0.0f) {
            this.clean_up_renderer_color(renderer_index);
            return;
        }
        renderer.calculate_sample_color();
        this.calculate_sample_transparency(renderer_index);
    }

    private void calculate_sample_transparency(int renderer_index) {
        int intensity = (int)this._render_data.intensity;
        float[] opacity_table = this._opacity_tables[renderer_index];
        this._opacity_factor = this._illustrative_transparency ? (float)Math.pow(opacity_table[intensity], 0.5 + (double)Math.max(0.0f, Math.abs(this._render_data.ray_surface_product) - this._render_data.contour_threshold)) : opacity_table[intensity];
        Color4f _tmp_color = this._render_tmp_colors[renderer_index];
        _tmp_color.w *= this._opacity_factor;
    }

    private final float calculate_segment_score_and_normal(int segment_index, Point3f point) {
        float score = this._filters[segment_index].sample_grid_value_and_gradient_at(point, this._segment_normal);
        if (this._segment_normal.x != 0.0f && this._segment_normal.y != 0.0f && this._segment_normal.z != 0.0f) {
            this._world_transform.transform(this._segment_normal);
            this._segment_normal.normalize();
        }
        return score;
    }

    private static final float pow_aprox(float x, float n) {
        return x / (n - n * x + x);
    }

    private static float next_sampel_t(float start, float sample_dist) {
        float ret = (float)((int)(start / sample_dist)) * sample_dist;
        if (ret < start) {
            ret += sample_dist;
        }
        return ret;
    }

    private void add_alpha_weighted(Color4f acc) {
        if (this._sample_color.w > 0.0f) {
            float fac = this._sample_color.w * (1.0f - acc.w);
            acc.x += this._sample_color.x * fac;
            acc.y += this._sample_color.y * fac;
            acc.z += this._sample_color.z * fac;
            acc.w += fac;
        }
    }

    private final void aprox_intersection(int segment_index, Point3f bisec_point) {
        Point3f outside_point;
        Point3f inside_point;
        if (this.calculate_segment_score_and_normal(segment_index, this._sample_point) >= 0.5f) {
            inside_point = this._sample_point;
            outside_point = this._prev_sample_point;
        } else {
            inside_point = this._prev_sample_point;
            outside_point = this._sample_point;
        }
        float bisec_t = 0.5f;
        float bisec_dt = 0.25f;
        int max_loops = this._render_settings.get_tmp_settings().get_bisec_steps();
        float bisec_threshold = 1.0E-4f;
        float bisec_score = 0.0f;
        int i = 0;
        while (i < max_loops) {
            bisec_point.interpolate((Tuple3f)outside_point, (Tuple3f)inside_point, bisec_t);
            bisec_score = this.calculate_segment_score_and_normal(segment_index, bisec_point);
            if (bisec_score > 0.5f) {
                if (bisec_score - 0.5f < 1.0E-4f) break;
                bisec_t -= bisec_dt;
            } else {
                if (0.5f - bisec_score < 1.0E-4f) break;
                bisec_t += bisec_dt;
            }
            ++i;
            bisec_dt *= 0.5f;
        }
    }

    public final SegmentSettings get_segment_settings() {
        return this._segment_settings;
    }

    private boolean is_surface_voxel() {
        return this._segment_normal.x != 0.0f && this._segment_normal.y != 0.0f && this._segment_normal.z != 0.0f;
    }
}

