/*
 * Decompiled with CFR 0.152.
 */
package raycaster;

import java.util.Arrays;
import java.util.Iterator;
import main.Segment;
import misc.IntList;
import raycaster.settings.ControlPoint;
import raycaster.settings.SegmentSettings;
import raycaster.settings.TransferFunctionSetting;

public final class SegmentInfoOctree {
    private final int _max_intensity_value;
    private final int _dim_x;
    private final int _dim_y;
    private final int _dim_z;
    private final int _cube_edge;
    private final SegmentSettings _settings;
    private static final int NO_SEGMENTS_VISIBLE_CODE = 0;
    private final SegmentsInfo[] _data_table;
    private final IntList _tree = new IntList();
    private final int _root_index;
    private final boolean[][] opacity_tables;

    public SegmentInfoOctree(int dim_x, int dim_y, int dim_z, int max_intensity_value, SegmentSettings settings) {
        this._dim_x = dim_x;
        this._dim_y = dim_y;
        this._dim_z = dim_z;
        this._max_intensity_value = max_intensity_value;
        this._settings = settings;
        this.opacity_tables = new boolean[settings.get_segment_count()][];
        int i = 0;
        while (i < this.opacity_tables.length) {
            this.opacity_tables[i] = this.create_boolean_opacity_table(settings.get_segments().get(i + 1).get_transfer_function(), this._max_intensity_value + 1);
            ++i;
        }
        int max_height = 0;
        int max_dim = Math.max(dim_x, Math.max(dim_y, dim_z));
        int edge_size = 1;
        while (edge_size <= max_dim) {
            edge_size *= 2;
            ++max_height;
        }
        this._cube_edge = edge_size;
        int data_size = 1 << this._settings.get_segment_count();
        this._data_table = new SegmentsInfo[data_size];
        this._root_index = this.build_tree(max_height);
    }

    private int build_tree(int max_height) {
        this._data_table[0] = this.create_segment_info_for_code(0);
        this._tree.add(0);
        if (this._settings.get_segment_count() == 0) {
            return 0;
        }
        return this.build_tree(0, 0, 0, max_height);
    }

    private int build_tree(int x, int y, int z, int level) {
        if (level == 0) {
            return -this.get_leaf_code(x, y, z);
        }
        if (level <= 5) {
            int seg_count = this._settings.get_segment_count();
            Segment[] segments = new Segment[seg_count];
            int[][] bin_data = new int[seg_count][];
            int i = 0;
            while (i < seg_count) {
                segments[i] = this._settings.get_segments().get(i + 1).segment();
                bin_data[i] = segments[i].get_bc().get_data();
                ++i;
            }
            int[] int_cache = new int[seg_count];
            int ints_per_img = segments[0].get_bc().get_ints_per_img();
            int ints_per_row = segments[0].get_bc().get_ints_per_row();
            int block_size = 1 << level;
            if (block_size > 32) {
                throw new RuntimeException("not supported size for block processing");
            }
            int[] nodes = new int[block_size * block_size * block_size];
            Arrays.fill(nodes, 0);
            int block_index = 0;
            if (x << level < this._dim_x && y << level < this._dim_y && z << level < this._dim_z) {
                int pz = 0;
                while (pz < block_size) {
                    int cube_z = (z << level) + pz;
                    if (cube_z >= this._dim_z) break;
                    int start_image = cube_z * ints_per_img;
                    int py = 0;
                    while (py < block_size) {
                        int cube_y = (y << level) + py;
                        if (cube_y >= this._dim_y) {
                            block_index += block_size * (block_size - py);
                            break;
                        }
                        int index = start_image + cube_y * ints_per_row + (x << level) / 32;
                        int i2 = 0;
                        while (i2 < seg_count) {
                            int_cache[i2] = bin_data[i2][index];
                            ++i2;
                        }
                        int px = 0;
                        int mask = 1;
                        while (px < block_size) {
                            int cube_x = (x << level) + px;
                            if (cube_x >= this._dim_x) {
                                block_index += block_size - px;
                                break;
                            }
                            int code = 0;
                            int i3 = 0;
                            int code_mask = 1;
                            while (i3 < seg_count) {
                                if ((int_cache[i3] & mask) != 0) {
                                    code += code_mask;
                                }
                                ++i3;
                                code_mask <<= 1;
                            }
                            if (this._data_table[code] == null) {
                                this._data_table[code] = this.create_segment_info_for_code(code);
                            }
                            nodes[block_index] = -code;
                            ++block_index;
                            ++px;
                            mask <<= 1;
                        }
                        ++py;
                    }
                    ++pz;
                }
            }
            return this.gen_from_plain(0, 0, 0, level, nodes, block_size);
        }
        int x2 = 2 * x;
        int y2 = 2 * y;
        int z2 = 2 * z;
        return this.combined_node(this.build_tree(x2, y2, z2, level - 1), this.build_tree(x2 + 1, y2, z2, level - 1), this.build_tree(x2, y2 + 1, z2, level - 1), this.build_tree(x2 + 1, y2 + 1, z2, level - 1), this.build_tree(x2, y2, z2 + 1, level - 1), this.build_tree(x2 + 1, y2, z2 + 1, level - 1), this.build_tree(x2, y2 + 1, z2 + 1, level - 1), this.build_tree(x2 + 1, y2 + 1, z2 + 1, level - 1));
    }

    private int gen_from_plain(int x, int y, int z, int level, int[] nodes, int block_size) {
        if (level == 0) {
            return nodes[x + block_size * (y + block_size * z)];
        }
        int dx = 2 * x;
        int dy = 2 * y;
        int dz = 2 * z;
        return this.combined_node(this.gen_from_plain(dx, dy, dz, level - 1, nodes, block_size), this.gen_from_plain(dx + 1, dy, dz, level - 1, nodes, block_size), this.gen_from_plain(dx, dy + 1, dz, level - 1, nodes, block_size), this.gen_from_plain(dx + 1, dy + 1, dz, level - 1, nodes, block_size), this.gen_from_plain(dx, dy, dz + 1, level - 1, nodes, block_size), this.gen_from_plain(dx + 1, dy, dz + 1, level - 1, nodes, block_size), this.gen_from_plain(dx, dy + 1, dz + 1, level - 1, nodes, block_size), this.gen_from_plain(dx + 1, dy + 1, dz + 1, level - 1, nodes, block_size));
    }

    private int combined_node(int sub0, int sub1, int sub2, int sub3, int sub4, int sub5, int sub6, int sub7) {
        if (sub0 == sub1 && sub0 == sub2 && sub0 == sub3 && sub0 == sub4 && sub0 == sub5 && sub0 == sub6 && sub0 == sub7) {
            return sub0;
        }
        int node_index = this._tree.size();
        this._tree.add(sub0);
        this._tree.add(sub1);
        this._tree.add(sub2);
        this._tree.add(sub3);
        this._tree.add(sub4);
        this._tree.add(sub5);
        this._tree.add(sub6);
        this._tree.add(sub7);
        return node_index;
    }

    private SegmentsInfo create_segment_info_for_code(int active_segments) {
        if (active_segments == 0) {
            return new SegmentsInfo(new int[0], new boolean[this._max_intensity_value + 1]);
        }
        int[] segmentNumbers = this.get_segment_number_from_code(active_segments);
        boolean[] combined_opacity_table = this.create_combined_opacity_table_from_segment_numbers(segmentNumbers);
        return new SegmentsInfo(segmentNumbers, combined_opacity_table);
    }

    private boolean[] create_combined_opacity_table_from_segment_numbers(int[] segmentNumbers) {
        boolean[] combined_opacity_table = new boolean[this._max_intensity_value + 1];
        int[] nArray = segmentNumbers;
        int n = segmentNumbers.length;
        int n2 = 0;
        while (n2 < n) {
            int segmentNumber = nArray[n2];
            boolean[] opacity_table = this.opacity_tables[segmentNumber];
            int i = 0;
            while (i < opacity_table.length) {
                int n3 = i;
                combined_opacity_table[n3] = combined_opacity_table[n3] | opacity_table[i];
                ++i;
            }
            ++n2;
        }
        return combined_opacity_table;
    }

    private int[] get_segment_number_from_code(int active_segments) {
        int[] segmentNumbers = new int[this._settings.get_segment_count()];
        int i = 0;
        int j = 0;
        int mask = 1;
        while (i < this._settings.get_segment_count()) {
            if ((active_segments & mask) != 0) {
                segmentNumbers[j] = i;
                ++j;
            }
            ++i;
            mask <<= 1;
        }
        return segmentNumbers;
    }

    private SegmentsInfo segment_info_at(int x, int y, int z) {
        int index = this._root_index;
        int half = this._cube_edge / 2;
        while (index > 0) {
            int next = (x < half ? 0 : 1) + (y < half ? 0 : 2) + (z < half ? 0 : 4);
            index = this._tree.get(index + next);
            x %= half;
            y %= half;
            z %= half;
            half /= 2;
        }
        return this._data_table[-index];
    }

    public boolean opacity_is_greater_than_zero_at(int x, int y, int z, int intensity) {
        return this.segment_info_at(x, y, z).get_combined_opacity(intensity);
    }

    private int get_leaf_code(int x, int y, int z) {
        boolean in_bounds;
        int code = 0;
        boolean bl = in_bounds = x < this._dim_x && y < this._dim_y && z < this._dim_z;
        if (in_bounds) {
            int i = 0;
            int mask = 1;
            while (i < this._settings.get_segment_count()) {
                if (this._settings.get_segments().get(i).segment().get_bc().getXYZ(x, y, z)) {
                    code |= mask;
                }
                ++i;
                mask <<= 1;
            }
        }
        if (this._data_table[code] == null) {
            this._data_table[code] = this.create_segment_info_for_code(code);
        }
        return code;
    }

    private boolean[] create_boolean_opacity_table(TransferFunctionSetting transfer_function, int voxel_value_range) {
        boolean[] opacity_table = new boolean[voxel_value_range];
        Iterator<ControlPoint> iter = transfer_function.get_control_points().iterator();
        if (iter.hasNext()) {
            ControlPoint right = iter.next();
            if (right.get_opacity() > 0.0f) {
                opacity_table[right.get_intensity()] = true;
            }
            while (iter.hasNext()) {
                ControlPoint left = right;
                right = iter.next();
                int i = left.get_intensity();
                while (i < right.get_intensity()) {
                    opacity_table[i] = right.get_opacity() > 0.0f | left.get_opacity() > 0.0f;
                    ++i;
                }
            }
        }
        return opacity_table;
    }

    private final class SegmentsInfo {
        private final boolean hasSegments;
        private final int[] segmentNumbers;
        private final boolean[] combined_opacity_table;

        public SegmentsInfo(int[] segmentNumbers, boolean[] combined_opacity_table) {
            this.hasSegments = segmentNumbers.length > 0;
            this.segmentNumbers = segmentNumbers;
            this.combined_opacity_table = combined_opacity_table;
        }

        public boolean hasSegments() {
            return this.hasSegments;
        }

        public int[] getSegmentNumbers() {
            return this.segmentNumbers;
        }

        public boolean get_combined_opacity(int intensity) {
            return this.combined_opacity_table[intensity];
        }
    }
}

