/*
 * Decompiled with CFR 0.152.
 */
package raycaster;

import javax.vecmath.Point3i;
import main.Segment;
import misc.grid.BitCube;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import raycaster.SegmentInfoOctree;
import raycaster.settings.ControlPoint;
import raycaster.settings.SegmentRetriever;
import raycaster.settings.SegmentSettingFactory;
import raycaster.settings.SegmentSettings;
import raycaster.settings.TransferFunctionSetting;

public class SegmentInfoOctreeTest {
    private final int dim_x = 65;
    private final int dim_y = 4;
    private final int dim_z = 4;
    private final Point3i vp1 = new Point3i(0, 0, 0);
    private final Point3i vp2 = new Point3i(32, 2, 2);
    private final Point3i vp3 = new Point3i(64, 3, 3);
    private Segment s0;
    private SegmentSettings segment_settings;
    private SegmentInfoOctree octree;

    @Before
    public void init_octree() {
        this.s0 = new Segment("s0", 65, 4, 4);
        BitCube cube = this.s0.get_bc();
        cube.setXYZ(this.vp1.x, this.vp1.y, this.vp1.z, true);
        cube.setXYZ(this.vp2.x, this.vp2.y, this.vp2.z, true);
        cube.setXYZ(this.vp3.x, this.vp3.y, this.vp3.z, true);
        TransferFunctionSetting tf = new TransferFunctionSetting();
        ControlPoint cp = new ControlPoint(0, 1.0f);
        tf.add_control_point(cp);
        SegmentSettingFactory.set_segment_retriever(new SegmentRetriever(){

            @Override
            public Segment segment_for_name(String name) {
                return SegmentInfoOctreeTest.this.s0;
            }
        });
        this.segment_settings = new SegmentSettings();
        this.segment_settings.add_segment(this.s0, tf);
        this.segment_settings.add_segment(this.s0, tf);
        this.octree = new SegmentInfoOctree(65, 4, 4, 1, this.segment_settings);
    }

    @Test
    public void test_opacity_is_greater_than_zero_at() {
        boolean value;
        int z;
        int y;
        int x = 0;
        while (x < 65) {
            y = 0;
            while (y < 4) {
                z = 0;
                while (z < 4) {
                    value = this.octree.opacity_is_greater_than_zero_at(x, y, z, 0);
                    if (value) {
                        System.out.printf("=========================== %d %d %d\n", x, y, z);
                    }
                    if (this.position_equals_point(x, y, z, this.vp1) || this.position_equals_point(x, y, z, this.vp2) || this.position_equals_point(x, y, z, this.vp3)) {
                        Assert.assertEquals((Object)true, (Object)value);
                    } else {
                        Assert.assertEquals((Object)false, (Object)value);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < 8) {
            y = 0;
            while (y < 8) {
                z = 0;
                while (z < 8) {
                    value = this.octree.opacity_is_greater_than_zero_at(x + 65, y + 4, z + 4, 0);
                    Assert.assertEquals((Object)false, (Object)value);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    private boolean position_equals_point(int x, int y, int z, Point3i p) {
        return x == p.x && y == p.y && z == p.z;
    }
}

