/*
 * Decompiled with CFR 0.152.
 */
package raycaster;

import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public enum SegmentNormalMerger {
    GLOBAL_NORMAL{

        @Override
        public void calculate(Vector3f global, Vector3f segment) {
            segment.set((Tuple3f)global);
        }
    }
    ,
    SEGMENT_NORMAL{

        @Override
        public void calculate(Vector3f global, Vector3f segment) {
        }
    }
    ,
    ALPHA_WEIGHT_GLOBAL_DIRECTION{

        @Override
        public void calculate(Vector3f global, Vector3f segment) {
            if (global.x == 0.0f && global.y == 0.0f && global.z == 0.0f) {
                return;
            }
            if (segment.x == 0.0f && segment.y == 0.0f && segment.z == 0.0f) {
                segment.set((Tuple3f)global);
                return;
            }
            if (global.dot(segment) < 0.0f) {
                segment.negate();
            }
            segment.x = global.x * 0.5f + segment.x * 0.5f;
            segment.y = global.y * 0.5f + segment.y * 0.5f;
            segment.z = global.z * 0.5f + segment.z * 0.5f;
            segment.normalize();
        }
    }
    ,
    ALPHA_WEIGHT_SEGMENT_DIRECTION{

        @Override
        public void calculate(Vector3f global, Vector3f segment) {
            if (global.x == 0.0f && global.y == 0.0f && global.z == 0.0f) {
                return;
            }
            if (segment.x == 0.0f && segment.y == 0.0f && segment.z == 0.0f) {
                segment.set((Tuple3f)global);
                return;
            }
            boolean negate = false;
            if (global.dot(segment) < 0.0f) {
                segment.negate();
                negate = true;
            }
            segment.x = global.x * 0.5f + segment.x * 0.5f;
            segment.y = global.y * 0.5f + segment.y * 0.5f;
            segment.z = global.z * 0.5f + segment.z * 0.5f;
            if (negate) {
                segment.negate();
            }
            segment.normalize();
        }
    };

    private static final float alpha = 0.5f;
    private static final float one_minus_alpha = 0.5f;

    private SegmentNormalMerger() {
    }

    abstract void calculate(Vector3f var1, Vector3f var2);

    /* synthetic */ SegmentNormalMerger(String string, int n, SegmentNormalMerger segmentNormalMerger) {
        this();
    }
}

