/*
 * Decompiled with CFR 0.152.
 */
package raycaster;

import javax.vecmath.Color4f;
import javax.vecmath.Tuple4f;

public enum SegmentTfMerger {
    AVERAGE{

        @Override
        public void calculate(Color4f result, Color4f[] contributions) {
            Color4f contribution;
            int numberOfContributions = 0;
            Color4f[] color4fArray = contributions;
            int n = contributions.length;
            int n2 = 0;
            while (n2 < n) {
                contribution = color4fArray[n2];
                if (contribution.w > 0.0f) {
                    result.w += contribution.w;
                }
                ++n2;
            }
            color4fArray = contributions;
            n = contributions.length;
            n2 = 0;
            while (n2 < n) {
                contribution = color4fArray[n2];
                if (contribution.w > 0.0f) {
                    float scale_factor = contribution.w / result.w;
                    ++numberOfContributions;
                    result.x += contribution.x * scale_factor;
                    result.y += contribution.y * scale_factor;
                    result.z += contribution.z * scale_factor;
                }
                ++n2;
            }
            if (numberOfContributions > 0) {
                result.w /= (float)numberOfContributions;
            }
        }
    }
    ,
    MAX_OPACITY{

        @Override
        public void calculate(Color4f result, Color4f[] contributions) {
            Color4f[] color4fArray = contributions;
            int n = contributions.length;
            int n2 = 0;
            while (n2 < n) {
                Color4f contribution = color4fArray[n2];
                if (contribution.w > result.w) {
                    result.set((Tuple4f)contribution);
                }
                ++n2;
            }
        }
    }
    ,
    MAX{

        @Override
        public void calculate(Color4f result, Color4f[] contributions) {
            Color4f[] color4fArray = contributions;
            int n = contributions.length;
            int n2 = 0;
            while (n2 < n) {
                Color4f contribution = color4fArray[n2];
                if (contribution.w > result.w) {
                    result.w = contribution.w;
                    if (result.x < contribution.x) {
                        result.x = contribution.x;
                    }
                    if (result.y < contribution.y) {
                        result.y = contribution.y;
                    }
                    if (result.z < contribution.z) {
                        result.z = contribution.z;
                    }
                }
                ++n2;
            }
        }
    }
    ,
    SUM{

        @Override
        public void calculate(Color4f result, Color4f[] contributions) {
            Color4f[] color4fArray = contributions;
            int n = contributions.length;
            int n2 = 0;
            while (n2 < n) {
                Color4f contribution = color4fArray[n2];
                if (contribution.w > 0.0f) {
                    result.add((Tuple4f)contribution);
                }
                ++n2;
            }
            result.clampMax(1.0f);
        }
    }
    ,
    MAX_PRIORITY{

        @Override
        public void calculate(Color4f result, Color4f[] contributions) {
            int i = 1;
            while (i < contributions.length) {
                if (contributions[i].w > 0.0f) {
                    result.set((Tuple4f)contributions[i]);
                    return;
                }
                ++i;
            }
            result.set((Tuple4f)contributions[0]);
        }

        @Override
        public boolean considers_order() {
            return true;
        }
    };


    private SegmentTfMerger() {
    }

    public abstract void calculate(Color4f var1, Color4f[] var2);

    public boolean considers_order() {
        return false;
    }

    /* synthetic */ SegmentTfMerger(String string, int n, SegmentTfMerger segmentTfMerger) {
        this();
    }
}

