/*
 * Decompiled with CFR 0.152.
 */
package raycaster.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.vecmath.Color4f;
import javax.vecmath.Tuple4f;
import main.Message;
import misc.messages.YObservable;
import raycaster.gui.StyleChooser;
import raycaster.gui.StyleImage;
import raycaster.gui.TransferFunctionPanel;
import raycaster.renderer.RenderMethod;
import raycaster.settings.ControlPoint;
import settings.Settings;

public final class GuiControlPoint
extends YObservable
implements Comparable<GuiControlPoint> {
    static final int M_CP_CHANGED = Message.register_message("GuiControlPoint Changed");
    private int _intensity;
    private float _opacity;
    private final Color4f _color;
    private StyleImage _style;

    public GuiControlPoint(int intensity, float opacity) {
        this._intensity = intensity;
        this._opacity = opacity;
        this._color = new Color4f(StyleChooser.get_default_color());
        this._style = StyleChooser.get_default_style();
    }

    public GuiControlPoint(int intensity, float opacity, RenderMethod.Style style_type, Color4f color, StyleImage style) {
        this(intensity, opacity);
        switch (style_type) {
            case COLOR: {
                this.set_color(color);
                break;
            }
            case IMAGE: {
                this.set_style(style);
                this.set_color(new Color4f(this.get_color_from_style()));
                break;
            }
        }
    }

    public GuiControlPoint(ControlPoint point) {
        this(point.get_intensity(), point.get_opacity());
        this.set_color(new Color4f(point.get_color()));
        try {
            StyleImage style = StyleImage.create(point.get_style_source());
            this.set_style(style);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void paint(Graphics2D g, RenderMethod render_method, boolean hovered) {
        int point_size = GuiControlPoint.get_point_size();
        int offset = -point_size / 2;
        float alpha = (float)g.getColor().getAlpha() / 255.0f;
        Color old_color = g.getColor();
        this.draw_interior(g, render_method, point_size, offset, alpha);
        this.drawBorder(g, hovered, point_size, offset, old_color);
    }

    private void draw_interior(Graphics2D g, RenderMethod render_method, int point_size, int offset, float alpha) {
        switch (render_method.get_style()) {
            case COLOR: {
                Color4f color = new Color4f();
                color.set((Tuple4f)this._color);
                color.setW(alpha);
                g.setColor(color.get());
                g.fillRect(offset, offset, point_size, point_size);
                break;
            }
            case IMAGE: {
                ImageIcon icon = this._style.get_small_icon();
                BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                Graphics2D image_graphics = image.createGraphics();
                image_graphics.drawImage(icon.getImage(), 0, 0, icon.getIconWidth(), icon.getIconHeight(), null);
                image_graphics.dispose();
                float[] scale_factors = new float[]{1.0f, 1.0f, 1.0f, alpha};
                float[] offsets = new float[4];
                RescaleOp rop = new RescaleOp(scale_factors, offsets, null);
                g.drawImage(image, rop, offset, offset);
                break;
            }
        }
    }

    private void drawBorder(Graphics2D g, boolean hovered, int point_size, int offset, Color border_color) {
        if (hovered) {
            g.setColor(new Color((border_color.getRed() + 127) % 255, (border_color.getGreen() + 127) % 255, (border_color.getBlue() + 127) % 255, border_color.getAlpha()));
        } else {
            g.setColor(border_color);
        }
        g.drawRect(offset - 1, offset - 1, point_size + 1, point_size + 1);
        g.setColor(border_color);
    }

    @Override
    public int compareTo(GuiControlPoint o) {
        return this._intensity - o._intensity;
    }

    public String toString() {
        return "[density: " + this._intensity + ", color: " + this._color + ", opacity: " + this._opacity + ", style: " + this._style.get_file_name() + "]";
    }

    public int get_intensity() {
        return this._intensity;
    }

    public void set_intensity(int intensity) {
        this._intensity = intensity;
        this.notifyObservers();
    }

    public float get_opacity() {
        return this._opacity;
    }

    public void set_opacity(float opacity) {
        this._opacity = opacity;
        this.notifyObservers();
    }

    public Color4f get_color() {
        return new Color4f(this._color);
    }

    public void set_color(Color4f color) {
        this._color.set((Tuple4f)color);
        this.notifyObservers();
    }

    public StyleImage get_style() {
        return this._style;
    }

    public void set_style(StyleImage style) {
        this._style = style;
        this.notifyObservers();
    }

    public Color get_color_from_style() {
        int width = this._style.get_image().getWidth();
        int height = this._style.get_image().getHeight();
        return new Color(this._style.get_image().getRGB(width / 2, height / 2));
    }

    @Override
    public void notifyObservers() {
        this.setChanged();
        super.notifyObservers(new Message(M_CP_CHANGED));
    }

    public ControlPoint get_settings() {
        ControlPoint point = new ControlPoint();
        point.set_color(this._color);
        point.set_intensity(this._intensity);
        point.set_opacity(this._opacity);
        point.set_style_source(this._style.get_absolute_path());
        return point;
    }

    public static int get_point_size() {
        return Settings.get_int_option(TransferFunctionPanel.class, TransferFunctionPanel.OPT_CONTROL_POINT_SIZE);
    }
}

