/*
 * Decompiled with CFR 0.152.
 */
package raycaster.gui;

import java.util.Iterator;
import java.util.NavigableSet;
import java.util.TreeSet;
import javax.vecmath.Color4f;
import javax.vecmath.Tuple4f;
import main.MasterControl;
import main.Message;
import misc.helper.Interpolation;
import misc.messages.YObservable;
import misc.messages.YObserver;
import raycaster.gui.GuiControlPoint;
import raycaster.gui.TransferFunctionTab;
import raycaster.renderer.RenderMethod;
import raycaster.settings.ControlPoint;
import raycaster.settings.TransferFunctionSetting;

public final class GuiTransferFunction
extends YObservable
implements YObserver,
Iterable<GuiControlPoint> {
    public static final int M_CLEAR = Message.register_message("GuiTransferFunction Clear");
    public static final int M_CP_ADD = Message.register_message("GuiTransferFunction CP Add");
    public static final int M_CP_REM = Message.register_message("GuiTransferFunction CP Del");
    public static final int M_CP_MOVE = Message.register_message("GuiTransferFunction CP Move");
    public static final int M_RENDER_METHOD_CHANGED = Message.register_message("GuiTransferFunction Render Method Changed");
    private final NavigableSet<GuiControlPoint> _points = new TreeSet<GuiControlPoint>();
    private RenderMethod _render_method;

    public GuiTransferFunction() {
        this._render_method = TransferFunctionTab.get_current_render_method();
    }

    public GuiTransferFunction(TransferFunctionSetting settings) {
        this._render_method = settings.get_render_method();
        for (ControlPoint point : settings.get_control_points()) {
            this.add(new GuiControlPoint(point));
        }
    }

    public void add(GuiControlPoint cp) {
        if (!this.intensityValueIsOccupied(cp)) {
            cp.addObserver(this, "GuiTransferFunction::add cp");
            this._points.add(cp);
            this.setChanged();
            this.notifyObservers(new Message(M_CP_ADD));
        }
    }

    public void remove(GuiControlPoint cp) {
        this._points.remove(cp);
        this.setChanged();
        this.notifyObservers(new Message(M_CP_REM));
    }

    public void move(GuiControlPoint cp, int intensity, float opacity) {
        this._points.remove(cp);
        int old_intensity = cp.get_intensity();
        cp.set_intensity(intensity);
        cp.set_opacity(opacity);
        if (this.intensityValueIsOccupied(cp)) {
            cp.set_intensity(old_intensity);
        }
        this._points.add(cp);
        this.setChanged();
        this.notifyObservers(new Message(M_CP_MOVE));
    }

    private boolean intensityValueIsOccupied(GuiControlPoint point) {
        for (GuiControlPoint compare_point : this) {
            if (compare_point.get_intensity() > point.get_intensity()) {
                return false;
            }
            if (compare_point == point || compare_point.get_intensity() != point.get_intensity()) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this._points.clear();
        this.setChanged();
        this.notifyObservers(new Message(M_CLEAR));
    }

    public void set_render_method(RenderMethod render_method) {
        this._render_method = render_method;
        this.setChanged();
        this.notifyObservers(new Message(M_RENDER_METHOD_CHANGED));
    }

    public RenderMethod get_render_method() {
        return this._render_method;
    }

    @Override
    public Iterator<GuiControlPoint> iterator() {
        return this._points.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (GuiControlPoint cp : this._points) {
            sb.append(cp + ",");
        }
        return sb.toString();
    }

    public int[] get_color_table() {
        int voxel_value_range = MasterControl.get_is().get_voxel_value_range();
        Color4f[] table = this.calculateColorTable(voxel_value_range);
        int[] colors = new int[voxel_value_range];
        int i = 0;
        while (i < colors.length) {
            colors[i] = table[i].get().getRGB();
            ++i;
        }
        return colors;
    }

    public Color4f[] calculateColorTable(int max_voxel_value) {
        Color4f[] ct = new Color4f[max_voxel_value + 1];
        int i = 0;
        while (i < ct.length) {
            ct[i] = new Color4f();
            ++i;
        }
        Iterator<GuiControlPoint> cp_it = this.iterator();
        if (cp_it.hasNext()) {
            Color4f prev_color = new Color4f();
            GuiControlPoint next = cp_it.next();
            Color4f next_color = this.get_color_for_control_point(next);
            next_color.w = next.get_opacity();
            ct[next.get_intensity()].set((Tuple4f)next_color);
            while (cp_it.hasNext()) {
                GuiControlPoint prev = next;
                prev_color.set((Tuple4f)next_color);
                next = cp_it.next();
                next_color.set((Tuple4f)this.get_color_for_control_point(next));
                next_color.w = next.get_opacity();
                int i2 = prev.get_intensity();
                while (i2 <= next.get_intensity()) {
                    float weight = Interpolation.linear(i2, prev.get_intensity(), next.get_intensity(), 0.0f, 1.0f);
                    ct[i2].interpolate((Tuple4f)prev_color, (Tuple4f)next_color, weight);
                    ++i2;
                }
            }
        }
        return ct;
    }

    private Color4f get_color_for_control_point(GuiControlPoint cp) {
        switch (this._render_method.get_style()) {
            case COLOR: {
                return cp.get_color();
            }
            case IMAGE: {
                return new Color4f(cp.get_color_from_style());
            }
        }
        return new Color4f();
    }

    public TransferFunctionSetting get_settings() {
        TransferFunctionSetting settings = new TransferFunctionSetting();
        settings.set_render_method(this._render_method);
        for (GuiControlPoint point : this._points) {
            settings.add_control_point(point.get_settings());
        }
        return settings;
    }

    @Override
    public void update(YObservable o, Message m) {
        this.setChanged();
        this.notifyObservers(m);
    }
}

