/*
 * Decompiled with CFR 0.152.
 */
package raycaster.gui;

import gui.JTFSliderDouble;
import java.text.NumberFormat;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.text.NumberFormatter;
import javax.vecmath.Vector3f;
import jgridmaker.GMPanel;
import main.tools.ToolRayCasting;
import misc.grid.gradients.GradientCachingMethod;
import misc.grid.gradients.GradientFunctionType;
import raycaster.settings.GradientSettings;
import raycaster.settings.LightingSettings;
import settings.Settings;

public final class LightingTab
extends GMPanel {
    private final JCheckBox _enable_box = new JCheckBox();
    private final JTFSliderDouble _ambient_slider;
    private final JTFSliderDouble _diffuse_slider;
    private final JTFSliderDouble _specular_slider;
    private final JFormattedTextField _specular_exponent;
    private final JFormattedTextField _dir_x;
    private final JFormattedTextField _dir_y;
    private final JFormattedTextField _dir_z;
    private final JComboBox _gradient_selector;

    public LightingTab() {
        this._enable_box.setSelected(true);
        this._ambient_slider = new JTFSliderDouble(0.0, 1.0, 0.0);
        this._diffuse_slider = new JTFSliderDouble(0.0, 1.0, 0.0);
        this._specular_slider = new JTFSliderDouble(0.0, 1.0, 0.0);
        NumberFormatter specular_exponent_formatter = new NumberFormatter(NumberFormat.getNumberInstance());
        specular_exponent_formatter.setMinimum(new Double(1.0));
        specular_exponent_formatter.setMaximum(new Double(500.0));
        this._specular_exponent = new JFormattedTextField(specular_exponent_formatter);
        this._specular_exponent.setColumns(6);
        NumberFormatter dir_formatter = new NumberFormatter(NumberFormat.getNumberInstance());
        dir_formatter.setMinimum(new Double(-1.7976931348623157E308));
        dir_formatter.setMaximum(new Double(Double.MAX_VALUE));
        this._dir_x = new JFormattedTextField(dir_formatter);
        this._dir_x.setColumns(6);
        this._dir_y = new JFormattedTextField(dir_formatter);
        this._dir_y.setColumns(6);
        this._dir_z = new JFormattedTextField(dir_formatter);
        this._dir_z.setColumns(6);
        this._gradient_selector = new JComboBox<GradientFunctionType>(GradientFunctionType.values());
        LightingSettings lighting_settings = new LightingSettings();
        if (this._enable_box.isSelected()) {
            lighting_settings.set_use_lighting(true);
        }
        this.set_lighting_settings(lighting_settings);
        JPanel dir_panel = new JPanel();
        dir_panel.add(this._dir_x);
        dir_panel.add(this._dir_y);
        dir_panel.add(this._dir_z);
        this.add("_enable_box", this._enable_box);
        this.add("_ambient_slider", this._ambient_slider);
        this.add("_diffuse_slider", this._diffuse_slider);
        this.add("_specular_slider", this._specular_slider);
        this.add("_specular_exponent", this._specular_exponent);
        this.add("_dir_x", this._dir_x);
        this.add("_dir_y", this._dir_y);
        this.add("_dir_z", this._dir_z);
        this.add("dir_panel", dir_panel);
        this.add("_gradient_selector", this._gradient_selector);
        this.set_layout("<table>  <tr>    <td anchor='east'>enable lighting</td>    <td anchor='west'>::_enable_box::</td>  </tr><tr>    <td anchor='east'>ambient coefficient</td>    <td anchor='west'>::_ambient_slider::</td>  </tr><tr>    <td anchor='east'>diffuse coefficient</td>    <td anchor='west'>::_diffuse_slider::</td>    <td anchor='east'></td>    <td anchor='west'></td>  </tr><tr>    <td anchor='east'>specular coefficient</td>    <td anchor='west'>::_specular_slider::</td>  </tr><tr>    <td anchor='east'>specular exponent</td>    <td anchor='west'>::_specular_exponent::</td>  </tr><tr>    <td anchor='east'>gradient function</td>    <td anchor='west'>::_gradient_selector::</td>  </tr></table>");
    }

    public LightingSettings get_lighting_settings() {
        float ambient = (float)this._ambient_slider.getValue();
        float diffuse = (float)this._diffuse_slider.getValue();
        float specular = (float)this._specular_slider.getValue();
        LightingSettings settings = new LightingSettings();
        settings.set_use_lighting(this._enable_box.isSelected());
        settings.set_ambient(ambient);
        settings.set_diffuse(diffuse);
        settings.set_specular(specular);
        settings.set_specular_exponent(((Double)this._specular_exponent.getValue()).floatValue());
        settings.set_light_direction(new Vector3f(((Double)this._dir_x.getValue()).floatValue(), ((Double)this._dir_y.getValue()).floatValue(), ((Double)this._dir_z.getValue()).floatValue()));
        settings.set_gradient_settings(new GradientSettings((GradientFunctionType)((Object)this._gradient_selector.getSelectedItem()), (GradientCachingMethod)Settings.get_enum_option(ToolRayCasting.class, ToolRayCasting.OPT_GRADIENT_CACHING)));
        return settings;
    }

    public void set_lighting_settings(LightingSettings lighting_settings) {
        this._enable_box.setSelected(lighting_settings.get_use_lighting());
        this._ambient_slider.setValue(lighting_settings.get_ambient());
        this._diffuse_slider.setValue(lighting_settings.get_diffuse());
        this._specular_slider.setValue(lighting_settings.get_specular());
        this._specular_exponent.setValue(new Double(lighting_settings.get_specular_exponent()));
        Vector3f light_dir = lighting_settings.get_light_direction();
        this._dir_x.setValue(new Double(light_dir.x));
        this._dir_y.setValue(new Double(light_dir.y));
        this._dir_z.setValue(new Double(light_dir.z));
        this._gradient_selector.setSelectedItem((Object)lighting_settings.get_gradient_settings().get_type());
        GradientSettings gradient_settings = lighting_settings.get_gradient_settings();
        Settings.set_class_enum_option(ToolRayCasting.class, ToolRayCasting.OPT_GRADIENT_CACHING, gradient_settings.get_caching_method());
    }
}

