/*
 * Decompiled with CFR 0.152.
 */
package raycaster.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.text.NumberFormatter;
import jgridmaker.GMPanel;
import main.Message;
import main.tools.ToolRayCasting;
import misc.grid.filter.FilterType;
import raycaster.gui.TransferFunctionTab;
import raycaster.settings.FilterSettings;
import settings.JBoolOptionCheckbox;
import settings.JDoubleOptionTFSlider;
import settings.JDoubleOptionTextfield;
import settings.JEnumOptionComboBox;

public final class RenderOptionTab
extends GMPanel {
    public static final int M_SEGMENT_TF_MERGER_CHANGED = Message.register_message("SEGMENT TF MERGER changed");
    private final JDoubleOptionTFSlider _jtf_sampling_rate;
    private final JDoubleOptionTextfield _jdtf_early_term;
    private final JBoolOptionCheckbox _jboc_use_octree;
    private final JComboBox _filter_selector;
    private final JFormattedTextField _cubic_b;
    private final JFormattedTextField _cubic_c;
    private final JEnumOptionComboBox _merge_mode_selector;
    private final JBoolOptionCheckbox _jboc_use_transparency;

    RenderOptionTab(ToolRayCasting tool_instance) {
        this._jtf_sampling_rate = new JDoubleOptionTFSlider(tool_instance, ToolRayCasting.OPT_SAMPLING_RATE, 0.5, 10.0);
        this._jdtf_early_term = new JDoubleOptionTextfield(tool_instance, ToolRayCasting.OPT_RAY_TERM, 8);
        this._jboc_use_octree = new JBoolOptionCheckbox(tool_instance, ToolRayCasting.OPT_USE_OCTREE);
        this._filter_selector = new JComboBox<FilterType>(FilterType.values());
        this._filter_selector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterType type = (FilterType)((Object)RenderOptionTab.this._filter_selector.getSelectedItem());
                if (type == FilterType.CUBIC) {
                    RenderOptionTab.this.enable_number_fields();
                } else {
                    RenderOptionTab.this.disable_number_fields();
                }
            }
        });
        NumberFormatter number_formatter = new NumberFormatter(NumberFormat.getNumberInstance());
        number_formatter.setMinimum(new Double(-1.7976931348623157E308));
        number_formatter.setMaximum(new Double(Double.MAX_VALUE));
        this._cubic_b = new JFormattedTextField(number_formatter);
        this._cubic_c = new JFormattedTextField(number_formatter);
        this._cubic_b.setColumns(6);
        this._cubic_c.setColumns(6);
        this.set_number_field_values(0.4, 0.3);
        this.disable_number_fields();
        this._merge_mode_selector = new JEnumOptionComboBox(TransferFunctionTab.class, TransferFunctionTab.OPT_SEGMENT_TF_MERGE_MODE);
        this._jboc_use_transparency = new JBoolOptionCheckbox(TransferFunctionTab.class, TransferFunctionTab.OPT_USE_TRANSPARENCY);
        JBoolOptionCheckbox accurate_segment_surface_detection = new JBoolOptionCheckbox(TransferFunctionTab.class, TransferFunctionTab.OPT_USE_ACCURATE_SURFACE_DETECTION);
        this.add("_jtf_sampling_rate", this._jtf_sampling_rate);
        this.add("_jdtf_early_term", this._jdtf_early_term);
        this.add("_jboc_use_octree", this._jboc_use_octree);
        this.add("_filter_selector", this._filter_selector);
        this.add("_cubic_b", this._cubic_b);
        this.add("_cubic_c", this._cubic_c);
        this.add("_merge_mode_selector", this._merge_mode_selector);
        this.add("accurate_segment_surface_detection", accurate_segment_surface_detection);
        this.add("_jboc_use_transparency", this._jboc_use_transparency);
        this.set_layout("<table anchor='west' border='0'>  <tr>    <td anchor='east'>sampling rate:</td>    <td anchor='west' colspan='3'>::_jtf_sampling_rate::</td>  </tr><tr>    <td anchor='east'>empty space skipping:</td>    <td anchor='west'>::_jboc_use_octree::</td>  </tr><tr>    <td anchor='east'>ray term epsilon</td>    <td anchor='west'>::_jdtf_early_term::</td>  </tr><tr>    <td anchor='east'>filter</td>    <td anchor='west'>::_filter_selector::</td>    <td anchor='west'>::_cubic_b::</td>    <td anchor='west'>::_cubic_c::</td>  </tr><tr>    <td anchor='east'>Segment Merge Mode:</td>    <td anchor='west'>::_merge_mode_selector::</td>  </tr><tr>    <td anchor='west' colspan='2'>::accurate_segment_surface_detection::</td>  </tr><tr>    <td anchor='west' colspan='2'>::_jboc_use_transparency::</td>  </tr></table>");
    }

    private void disable_number_fields() {
        this.set_number_fields_enabled(false);
    }

    private void set_number_fields_enabled(boolean enabled) {
        this._cubic_b.setEnabled(enabled);
        this._cubic_c.setEnabled(enabled);
    }

    private void enable_number_fields() {
        this.set_number_fields_enabled(true);
    }

    private void set_number_field_values(double b, double c) {
        this._cubic_b.setValue(new Double(b));
        this._cubic_c.setValue(new Double(c));
    }

    public final FilterSettings get_filter_settings() {
        FilterType type = (FilterType)((Object)this._filter_selector.getSelectedItem());
        FilterSettings fs = new FilterSettings(type);
        if (type == FilterType.CUBIC) {
            float b = ((Double)this._cubic_b.getValue()).floatValue();
            float c = ((Double)this._cubic_c.getValue()).floatValue();
            fs.set_filter_options(new FilterSettings.CubicFilterSettings(b, c));
        }
        return fs;
    }

    public final void set_filter_settings(FilterSettings filter_settings) {
        FilterType type = filter_settings.get_filter_type();
        this._filter_selector.setSelectedItem(type.toString());
        if (type == FilterType.CUBIC) {
            FilterSettings.CubicFilterSettings filter_options = (FilterSettings.CubicFilterSettings)filter_settings.get_filter_options();
            float b = filter_options.get_b();
            float c = filter_options.get_c();
            this.set_number_field_values(b, c);
            this.enable_number_fields();
        } else {
            this.disable_number_fields();
        }
    }
}

