/*
 * Decompiled with CFR 0.152.
 */
package raycaster.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jgridmaker.JGridMaker;
import main.tools.ToolRayCasting;
import raycaster.settings.RenderSettings;
import settings.Settings;

public class RenderResultWindow
extends JFrame {
    private final BufferedImage _bimg;
    private final RenderSettings _settings;
    private final JPanel _jp_panel;
    final JTextField _jtp_file_name;
    final JCheckBox _jcb_save_settings;
    final JButton _jb_save;

    public RenderResultWindow(ToolRayCasting tool_instance, final BufferedImage bimg, String file_name_prefix, RenderSettings settings) {
        super("Render Results");
        this._bimg = bimg;
        this._settings = settings;
        boolean auto_safe = Settings.get_bool_option(tool_instance, ToolRayCasting.OPT_AUTO_SAVE);
        Dimension dim = new Dimension(Math.min(this._bimg.getWidth(), 800), Math.min(this._bimg.getHeight(), 800));
        this._jp_panel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(RenderResultWindow.this._bimg, 0, 0, this.getWidth(), this.getHeight(), null);
            }
        };
        this._jp_panel.setPreferredSize(dim);
        this._jp_panel.setMinimumSize(dim);
        this._jp_panel.setMaximumSize(dim);
        this._jp_panel.setBackground(Color.red);
        if (auto_safe) {
            this._jp_panel.setToolTipText(String.valueOf(file_name_prefix) + ".png");
        }
        this._jtp_file_name = new JTextField(file_name_prefix);
        this._jcb_save_settings = new JCheckBox();
        this._jcb_save_settings.setSelected(true);
        this._jcb_save_settings.setText("save settings");
        this._jb_save = new JButton("save to file");
        this._jb_save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String file = RenderResultWindow.this._jtp_file_name.getText();
                boolean save_settings = RenderResultWindow.this._jcb_save_settings.isSelected();
                ToolRayCasting.write_image(bimg, file);
                if (save_settings) {
                    ToolRayCasting.write_settings(RenderResultWindow.this._settings, 0L, file);
                }
            }
        });
        Dimension def_dim = new Dimension(800, 900);
        this.setMinimumSize(def_dim);
        this.setMaximumSize(def_dim);
        this.setPreferredSize(def_dim);
        HashMap<String, JComponent> obj_map = new HashMap<String, JComponent>();
        obj_map.put("_jp_panel", this._jp_panel);
        obj_map.put("_jtp_file_name", this._jtp_file_name);
        obj_map.put("_jcb_save_settings", this._jcb_save_settings);
        obj_map.put("_jb_save", this._jb_save);
        if (auto_safe) {
            JGridMaker.make_grid((Container)this, (String)"<table>  <tr>    <td colspan='2' fill='horizontal'>Render Result</td>  </tr><tr>    <td colspan='2' fill='horizontal'>::_jp_panel::</td>  </tr></table>", obj_map);
        } else {
            JGridMaker.make_grid((Container)this, (String)"<table>  <tr>    <td colspan='2' fill='horizontal'>Render Result</td>  </tr><tr>    <td colspan='2' fill='horizontal'>::_jp_panel::</td>  </tr><tr>    <td colspan='2' fill='horizontal'>::_jtp_file_name::</td>  </tr><tr>    <td anchor='east'>::_jb_save::</td>    <td anchor='west'>::_jcb_save_settings::</td>  </tr></table>", obj_map);
        }
        this.pack();
        this.setResizable(true);
        this.setVisible(true);
    }
}

