/*
 * Decompiled with CFR 0.152.
 */
package raycaster.gui;

import gui.SegSelector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import main.Segment;
import raycaster.gui.SegmentService;

public class SegSelectorUsingExternalModel
extends JPanel {
    private final JList _jl_seg_list;
    private final ListModel _seg_list_model;
    private final LinkedList<Segment> _selected_segs = new LinkedList();
    private JLabel _label = null;

    public SegSelectorUsingExternalModel(SegmentService segment_service) {
        this._seg_list_model = segment_service.get_segment_list_model();
        this._jl_seg_list = new JList(this._seg_list_model);
        this._jl_seg_list.setCellRenderer(new MyCellRenderer());
        this._jl_seg_list.setSelectionMode(0);
        this._jl_seg_list.setPrototypeCellValue(new Segment("Fingerknochen", 10, 10, 10));
        this._jl_seg_list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SegSelectorUsingExternalModel.this.check_for_changes()) {
                    SegSelectorUsingExternalModel.this.firePropertyChange(SegSelector.SEG_SELECTION_CHANGED, null, null);
                }
            }
        });
        JScrollPane jsp_list_scroller = new JScrollPane(this._jl_seg_list);
        jsp_list_scroller.setHorizontalScrollBarPolicy(31);
        jsp_list_scroller.setVerticalScrollBarPolicy(22);
        this.setLayout(new BorderLayout());
        this.add((Component)jsp_list_scroller, "Center");
    }

    public SegSelectorUsingExternalModel(SegmentService segment_service, String label) {
        this(segment_service);
        this._label = new JLabel(label, 0);
        this.add((Component)this._label, "North");
    }

    public LinkedList<Segment> get_selected_segments() {
        return this._selected_segs;
    }

    public Segment get_selected_segment() {
        return this._selected_segs.isEmpty() ? null : this._selected_segs.getFirst();
    }

    public void setSelectionMode(int mode) {
        this._jl_seg_list.setSelectionMode(mode);
    }

    public void setSelectedIndex(int index) {
        this._jl_seg_list.setSelectedIndex(index);
        this.check_for_changes();
    }

    public void setSelectedIndex(int[] indices) {
        this._jl_seg_list.setSelectedIndices(indices);
        this.check_for_changes();
    }

    public boolean check_for_changes() {
        boolean change = false;
        int i = 0;
        while (i < this._seg_list_model.getSize()) {
            Segment seg = (Segment)this._seg_list_model.getElementAt(i);
            if (this._jl_seg_list.isSelectedIndex(i)) {
                if (!this._selected_segs.contains(seg)) {
                    this._selected_segs.add(seg);
                    change = true;
                }
            } else if (this._selected_segs.contains(seg)) {
                this._selected_segs.remove(seg);
                change = true;
            }
            ++i;
        }
        return change;
    }

    final class MyCellRenderer
    extends JPanel
    implements ListCellRenderer {
        final JLabel _jl_text;
        final JPanel _jp_color_box;

        public MyCellRenderer() {
            this.setOpaque(true);
            this._jl_text = new JLabel("---");
            Dimension box_size = new Dimension(12, 12);
            this._jp_color_box = new JPanel();
            this._jp_color_box.setPreferredSize(box_size);
            this._jp_color_box.setMaximumSize(box_size);
            this._jp_color_box.setMinimumSize(box_size);
            this._jp_color_box.setOpaque(true);
            this._jp_color_box.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.black));
            JPanel jp_color_box_parent = new JPanel(new FlowLayout());
            jp_color_box_parent.setOpaque(false);
            jp_color_box_parent.add(this._jp_color_box);
            this.setLayout(new BorderLayout());
            this.add((Component)jp_color_box_parent, "West");
            this.add((Component)this._jl_text, "Center");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Segment) {
                Color def_fg;
                Color def_bg;
                Segment seg = (Segment)value;
                this._jl_text.setText(seg.get_name());
                this._jp_color_box.setBackground(new Color(seg.get_color()));
                if (isSelected) {
                    def_bg = list.getSelectionBackground();
                    def_fg = list.getSelectionForeground();
                } else {
                    def_bg = list.getBackground();
                    def_fg = list.getForeground();
                }
                Color bg = new Color(def_bg.getRed(), def_bg.getGreen(), def_bg.getBlue());
                Color fg = new Color(def_fg.getRed(), def_fg.getGreen(), def_fg.getBlue());
                this.setBackground(bg);
                this.setForeground(fg);
            }
            return this;
        }
    }
}

