/*
 * Decompiled with CFR 0.152.
 */
package raycaster.gui;

import gui.ColorBox;
import gui.SegSelector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.Segment;
import main.tools.ToolSegGen;
import misc.Assertions;
import misc.messages.YObservable;
import misc.messages.YObserverWantsAWTThread;
import raycaster.gui.SegmentService;

public final class SegSelectorWithAllVoxelsSegment
extends JPanel
implements YObserverWantsAWTThread {
    private static final int COLOR_COLUMN = 0;
    private static final int SEGMENT_COLUMN = 1;
    private static final int UP_BUTTON_COLUMN = 2;
    private static final int DOWN_BUTTON_COLUMN = 3;
    private static final int ACTIVATOR_COLUMN = 4;
    private static final UpButtonRenderData upButtonRenderData = new UpButtonRenderData();
    private static final DownButtonRenderData downButtonRenderData = new DownButtonRenderData();
    private final SegmentService _segment_service;
    private final DefaultTableModel _model = new DefaultTableModel(new Object[0][5], new Object[5]){

        @Override
        public boolean isCellEditable(int row, int column) {
            if (row == 0 || column == 0 || column == 1) {
                return false;
            }
            if (this.is_down_button_in_last_row(row, column)) {
                return false;
            }
            return !this.is_up_button_in_second_row(row, column);
        }

        private boolean is_down_button_in_last_row(int row, int column) {
            return column == 3 && row == SegSelectorWithAllVoxelsSegment.this._model.getRowCount() - 1;
        }

        private boolean is_up_button_in_second_row(int row, int column) {
            return column == 2 && row == 1;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Color.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return UpButtonRenderData.class;
                }
                case 3: {
                    return DownButtonRenderData.class;
                }
                case 4: {
                    return Boolean.class;
                }
            }
            throw new Assertions.ShouldNotReachHereException();
        }
    };
    private final JTable _segment_table = new JTable(this._model);

    public SegSelectorWithAllVoxelsSegment(SegmentService segment_service) {
        this._segment_service = segment_service;
        for (Segment segment : this._segment_service.get_segment_list()) {
            this.add_segment(segment);
        }
        this._segment_table.setDefaultRenderer(Color.class, new ColorBox());
        ImageIcon up_icon = new ImageIcon("resources/gfx/arrow_up.png");
        this._segment_table.setDefaultRenderer(UpButtonRenderData.class, new IconButtonRenderer(up_icon));
        ImageIcon down_icon = new ImageIcon("resources/gfx/arrow_down.png");
        this._segment_table.setDefaultRenderer(DownButtonRenderData.class, new IconButtonRenderer(down_icon));
        this._segment_table.setDefaultEditor(UpButtonRenderData.class, new UpButtonEditor());
        this._segment_table.setDefaultEditor(DownButtonRenderData.class, new DownButtonEditor());
        this.set_widht_for_column(0, 20);
        this.set_widht_for_column(1, 120);
        this.set_widht_for_column(2, 24);
        this.set_widht_for_column(3, 24);
        this.set_widht_for_column(4, 20);
        this._segment_table.setRowHeight(24);
        this._segment_table.getTableHeader().setResizingAllowed(false);
        this._segment_table.setPreferredScrollableViewportSize(this._segment_table.getPreferredSize());
        this._segment_table.setTableHeader(null);
        JScrollPane scroll_pane = new JScrollPane(this._segment_table);
        scroll_pane.setVerticalScrollBarPolicy(22);
        scroll_pane.setHorizontalScrollBarPolicy(31);
        this.setLayout(new BorderLayout());
        this.add((Component)scroll_pane, "Center");
        scroll_pane.revalidate();
        MasterControl.get_is().addObserver(this, "SegSelectorWithAllVoxelsSegment()");
        this._model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent event) {
                SegSelectorWithAllVoxelsSegment.this.repaint();
                if (event.getColumn() == 4) {
                    int row = event.getFirstRow();
                    Segment segment = SegSelectorWithAllVoxelsSegment.this.get_segment_for_row(row);
                    boolean active = (Boolean)SegSelectorWithAllVoxelsSegment.this._model.getValueAt(row, 4);
                    SegSelectorWithAllVoxelsSegment.this._segment_service.set_active(segment, active);
                }
            }
        });
        this._segment_table.getSelectionModel().setSelectionInterval(0, 0);
        this._segment_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SegSelectorWithAllVoxelsSegment.this.firePropertyChange(SegSelector.SEG_SELECTION_CHANGED, -1, e.getFirstIndex());
            }
        });
    }

    private void set_widht_for_column(int column, int width) {
        TableColumnModel table_column_model = this._segment_table.getColumnModel();
        TableColumn table_column = table_column_model.getColumn(column);
        table_column.setMinWidth(width);
        table_column.setPreferredWidth(width);
        table_column.setMaxWidth(width);
    }

    private void add_segment(Segment segment) {
        JCheckBox enable_box = new JCheckBox("Enabled", true);
        enable_box.setEnabled(false);
        enable_box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Segment selected_segment = SegSelectorWithAllVoxelsSegment.this.get_selected_segment();
                boolean is_active = ((JCheckBox)e.getSource()).isSelected();
                SegSelectorWithAllVoxelsSegment.this._segment_service.set_active(selected_segment, is_active);
            }
        });
        Object[] row = new Object[]{new Color(segment.get_color()), segment.get_name(), upButtonRenderData, downButtonRenderData, this._segment_service.is_active(segment)};
        this._model.addRow(row);
    }

    public Segment get_selected_segment() {
        int selected_row = this._segment_table.getSelectedRow();
        if (selected_row == -1) {
            throw new Assertions.ShouldNotReachHereException();
        }
        return this.get_segment_for_row(selected_row);
    }

    private Segment get_segment_for_row(int selected_row) {
        String segment_name = (String)this._model.getValueAt(selected_row, 1);
        return this._segment_service.get_segment_by_name(segment_name);
    }

    @Override
    public final void update(YObservable o, Message m) {
        if (m._type == ImageStack.M_CLEAR || m._type == ImageStack.M_LOADING_START) {
            this.clear_model();
            this.add_segment(SegmentService.ALL_VOXELS_SEGMENT);
        } else if (m._type == ImageStack.M_NEW_SEGMENT) {
            Segment segment = (Segment)m._obj;
            if (segment.get_name() != ToolSegGen.TMP_SEG_NAME) {
                this.add_segment(segment);
            }
        } else if (m._type == ImageStack.M_DEL_SEGMENT) {
            Segment segment = (Segment)m._obj;
            int row = 0;
            while (row < this._model.getRowCount()) {
                String current_segment_name = (String)this._model.getValueAt(row, 1);
                if (current_segment_name.equals(segment.get_name())) {
                    this._model.removeRow(row);
                }
                ++row;
            }
        } else if (m._type == Segment.M_SEG_NAME_CHANGED) {
            this.repaint();
        } else if (m._type == Segment.M_SEG_COL_CHANGED) {
            this.repaint();
        }
    }

    private void clear_model() {
        while (this._model.getRowCount() > 0) {
            this._model.removeRow(0);
        }
    }

    private abstract class ButtonEditor
    extends DefaultCellEditor {
        protected JButton button;
        private boolean isPushed;
        private Integer _row;

        public ButtonEditor() {
            super(new JCheckBox());
            this._row = 0;
            this.button = new JButton();
            this.button.setOpaque(true);
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ButtonEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (isSelected) {
                this.button.setForeground(table.getSelectionForeground());
                this.button.setBackground(table.getSelectionBackground());
            } else {
                this.button.setForeground(table.getForeground());
                this.button.setBackground(table.getBackground());
            }
            this.isPushed = true;
            this._row = row;
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.isPushed) {
                this.perform_action(this._row);
            }
            this.isPushed = false;
            this._row = null;
            return "";
        }

        protected abstract void perform_action(int var1);

        @Override
        public boolean stopCellEditing() {
            this.isPushed = false;
            this._row = null;
            return super.stopCellEditing();
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }
    }

    private class DownButtonEditor
    extends ButtonEditor {
        private DownButtonEditor() {
        }

        @Override
        protected void perform_action(int row) {
            if (row < SegSelectorWithAllVoxelsSegment.this._model.getRowCount() - 1) {
                Segment segment = SegSelectorWithAllVoxelsSegment.this.get_segment_for_row(row);
                SegSelectorWithAllVoxelsSegment.this._segment_service.move_segment_down(segment);
                SegSelectorWithAllVoxelsSegment.this._model.moveRow(row, row, row + 1);
            }
        }
    }

    private static final class DownButtonRenderData {
        private DownButtonRenderData() {
        }
    }

    private final class IconButtonRenderer
    implements TableCellRenderer {
        private final Icon _icon;

        public IconButtonRenderer(Icon icon) {
            this._icon = icon;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JButton button = new JButton(this._icon);
            if (isSelected) {
                button.setForeground(table.getSelectionForeground());
                button.setBackground(table.getSelectionBackground());
            } else {
                button.setForeground(table.getForeground());
                button.setBackground(UIManager.getColor("Button.background"));
            }
            boolean isUsable = SegSelectorWithAllVoxelsSegment.this._model.isCellEditable(row, column);
            button.setEnabled(isUsable);
            return button;
        }
    }

    private class UpButtonEditor
    extends ButtonEditor {
        private UpButtonEditor() {
        }

        @Override
        protected void perform_action(int row) {
            if (row > 1) {
                Segment segment = SegSelectorWithAllVoxelsSegment.this.get_segment_for_row(row);
                SegSelectorWithAllVoxelsSegment.this._segment_service.move_segment_up(segment);
                SegSelectorWithAllVoxelsSegment.this._model.moveRow(row, row, row - 1);
            }
        }
    }

    private static final class UpButtonRenderData {
        private UpButtonRenderData() {
        }
    }
}

