/*
 * Decompiled with CFR 0.152.
 */
package raycaster.gui;

import gui.JColorChooseButton;
import gui.JTFSliderDouble;
import gui.SegSelector;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import jgridmaker.GMPanel;
import main.Segment;
import raycaster.SegmentNormalMerger;
import raycaster.gui.SegSelectorUsingExternalModel;
import raycaster.gui.SegmentService;
import raycaster.gui.TransferFunctionTab;
import raycaster.renderer.RenderMethod;
import settings.JColorOption;
import settings.JDoubleOptionTFSlider;
import settings.JEnumOptionComboBox;
import settings.Settings;
import settings.SettingsListener;

public class SegmentOptionTab
extends GMPanel
implements SettingsListener {
    private final SegmentService _segment_service;
    private final SegSelectorUsingExternalModel _segment_selector;
    private final JTFSliderDouble _surface_opacity_slider;
    private final JCheckBox _surface_rendering_checkbox;
    private final JCheckBox _show_backplane_checkbox;
    private final JEnumOptionComboBox _segment_normal_merge_mode_selector;
    private final JDoubleOptionTFSlider _contour_thickness;
    private final JColorOption _contour_color;

    SegmentOptionTab(SegmentService segment_service) {
        this._segment_service = segment_service;
        this._surface_rendering_checkbox = new JCheckBox();
        this._surface_rendering_checkbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean surface_rendering = e.getStateChange() == 1;
                Segment selected_segment = SegmentOptionTab.this._segment_selector.get_selected_segment();
                SegmentOptionTab.this._segment_service.set_surface_rendering(selected_segment, surface_rendering);
            }
        });
        this._show_backplane_checkbox = new JCheckBox();
        this._show_backplane_checkbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean show_backplane = e.getStateChange() == 1;
                Segment selected_segment = SegmentOptionTab.this._segment_selector.get_selected_segment();
                SegmentOptionTab.this._segment_service.set_show_backplane(selected_segment, show_backplane);
            }
        });
        this._segment_selector = new SegSelectorUsingExternalModel(this._segment_service);
        this._segment_selector.addPropertyChangeListener(SegSelector.SEG_SELECTION_CHANGED, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                this.set_component_values();
                Segment selected_segment = SegmentOptionTab.this._segment_selector.get_selected_segment();
                if (selected_segment == null) {
                    SegmentOptionTab.this.disable_all_components();
                } else if (selected_segment == SegmentService.ALL_VOXELS_SEGMENT) {
                    SegmentOptionTab.this.enable_contour_options();
                    SegmentOptionTab.this.disable_non_contour_components();
                } else {
                    SegmentOptionTab.this.enable_all_components();
                }
            }

            private void set_component_values() {
                Segment selected_segment = SegmentOptionTab.this._segment_selector.get_selected_segment();
                if (selected_segment != null) {
                    SegmentOptionTab.this._surface_opacity_slider.setValue(SegmentOptionTab.this._segment_service.get_surface_opacity(selected_segment));
                    SegmentOptionTab.this._surface_rendering_checkbox.setSelected(SegmentOptionTab.this._segment_service.is_surface_rendering(selected_segment));
                    SegmentOptionTab.this._show_backplane_checkbox.setSelected(SegmentOptionTab.this._segment_service.is_show_backplane(selected_segment));
                    Settings.set_class_enum_option(TransferFunctionTab.class, TransferFunctionTab.OPT_SEGMENT_NORMAL_MERGE_MODE, SegmentOptionTab.this._segment_service.get_segment_normal_merger(selected_segment));
                    Settings.set_class_color_option(TransferFunctionTab.class, TransferFunctionTab.OPT_CONTOUR_COLOR, SegmentOptionTab.this._segment_service.get_contour_color(selected_segment));
                    Settings.set_class_double_option(TransferFunctionTab.class, TransferFunctionTab.OPT_CONTOUR_THICKNESS, Double.valueOf(SegmentOptionTab.this._segment_service.get_contour_thickness(selected_segment)));
                }
            }
        });
        this._surface_opacity_slider = new JTFSliderDouble(0.0, 1.0, 0.0);
        this._surface_opacity_slider.addPropertyChangeListener(JTFSliderDouble.JTF_CHANGE, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Segment selected_segment = SegmentOptionTab.this._segment_selector.get_selected_segment();
                float opacity = ((Double)evt.getNewValue()).floatValue();
                SegmentOptionTab.this._segment_service.set_surface_opacity(selected_segment, opacity);
            }
        });
        this._segment_normal_merge_mode_selector = new JEnumOptionComboBox(TransferFunctionTab.class, TransferFunctionTab.OPT_SEGMENT_NORMAL_MERGE_MODE);
        this._contour_thickness = new JDoubleOptionTFSlider(TransferFunctionTab.class, TransferFunctionTab.OPT_CONTOUR_THICKNESS, 0.0, 10.0);
        this._contour_thickness.setSize(200, 30);
        this._contour_thickness.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == JTFSliderDouble.JTF_CHANGE) {
                    Segment segment = SegmentOptionTab.this._segment_selector.get_selected_segment();
                    float value = ((Double)evt.getNewValue()).floatValue();
                    SegmentOptionTab.this._segment_service.set_contour_thickness(segment, value);
                }
            }
        });
        this._contour_color = new JColorOption(TransferFunctionTab.class, TransferFunctionTab.OPT_CONTOUR_COLOR);
        this._contour_color.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == JColorChooseButton.COLOR_CHANGE) {
                    Segment segment = SegmentOptionTab.this._segment_selector.get_selected_segment();
                    SegmentOptionTab.this._segment_service.set_contour_color(segment, (Color)evt.getNewValue());
                }
            }
        });
        this.disable_all_components();
        this.add("_segment_selector", this._segment_selector);
        this.add("_surface_opacity_slider", this._surface_opacity_slider);
        this.add("_segment_normal_merge_mode_selector", this._segment_normal_merge_mode_selector);
        this.add("_surface_rendering_checkbox", this._surface_rendering_checkbox);
        this.add("_show_backplane_checkbox", this._show_backplane_checkbox);
        this.add("_contour_thickness", this._contour_thickness);
        this.add("_contour_color", this._contour_color);
        this.set_layout("<table width='100%' height='100%'>  <tr>    <td fill='both'>::_segment_selector::</td>    <td>      <table>        <tr>          <td anchor='east'>Seg Normal Merge:</td>          <td anchor='west'>::_segment_normal_merge_mode_selector::</td>        </tr><tr>          <td anchor='east'>Surface opacity:</td>          <td anchor='west'>::_surface_opacity_slider::</td>        </tr><tr>          <td anchor='east'>Render surface only</td>          <td anchor='west'>::_surface_rendering_checkbox::</td>        </tr><tr>          <td anchor='east'>Show segment backplane</td>          <td anchor='west'>::_show_backplane_checkbox::</td>        </tr><tr>          <td anchor='east'>Contour size</td>          <td anchor='west'>::_contour_thickness::</td>        </tr><tr>          <td anchor='east'>Contour color</td>          <td anchor='west' colspan='2'>::_contour_color::</td>        </tr>      </table>    </td>  </tr></table>");
        Settings.register_class_listener(TransferFunctionTab.class, this);
    }

    private void disable_all_components() {
        this.disable_non_contour_components();
        this.disable_contour_options();
    }

    private void enable_all_components() {
        this.enable_non_contour_components();
        this.enable_contour_options();
    }

    private void disable_non_contour_components() {
        this.set_components_enabled(false);
    }

    private void enable_non_contour_components() {
        this.set_components_enabled(true);
    }

    private void set_components_enabled(boolean value) {
        this._surface_opacity_slider.setEnabled(value);
        this._surface_rendering_checkbox.setEnabled(value);
        this._show_backplane_checkbox.setEnabled(value);
        this._segment_normal_merge_mode_selector.setEnabled(value);
    }

    private void enable_contour_options() {
        this.set_contour_options_enabled(true);
    }

    private void disable_contour_options() {
        this.set_contour_options_enabled(false);
    }

    private void set_contour_options_enabled(boolean value) {
        this._contour_color.setEnabled(value);
        this._contour_thickness.setEnabled(value);
    }

    @Override
    public void settings_changed(Object obj, String optName, Object opt) {
        if (optName == TransferFunctionTab.OPT_SEGMENT_NORMAL_MERGE_MODE) {
            Segment segment = this._segment_selector.get_selected_segment();
            if (segment != null) {
                this._segment_service.set_segment_normal_merger(segment, (SegmentNormalMerger)((Object)opt));
            }
        } else if (optName == TransferFunctionTab.OPT_RENDER_METHOD) {
            if (opt == RenderMethod.LSM_CURVATURE_CONTOURS) {
                this.enable_contour_options();
                this._contour_thickness.setMaximum(10.0);
            } else if (opt == RenderMethod.LSM_DOT_PRODUCT_CONTOURS) {
                this.enable_contour_options();
                this._contour_thickness.setMaximum(1.0);
            } else {
                this.disable_contour_options();
            }
        } else if (optName == TransferFunctionTab.OPT_CONTOUR_COLOR) {
            Segment segment = this._segment_selector.get_selected_segment();
            this._segment_service.set_contour_color(segment, (Color)opt);
        } else if (optName == TransferFunctionTab.OPT_CONTOUR_THICKNESS) {
            Segment segment = this._segment_selector.get_selected_segment();
            float value = ((Double)opt).floatValue();
            this._segment_service.set_contour_thickness(segment, value);
        }
    }
}

