/*
 * Decompiled with CFR 0.152.
 */
package raycaster.gui;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.Segment;
import main.tools.ToolSegGen;
import misc.messages.YObservable;
import misc.messages.YObserver;
import raycaster.SegmentNormalMerger;

public final class SegmentService
extends YObservable
implements YObserver {
    public static final int M_SEGMENT_ACTIVATION_CHANGED = Message.register_message("Segment's activation state changed");
    public static final int M_SEGMENT_STATE_CHANGED = Message.register_message("Segment state changed");
    public static final int M_SEGMENT_POSITION_CHANGED = Message.register_message("Segment position changed");
    public static final Segment ALL_VOXELS_SEGMENT = SegmentService.create_all_voxels_segment();
    private final Map<Segment, SegmentState> _segment_states = new HashMap<Segment, SegmentState>();
    private final SegmentListModel _segment_list_model = new SegmentListModel();

    private static Segment create_all_voxels_segment() {
        Segment segment = new Segment("All Voxels", 0, 0, 0);
        segment.set_color(Color.BLACK.getRGB());
        return segment;
    }

    SegmentService() {
        this.clear_segments();
        ImageStack is = MasterControl.get_is();
        for (Segment segment : is.get_seg_map().values()) {
            if (segment.get_name().equals(ToolSegGen.TMP_SEG_NAME)) continue;
            this.add_segment(segment);
        }
        MasterControl.get_is().addObserver(this, "SegmentService()");
    }

    private SegmentState get_segment_state(Segment segment) {
        SegmentState state = this._segment_states.get(segment);
        if (state == null) {
            throw new NullPointerException("Segment '" + segment + "' not found");
        }
        return state;
    }

    public boolean is_active(Segment segment) {
        SegmentState state = this.get_segment_state(segment);
        return state.is_active();
    }

    public void set_active(Segment segment, boolean active) {
        SegmentState state = this.get_segment_state(segment);
        state.set_active(active);
        this.setChanged();
        this.notifyObservers(new Message(M_SEGMENT_ACTIVATION_CHANGED, segment));
    }

    private void notify_observers_for_segment_state(Segment segment) {
        this.setChanged();
        Message message = new Message(M_SEGMENT_STATE_CHANGED, segment);
        this.notifyObservers(message);
    }

    public SegmentNormalMerger get_segment_normal_merger(Segment segment) {
        SegmentState state = this.get_segment_state(segment);
        return state.get_normal_merger();
    }

    public void set_segment_normal_merger(Segment segment, SegmentNormalMerger merger) {
        SegmentState state = this.get_segment_state(segment);
        state.set_normal_merger(merger);
        this.notify_observers_for_segment_state(segment);
    }

    public void set_surface_opacity(Segment segment, float opacity) {
        SegmentState state = this.get_segment_state(segment);
        state.set_surface_opacity(opacity);
        this.notify_observers_for_segment_state(segment);
    }

    public float get_surface_opacity(Segment segment) {
        SegmentState state = this.get_segment_state(segment);
        return state.get_surface_opacity();
    }

    public void set_surface_rendering(Segment segment, boolean surface_rendering) {
        SegmentState state = this.get_segment_state(segment);
        state.set_surface_rendering(surface_rendering);
        this.notify_observers_for_segment_state(segment);
    }

    public void set_show_backplane(Segment segment, boolean show_backplane) {
        SegmentState state = this.get_segment_state(segment);
        state.set_show_backplane(show_backplane);
        this.notify_observers_for_segment_state(segment);
    }

    public boolean is_surface_rendering(Segment segment) {
        SegmentState state = this.get_segment_state(segment);
        return state.is_surface_rendering();
    }

    public boolean is_show_backplane(Segment segment) {
        SegmentState state = this.get_segment_state(segment);
        return state.is_show_backplane();
    }

    public Color get_contour_color(Segment segment) {
        SegmentState state = this.get_segment_state(segment);
        return state.get_contour_color();
    }

    public void set_contour_color(Segment segment, Color contour_color) {
        SegmentState state = this.get_segment_state(segment);
        state.set_contour_color(contour_color);
    }

    public float get_contour_thickness(Segment segment) {
        SegmentState state = this.get_segment_state(segment);
        return state.get_contour_size();
    }

    public void set_contour_thickness(Segment segment, float contour_size) {
        SegmentState state = this.get_segment_state(segment);
        state.set_contour_size(contour_size);
    }

    public List<Segment> get_segment_list() {
        ArrayList<Segment> segment_list = new ArrayList<Segment>();
        for (Segment segment : this._segment_list_model) {
            SegmentState state = this.get_segment_state(segment);
            if (!state.is_active()) continue;
            segment_list.add(segment);
        }
        return segment_list;
    }

    public ListModel get_segment_list_model() {
        return this._segment_list_model;
    }

    @Override
    public void update(YObservable observable, Message message) {
        if (message._type == ImageStack.M_CLEAR || message._type == ImageStack.M_LOADING_START) {
            this.clear_segments();
        } else if (message._type == ImageStack.M_NEW_SEGMENT) {
            Segment segment = (Segment)message._obj;
            if (segment.get_name() != ToolSegGen.TMP_SEG_NAME) {
                this.add_segment(segment);
            }
        } else if (message._type == ImageStack.M_DEL_SEGMENT) {
            Segment segment = (Segment)message._obj;
            this.remove_segment(segment);
        } else if (message._type == Segment.M_SEG_NAME_CHANGED || message._type == Segment.M_SEG_COL_CHANGED) {
            this._segment_list_model.notify_list_data_listeners(new ListDataEvent(this._segment_list_model, 0, 0, this._segment_list_model.getSize()));
        }
    }

    private void add_segment(Segment segment) {
        this._segment_list_model.add(segment);
        this._segment_states.put(segment, new SegmentState());
    }

    private void clear_segments() {
        this._segment_states.clear();
        this._segment_list_model.clear();
        this.add_segment(ALL_VOXELS_SEGMENT);
    }

    private void remove_segment(Segment segment) {
        this._segment_states.remove(segment);
        this._segment_list_model.remove(segment);
    }

    public void move_segment_up(Segment segment) {
        this._segment_list_model.move_segment_up(segment);
        this.notify_observers_for_segment_position();
    }

    private void notify_observers_for_segment_position() {
        this.setChanged();
        Message m = new Message(M_SEGMENT_POSITION_CHANGED);
        this.notifyObservers(m);
    }

    public void move_segment_down(Segment segment) {
        this._segment_list_model.move_segment_down(segment);
        this.notify_observers_for_segment_position();
    }

    public Segment get_segment_by_name(String name) {
        for (Segment segment : this._segment_list_model) {
            if (!segment.get_name().equals(name)) continue;
            return segment;
        }
        return null;
    }

    private final class SegmentListModel
    implements ListModel,
    Iterable<Segment> {
        private final List<Segment> _segment_list = new ArrayList<Segment>();
        private final Set<ListDataListener> _data_listeners = new HashSet<ListDataListener>();

        private SegmentListModel() {
        }

        @Override
        public void addListDataListener(ListDataListener listener) {
            this._data_listeners.add(listener);
        }

        public Object getElementAt(int index) {
            return this._segment_list.get(index);
        }

        @Override
        public int getSize() {
            return this._segment_list.size();
        }

        @Override
        public void removeListDataListener(ListDataListener listener) {
            this._data_listeners.remove(listener);
        }

        public void notify_list_data_listeners(ListDataEvent event) {
            for (ListDataListener listener : this._data_listeners) {
                listener.contentsChanged(event);
            }
        }

        @Override
        public Iterator<Segment> iterator() {
            return this._segment_list.iterator();
        }

        public void add(Segment segment) {
            int insert_position = this._segment_list.size();
            this._segment_list.add(insert_position, segment);
            this.notify_list_data_listeners(new ListDataEvent(this, 1, insert_position, insert_position));
        }

        public void remove(Segment segment) {
            int remove_position = this._segment_list.indexOf(segment);
            this._segment_list.remove(segment);
            this.notify_list_data_listeners(new ListDataEvent(this, 2, remove_position, remove_position));
        }

        public void clear() {
            int last_item_removed = this._segment_list.size() - 1;
            this._segment_list.clear();
            this.notify_list_data_listeners(new ListDataEvent(this, 2, 0, last_item_removed));
        }

        public void move_segment_up(Segment segment) {
            int segment_position = this._segment_list.indexOf(segment);
            int swap_position = segment_position - 1;
            this.swap_segments(segment_position, swap_position);
        }

        private void swap_segments(int segment_position, int swap_position) {
            Collections.swap(this._segment_list, segment_position, swap_position);
            this.notify_list_data_listeners(new ListDataEvent(this, 0, segment_position, swap_position));
        }

        public void move_segment_down(Segment segment) {
            int segment_position = this._segment_list.indexOf(segment);
            int swap_position = segment_position + 1;
            this.swap_segments(segment_position, swap_position);
        }
    }

    private static final class SegmentState {
        private boolean _active = true;
        private float _surface_opacity = 0.0f;
        private SegmentNormalMerger _normal_merger = SegmentNormalMerger.GLOBAL_NORMAL;
        private boolean _surface_rendering = false;
        private boolean _show_backplane = true;
        private float _contour_size = 1.0f;
        private Color _contour_color = Color.BLACK;

        private SegmentState() {
        }

        public boolean is_active() {
            return this._active;
        }

        public float get_contour_size() {
            return this._contour_size;
        }

        public void set_contour_size(float contour_size) {
            this._contour_size = contour_size;
        }

        public Color get_contour_color() {
            return this._contour_color;
        }

        public void set_contour_color(Color contour_color) {
            this._contour_color = contour_color;
        }

        public void set_active(boolean active) {
            this._active = active;
        }

        public float get_surface_opacity() {
            return this._surface_opacity;
        }

        public void set_surface_opacity(float surfaceOpacity) {
            this._surface_opacity = surfaceOpacity;
        }

        public SegmentNormalMerger get_normal_merger() {
            return this._normal_merger;
        }

        public void set_normal_merger(SegmentNormalMerger normalMerger) {
            this._normal_merger = normalMerger;
        }

        public void set_surface_rendering(boolean _surface_rendering) {
            this._surface_rendering = _surface_rendering;
        }

        public boolean is_surface_rendering() {
            return this._surface_rendering;
        }

        public void set_show_backplane(boolean _show_backplane) {
            this._show_backplane = _show_backplane;
        }

        public boolean is_show_backplane() {
            return this._show_backplane;
        }
    }
}

