/*
 * Decompiled with CFR 0.152.
 */
package raycaster.gui;

import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.media.j3d.Transform3D;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.NumberFormatter;
import javax.vecmath.Vector3f;
import jgridmaker.GMPanel;
import main.MasterControl;
import main.tools.ToolRayCasting;
import misc.grid.RegularGrid3i;
import raycaster.RayCastingRenderer;
import raycaster.settings.LightingSettings;
import raycaster.settings.RenderSettings;
import settings.Settings;

public final class SequenceTab
extends GMPanel {
    private State _state;
    private final ToolRayCasting _tool_instance;
    private final JButton _jb_render;
    private final JButton _jb_record;
    private final JButton _jb_clear;
    private final JFormattedTextField _jtf_fps;
    private final JTextField _jtf_path_name;
    private final JLabel _state_label;
    private final JTextField _mencoder_command;
    private final Deque<RenderSettings> _setting_records;
    private final ScheduledExecutorService _scheduled_executor;
    private ScheduledFuture<?> _schedled_future = null;
    private RenderImage _render_runner = null;
    private final AbstractAction _goto_start = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SequenceTab.this.start();
        }
    };
    private final AbstractAction _goto_recording = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SequenceTab.this.recording();
        }
    };
    private final AbstractAction _goto_recording_paused = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SequenceTab.this.recording_paused();
        }
    };
    private final AbstractAction _goto_rendering = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SequenceTab.this.rendering();
        }
    };
    private final AbstractAction _goto_rendering_paused = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SequenceTab.this.rendering_paused();
        }
    };

    public SequenceTab(ToolRayCasting tool_instance) {
        this._tool_instance = tool_instance;
        this._jb_record = new JButton();
        this._jb_clear = new JButton();
        this._jb_render = new JButton();
        this._state_label = new JLabel();
        this._jtf_path_name = new JTextField(25);
        this._mencoder_command = new JTextField(25);
        NumberFormatter fps_formatter = new NumberFormatter(NumberFormat.getNumberInstance());
        fps_formatter.setMinimum(new Integer(1));
        fps_formatter.setMaximum(new Integer(60));
        this._jtf_fps = new JFormattedTextField(fps_formatter);
        this._jtf_fps.setColumns(6);
        this._jtf_fps.setValue(new Integer(10));
        this._setting_records = new LinkedList<RenderSettings>();
        this._scheduled_executor = Executors.newSingleThreadScheduledExecutor();
        this._schedled_future = null;
        this.add("_jb_record", this._jb_record);
        this.add("_jb_clear", this._jb_clear);
        this.add("_jb_render", this._jb_render);
        this.add("_state_label", this._state_label);
        this.add("_jtf_fps", this._jtf_fps);
        this.add("_jtf_path_name", this._jtf_path_name);
        this.add("_mencoder_command", this._mencoder_command);
        this.set_layout("<table>  <tr>    <td>      <table>        <tr>          <td>::_jb_record::</td>        </tr><tr>          <td>::_jb_clear::</td>        </tr><tr>          <td>::_jb_render::</td>        </tr><tr>          <td>::_state_label::</td>        </tr>      </table>    </td>    <td>      <table>        <tr>          <td anchor='east'>save to directory:</td>          <td anchor='west'>::_jtf_path_name::</td>        </tr><tr>          <td anchor='east'>mencoder cmd</td>          <td anchor='west'>::_mencoder_command::</td>       </tr><tr>          <td anchor='east'>frames per second:</td>          <td anchor='west'>::_jtf_fps::</td>        </tr>      </table>    </td>  </tr></table>");
        this.start();
    }

    private final void start() {
        if (this._schedled_future != null) {
            this._schedled_future.cancel(false);
        }
        if (this._render_runner != null) {
            this._mencoder_command.setText(this._render_runner.get_command());
        }
        this._state = State.START;
        this._jb_record.setEnabled(true);
        this._jb_record.setAction(this._goto_recording);
        this._jb_record.setText("start recording");
        this._jb_clear.setEnabled(false);
        this._jb_clear.setText("clear");
        this._jb_render.setEnabled(false);
        this._jb_render.setText("start rendering");
        this._jtf_fps.setEnabled(true);
        this._jtf_path_name.setEnabled(true);
        this._jtf_path_name.setText(this.make_base_path());
        this._setting_records.clear();
        this._render_runner = null;
        this._state_label.setText("ready");
    }

    private final void recording() {
        this._state = State.RECORDING;
        this._state_label.setText("recording");
        this._jb_record.setEnabled(true);
        this._jb_record.setAction(this._goto_recording_paused);
        this._jb_record.setText("stop/pause recording");
        this._jb_clear.setEnabled(true);
        this._jb_clear.setAction(this._goto_start);
        this._jb_clear.setText("clear");
        this._jb_render.setEnabled(false);
        this._jb_render.setText("start rendering");
        this._jtf_fps.setEnabled(false);
        int fps = (Integer)this._jtf_fps.getValue();
        System.out.println("recoding with " + fps + "fps");
        long period_ns = 1000000000 / fps;
        System.out.println("period: " + period_ns + "ns");
        this._schedled_future = this._scheduled_executor.scheduleAtFixedRate(new MakeRecord(), 0L, period_ns, TimeUnit.NANOSECONDS);
    }

    private final void recording_paused() {
        this._state = State.RECORDING_PAUSED;
        this._state_label.setText("paused (" + this._setting_records.size() + " frames)");
        this._jb_record.setEnabled(true);
        this._jb_record.setAction(this._goto_recording);
        this._jb_record.setText("continue recording");
        this._jb_clear.setEnabled(true);
        this._jb_clear.setAction(this._goto_start);
        this._jb_clear.setText("clear");
        this._jb_render.setEnabled(true);
        this._jb_render.setAction(this._goto_rendering);
        this._jb_render.setText("start rendering");
        this._jtf_fps.setEnabled(false);
        this._schedled_future.cancel(false);
    }

    private final void rendering() {
        this._state = State.RENDERING;
        this._state_label.setText(this._state.toString());
        this._jb_record.setEnabled(false);
        this._jb_record.setText("start recording");
        this._jb_clear.setEnabled(true);
        this._jb_clear.setAction(this._goto_start);
        this._jb_clear.setText("abort rendering");
        this._jb_render.setEnabled(true);
        this._jb_render.setAction(this._goto_rendering_paused);
        this._jb_render.setText("pause rendering");
        this._jtf_fps.setEnabled(false);
        if (this._render_runner == null) {
            this._render_runner = new RenderImage();
        }
        this._schedled_future = this._scheduled_executor.scheduleWithFixedDelay(new RenderImage(), 1L, 1L, TimeUnit.NANOSECONDS);
    }

    private final void rendering_paused() {
        this._state = State.RENDERING_PAUSED;
        this._state_label.setText(this._state.toString());
        this._jb_record.setEnabled(false);
        this._jb_record.setText("start recording");
        this._jb_clear.setEnabled(true);
        this._jb_clear.setAction(this._goto_start);
        this._jb_clear.setText("abort rendering");
        this._jb_render.setEnabled(true);
        this._jb_render.setAction(this._goto_rendering);
        this._jb_render.setText("continue rendering");
        this._jtf_fps.setEnabled(false);
        this._schedled_future.cancel(false);
        this._state_label.setText("rendering paused (" + this._setting_records.size() + " frames remaining)");
    }

    private final String make_base_path() {
        Date date = new Date();
        SimpleDateFormat date_format = new SimpleDateFormat(Settings.get_str_option(this._tool_instance, ToolRayCasting.OPT_DATE_FORMAT_STRING));
        String results_dir = Settings.get_str_option(this._tool_instance, ToolRayCasting.OPT_RESULT_DIR);
        return String.valueOf(results_dir) + "/seq" + date_format.format(date);
    }

    private final class MakeRecord
    implements Runnable {
        private MakeRecord() {
        }

        @Override
        public void run() {
            RenderSettings rs = SequenceTab.this._tool_instance.get_render_settings();
            SequenceTab.this._setting_records.push(rs);
            SequenceTab.this._state_label.setText("recording (" + SequenceTab.this._setting_records.size() + " frames)");
        }
    }

    private final class RenderImage
    implements Runnable {
        private final RegularGrid3i _voxel_cube = MasterControl.get_is().get_voxel_cube();
        private final String _path_name;
        private int _frame_number;

        public RenderImage() {
            this._path_name = SequenceTab.this._jtf_path_name.getText();
            this._frame_number = 1;
        }

        @Override
        public void run() {
            if (SequenceTab.this._setting_records.isEmpty()) {
                SequenceTab.this._schedled_future.cancel(false);
                SequenceTab.this.start();
                return;
            }
            SequenceTab.this._state_label.setText("rendering (" + SequenceTab.this._setting_records.size() + " frames remaining)");
            RenderSettings settings = (RenderSettings)SequenceTab.this._setting_records.pollLast();
            RayCastingRenderer renderer = new RayCastingRenderer(settings, this._voxel_cube);
            BufferedImage bimg = new BufferedImage(settings.get_width(), settings.get_height(), 2);
            int[] img_data = ((DataBufferInt)bimg.getRaster().getDataBuffer()).getData();
            renderer.render(img_data, null, null);
            String file_name = this.make_file_name(this._path_name, this._frame_number);
            ToolRayCasting.write_image(bimg, file_name);
            ++this._frame_number;
        }

        private final RenderSettings combine_settings(RenderSettings quality_settings, RenderSettings appearance_settings) {
            Transform3D view_transform = new Transform3D();
            view_transform.set(appearance_settings.get_view_transform());
            Transform3D world_transform = new Transform3D();
            world_transform.set(appearance_settings.get_world_transform());
            LightingSettings app_light = appearance_settings.get_lighting_settings();
            LightingSettings q_light = quality_settings.get_lighting_settings();
            Vector3f light_dir = app_light.get_light_direction();
            LightingSettings lighting_settings = new LightingSettings();
            lighting_settings.set_use_lighting(app_light.get_use_lighting());
            lighting_settings.set_ambient(app_light.get_ambient());
            lighting_settings.set_diffuse(app_light.get_diffuse());
            lighting_settings.set_light_direction(light_dir);
            lighting_settings.set_specular(app_light.get_specular());
            lighting_settings.set_specular_exponent(app_light.get_specular_exponent());
            lighting_settings.set_gradient_settings(q_light.get_gradient_settings());
            RenderSettings render_settings = new RenderSettings();
            render_settings.set_segment_settings(appearance_settings.get_segment_settings());
            render_settings.set_lighting_settings(lighting_settings);
            render_settings.set_height(quality_settings.get_height());
            render_settings.set_width(quality_settings.get_width());
            render_settings.set_filter_settings(quality_settings.get_filter_settings());
            render_settings.set_ray_termination(quality_settings.get_ray_termination());
            render_settings.set_sampling_rate(quality_settings.get_sampling_rate());
            render_settings.set_thread_count(quality_settings.get_thread_count());
            render_settings.set_use_octree(quality_settings.is_use_octree());
            render_settings.set_light_transform(appearance_settings.get_light_transform());
            render_settings.set_view_transform(view_transform);
            render_settings.set_world_transform(world_transform);
            return render_settings;
        }

        private final String make_file_name(String path, int sequence_number) {
            String ni = Integer.toString(sequence_number);
            while (ni.length() < 5) {
                ni = "0" + ni;
            }
            return String.valueOf(path) + "/image" + ni + ".png";
        }

        public final String get_command() {
            int fps = (Integer)SequenceTab.this._jtf_fps.getValue();
            return "mencoder \"mf://" + this._path_name + "/image*.png\"" + " -mf fps=" + fps + ":type=png -ovc lavc -lavcopts" + " vcodec=mpeg4 -of avi -o /tmp/video.avi";
        }
    }

    private static enum State {
        START,
        RECORDING,
        RECORDING_PAUSED,
        RENDERING,
        RENDERING_PAUSED;

    }
}

