/*
 * Decompiled with CFR 0.152.
 */
package raycaster.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import main.tools.ToolRayCasting;
import raycaster.gui.StyleImage;
import raycaster.gui.TransferFunctionTab;
import raycaster.renderer.RenderMethod;
import settings.Settings;
import settings.SettingsListener;

public class StyleChooser
extends JComponent
implements SettingsListener {
    public static final String COLOR_CHANGE = "Color Changed";
    public static final String STYLE_CHANGE = "Style Changed";
    private static final String DEFAULT_STYLE_PATH = "sphere1.png";
    private final JLabel _style_display;
    private final JButton _style_choose;
    private final JFileChooser _file_chooser = new JFileChooser(String.valueOf(Settings.get_str_option(ToolRayCasting.class, ToolRayCasting.OPT_RESOURCES_DIR)) + File.separator + "brushes");
    private final BufferedImage _image = new BufferedImage(1, 1, 2);
    private RenderMethod.Style _style_type = TransferFunctionTab.get_current_render_method().get_style();
    private static final Color _default_color = Color.blue;
    private static final StyleImage _default_style = StyleChooser.init_default_style();
    private Color _color = _default_color;
    private StyleImage _style = _default_style;

    private static StyleImage init_default_style() {
        StyleImage default_style = null;
        try {
            default_style = StyleImage.create(DEFAULT_STYLE_PATH);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return default_style;
    }

    public StyleChooser() {
        this._style_display = new JLabel();
        int size = StyleImage.get_icon_size();
        this._style_display.setPreferredSize(new Dimension(size, size));
        this._style_choose = new JButton("New Style");
        this._style_choose.addActionListener(this.create_style_chooser_listener());
        this.add(this._style_display);
        this.add(this._style_choose);
        this.setLayout(new FlowLayout());
        this.repaint();
        Settings.register_class_listener(TransferFunctionTab.class, this);
    }

    private ActionListener create_style_chooser_listener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (StyleChooser.this._style_type) {
                    case COLOR: {
                        Color new_color = JColorChooser.showDialog(null, "Choose BG Color", StyleChooser.this._color);
                        if (new_color != null) {
                            StyleChooser.this.set_color_and_repaint(new_color);
                        }
                        return;
                    }
                    case IMAGE: {
                        if (StyleChooser.this._file_chooser.showOpenDialog(StyleChooser.this) == 0) {
                            try {
                                StyleImage style = StyleImage.create(StyleChooser.this._file_chooser.getSelectedFile());
                                StyleChooser.this.set_style_and_repaint(style);
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                            }
                        }
                        return;
                    }
                }
            }
        };
    }

    public StyleImage get_style() {
        return this._style;
    }

    public static StyleImage get_default_style() {
        return _default_style;
    }

    public void set_style_and_repaint(StyleImage style) {
        this._style = style;
        this.repaint();
        this.firePropertyChange(STYLE_CHANGE, null, style);
    }

    @Override
    public void repaint() {
        super.repaint();
        switch (this._style_type) {
            case COLOR: {
                this.paint_color(this._color);
                break;
            }
            case IMAGE: {
                this.paint_style(this._style);
                break;
            }
            case BLANK: {
                this.paint_blank();
            }
        }
    }

    private void paint_style(StyleImage style) {
        this._style_display.setIcon(style.get_icon());
    }

    public Color get_color() {
        return this._color;
    }

    public static Color get_default_color() {
        return _default_color;
    }

    public void set_color_and_repaint(Color color) {
        this._color = color;
        this.repaint();
        this.firePropertyChange(COLOR_CHANGE, null, color);
    }

    private void paint_color(Color color) {
        Graphics2D g = this._image.createGraphics();
        g.setColor(color);
        g.drawRect(0, 0, 1, 1);
        Dimension size = this._style_display.getPreferredSize();
        int width = size.width;
        int height = size.height;
        ImageIcon icon = new ImageIcon(this._image.getScaledInstance(width, height, 2));
        this._style_display.setIcon(icon);
        g.dispose();
    }

    private void paint_blank() {
        Graphics2D g = this._image.createGraphics();
        g.clearRect(0, 0, 1, 1);
        Dimension size = this._style_display.getPreferredSize();
        int width = size.width;
        int height = size.height;
        ImageIcon icon = new ImageIcon(this._image.getScaledInstance(width, height, 2));
        this._style_display.setIcon(icon);
        g.dispose();
    }

    private void set_style_type(RenderMethod.Style mode) {
        this._style_type = mode;
        switch (mode) {
            case COLOR: {
                this._style_choose.setEnabled(true);
                break;
            }
            case IMAGE: {
                this._style_choose.setEnabled(true);
                break;
            }
            case BLANK: {
                this._style_choose.setEnabled(false);
            }
        }
        this.repaint();
    }

    public RenderMethod.Style get_display_mode() {
        return this._style_type;
    }

    @Override
    public void settings_changed(Object obj, String optName, Object opt) {
        if (optName == TransferFunctionTab.OPT_RENDER_METHOD) {
            this.set_style_type(((RenderMethod)((Object)opt)).get_style());
        }
    }
}

