/*
 * Decompiled with CFR 0.152.
 */
package raycaster.gui;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import raycaster.LitSphereMapFile;
import raycaster.gui.TransferFunctionPanel;
import settings.Settings;
import settings.SettingsListener;

public class StyleImage
implements SettingsListener {
    private static final int iconSize = 25;
    private static int smallIconSize = Settings.get_int_option(TransferFunctionPanel.class, TransferFunctionPanel.OPT_CONTROL_POINT_SIZE);
    private static final Cache cache = new Cache();
    private String _file_name;
    private String _absolute_path;
    private final BufferedImage _image;
    private final ImageIcon _icon;
    private ImageIcon _small_icon;

    public static boolean delete(StyleImage image) {
        return StyleImage.cache.delete(image.get_absolute_path());
    }

    public static Iterator<StyleImage> get_iterator() {
        return StyleImage.cache.get_iterator();
    }

    public static StyleImage create(String s) throws IOException {
        return StyleImage.create(LitSphereMapFile.create(s));
    }

    public static StyleImage create(File source) throws IOException {
        return StyleImage.create(LitSphereMapFile.create(source));
    }

    public static StyleImage create(LitSphereMapFile source) throws IOException {
        if (StyleImage.cache.contains(source.get_trimmed_path())) {
            return StyleImage.cache.get(source.get_trimmed_path());
        }
        StyleImage result = StyleImage.create(ImageIO.read(source));
        result._file_name = source.getName();
        result._absolute_path = source.get_trimmed_path();
        StyleImage.cache.add(result);
        return result;
    }

    public static StyleImage create(BufferedImage buffered_image) {
        StyleImage result = new StyleImage(buffered_image);
        StyleImage.cache.add(result);
        return result;
    }

    private StyleImage(BufferedImage bimg) {
        this._image = new BufferedImage(bimg.getWidth(), bimg.getHeight(), 2);
        this._image.createGraphics().drawImage((Image)bimg, 0, 0, null);
        this._icon = new ImageIcon(this._image.getScaledInstance(25, 25, 4));
        this.create_small_icon();
        this._file_name = "DEBUG_" + this._image.hashCode();
        this._absolute_path = "DEBUG_ABSOLUTE_" + this._image.hashCode();
        Settings.register_class_listener(TransferFunctionPanel.class, this);
    }

    public String get_file_name() {
        return this._file_name;
    }

    public String get_absolute_path() {
        return this._absolute_path;
    }

    public BufferedImage get_image() {
        return this._image;
    }

    public ImageIcon get_icon() {
        return this._icon;
    }

    public ImageIcon get_small_icon() {
        return this._small_icon;
    }

    public static int get_small_icon_size() {
        return smallIconSize;
    }

    public static int get_icon_size() {
        return 25;
    }

    private void create_small_icon() {
        this._small_icon = new ImageIcon(this._icon.getImage().getScaledInstance(smallIconSize, smallIconSize, 2));
    }

    @Override
    public void settings_changed(Object obj, String optName, Object opt) {
        if (obj == TransferFunctionPanel.class && optName == TransferFunctionPanel.OPT_CONTROL_POINT_SIZE) {
            smallIconSize = Settings.get_int_option(TransferFunctionPanel.class, TransferFunctionPanel.OPT_CONTROL_POINT_SIZE);
            this.create_small_icon();
        }
    }

    private static final class Cache {
        private final Map<String, WeakReference<StyleImage>> _style_cache = new HashMap<String, WeakReference<StyleImage>>();

        private Cache() {
        }

        private void add(StyleImage style) {
            String key = style.get_absolute_path();
            if (this._style_cache.containsKey(key) && this._style_cache.get(key).get() == null) {
                this._style_cache.remove(key);
            }
            this._style_cache.put(style.get_absolute_path(), new WeakReference<StyleImage>(style));
        }

        private StyleImage get(String source) {
            return (StyleImage)this._style_cache.get(source).get();
        }

        private boolean contains(String source) {
            return this._style_cache.containsKey(source);
        }

        private boolean delete(String source) {
            return this._style_cache.remove(source) != null;
        }

        private Iterator<StyleImage> get_iterator() {
            ArrayList<StyleImage> list = new ArrayList<StyleImage>(this._style_cache.size());
            for (WeakReference<StyleImage> ref : this._style_cache.values()) {
                list.add((StyleImage)ref.get());
            }
            return list.iterator();
        }
    }
}

